/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlListboxRendererBase
extends HtmlRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            Integer i;
            int size = uiComponent instanceof HtmlSelectManyListbox ? ((HtmlSelectManyListbox)uiComponent).getSize() : ((i = (Integer)uiComponent.getAttributes().get("size")) != null ? i : 0);
            HtmlRendererUtils.renderListbox(facesContext, (UISelectMany)uiComponent, this.isDisabled(facesContext, uiComponent), size);
        } else if (uiComponent instanceof HtmlSelectOneListbox) {
            Integer i;
            int size = uiComponent instanceof HtmlSelectOneListbox ? ((HtmlSelectOneListbox)uiComponent).getSize() : ((i = (Integer)uiComponent.getAttributes().get("size")) != null ? i : 0);
            HtmlRendererUtils.renderListbox(facesContext, (UISelectOne)uiComponent, this.isDisabled(facesContext, uiComponent), size);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        boolean readonly;
        boolean disabled;
        if (uiComponent instanceof HtmlSelectManyListbox) {
            disabled = ((HtmlSelectManyListbox)uiComponent).isDisabled();
            readonly = ((HtmlSelectManyListbox)uiComponent).isReadonly();
        } else if (uiComponent instanceof HtmlSelectOneListbox) {
            disabled = ((HtmlSelectOneListbox)uiComponent).isDisabled();
            readonly = ((HtmlSelectOneListbox)uiComponent).isReadonly();
        } else {
            disabled = RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
            readonly = RendererUtils.getBooleanAttribute(uiComponent, "readonly", false);
        }
        if (!disabled && readonly) {
            disabled = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isReadonlyAsDisabledForSelect();
        }
        return disabled;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, uiComponent);
        } else if (uiComponent instanceof UISelectOne) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)uiComponent, submittedValue);
        }
        if (uiComponent instanceof UISelectOne) {
            return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)((UISelectOne)uiComponent), submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
    }
}

