/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryUriUtils;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.file.FileTransporter;

@Named(value="file")
public final class FileTransporterFactory
implements TransporterFactory {
    public static final String NAME = "file";
    private float priority;

    public float getPriority() {
        return this.priority;
    }

    public FileTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        String repositoryUrl = repository.getUrl();
        if (repositoryUrl.startsWith("bundle:")) {
            try {
                repositoryUrl = repositoryUrl.substring("bundle:".length());
                URI bundlePath = URI.create("jar:" + Paths.get(RepositoryUriUtils.toUri((String)repositoryUrl)).toAbsolutePath().toUri().toASCIIString());
                HashMap env = new HashMap();
                FileSystem fileSystem = FileSystems.newFileSystem(bundlePath, env);
                return new FileTransporter(fileSystem, true, false, fileSystem.getPath(fileSystem.getSeparator(), new String[0]), FileTransporter.WriteOp.COPY);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        FileTransporter.WriteOp writeOp = FileTransporter.WriteOp.COPY;
        if (repositoryUrl.startsWith("symlink+")) {
            writeOp = FileTransporter.WriteOp.SYMLINK;
            repositoryUrl = repositoryUrl.substring("symlink+".length());
        } else if (repositoryUrl.startsWith("hardlink+")) {
            writeOp = FileTransporter.WriteOp.HARDLINK;
            repositoryUrl = repositoryUrl.substring("hardlink+".length());
        }
        try {
            Path basePath = Paths.get(RepositoryUriUtils.toUri((String)repositoryUrl)).toAbsolutePath();
            return new FileTransporter(basePath.getFileSystem(), false, !basePath.getFileSystem().isReadOnly(), basePath, writeOp);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e) {
            throw new NoTransporterException(repository, (Throwable)e);
        }
    }
}

