/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.io.Reader;
import org.apache.manifoldcf.scriptengine.CharacterStream;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;

public class BasicTokenStream
implements TokenStream {
    protected CharacterStream characterStream;
    protected Token currentToken = null;

    public BasicTokenStream(Reader reader) {
        this.characterStream = new CharacterStream(reader);
    }

    @Override
    public Token peek() throws ScriptException {
        if (this.currentToken == null) {
            this.currentToken = this.parseNextToken();
        }
        return this.currentToken;
    }

    @Override
    public void skip() {
        this.currentToken = null;
    }

    protected Token parseNextToken() throws ScriptException {
        char y;
        int x;
        int characterNumber;
        int lineNumber;
        while (true) {
            lineNumber = this.characterStream.getLineNumber();
            characterNumber = this.characterStream.getCharacterNumber();
            x = this.characterStream.peek();
            if (x == -1) {
                return null;
            }
            y = (char)x;
            if (y <= ' ') {
                this.characterStream.skip();
                continue;
            }
            if (y != '#') break;
            do {
                if ((x = this.characterStream.peek()) == -1) {
                    return null;
                }
                this.characterStream.skip();
            } while ((y = (char)x) != '\n');
        }
        if (BasicTokenStream.isQuoteCharacter(y)) {
            int x2;
            StringBuilder tokenBuffer = new StringBuilder();
            char quoteMark = y;
            this.characterStream.skip();
            while ((x2 = this.characterStream.peek()) != -1) {
                y = (char)x2;
                this.characterStream.skip();
                if (y == quoteMark) break;
                if (y == '\\') {
                    x2 = this.characterStream.peek();
                    if (x2 == -1) continue;
                    tokenBuffer.append((char)x2);
                    this.characterStream.skip();
                    continue;
                }
                tokenBuffer.append(y);
            }
            return new Token(1, tokenBuffer.toString(), lineNumber, characterNumber);
        }
        if (BasicTokenStream.isTokenCharacter(y)) {
            int x3;
            StringBuilder tokenBuffer = new StringBuilder();
            while ((x3 = this.characterStream.peek()) != -1 && (BasicTokenStream.isTokenCharacter(y = (char)x3) || BasicTokenStream.isNumberCharacter(y))) {
                this.characterStream.skip();
                tokenBuffer.append(y);
            }
            return new Token(4, tokenBuffer.toString(), lineNumber, characterNumber);
        }
        if (BasicTokenStream.isNumberCharacter(y)) {
            int x4;
            StringBuilder tokenBuffer = new StringBuilder();
            boolean seenDot = false;
            while ((x4 = this.characterStream.peek()) != -1) {
                y = (char)x4;
                if (BasicTokenStream.isNumberCharacter(y)) {
                    tokenBuffer.append(y);
                    this.characterStream.skip();
                    continue;
                }
                if (y != '.' || seenDot) break;
                tokenBuffer.append(y);
                seenDot = true;
                this.characterStream.skip();
            }
            if (seenDot) {
                return new Token(3, tokenBuffer.toString(), lineNumber, characterNumber);
            }
            return new Token(2, tokenBuffer.toString(), lineNumber, characterNumber);
        }
        this.characterStream.skip();
        if ((y == '=' || y == '!' || y == '>' || y == '<' || y == '&' || y == '|') && (x = this.characterStream.peek()) != -1) {
            char q = (char)x;
            if (y == '=' && q == '=' || y == '!' && q == '=' || y == '>' && q == '=' || y == '<' && q == '=' || y == '&' && q == '&' || y == '|' && q == '|' || y == '>' && q == '>' || y == '<' && q == '<') {
                this.characterStream.skip();
                return new Token(0, "" + y + q, lineNumber, characterNumber);
            }
        }
        return new Token(0, "" + y, lineNumber, characterNumber);
    }

    protected static boolean isQuoteCharacter(char x) {
        return x == '\'' || x == '\"';
    }

    protected static boolean isNumberCharacter(char x) {
        return x >= '0' && x <= '9';
    }

    protected static boolean isTokenCharacter(char x) {
        if (x >= 'a' && x <= 'z') {
            return true;
        }
        if (x >= 'A' && x <= 'Z') {
            return true;
        }
        return x == '_' || x == '$' || x == '@';
    }
}

