/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.http2.BufferingFlowControlStrategy;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class HTTP2Client
extends ContainerLifeCycle {
    private Executor executor;
    private Scheduler scheduler;
    private ByteBufferPool bufferPool;
    private ClientConnectionFactory connectionFactory;
    private SelectorManager selector;
    private int selectors = 1;
    private long idleTimeout = 30000L;
    private long connectTimeout = 10000L;
    private long streamIdleTimeout;
    private boolean connectBlocking;
    private SocketAddress bindAddress;
    private boolean tcpNoDelay = true;
    private int inputBufferSize = 8192;
    private List<String> protocols = Arrays.asList("h2", "h2-17", "h2-16", "h2-15", "h2-14");
    private int initialSessionRecvWindow = 0x1000000;
    private int initialStreamRecvWindow = 0x800000;
    private int maxFrameSize = 16384;
    private int maxConcurrentPushedStreams = 32;
    private int maxSettingsKeys = 64;
    private int maxDecoderTableCapacity = 4096;
    private int maxEncoderTableCapacity = 4096;
    private int maxHeaderBlockFragment = 0;
    private int maxResponseHeadersSize = 8192;
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);

    protected void doStart() throws Exception {
        if (this.executor == null) {
            this.setExecutor((Executor)new QueuedThreadPool());
        }
        if (this.scheduler == null) {
            this.setScheduler((Scheduler)new ScheduledExecutorScheduler());
        }
        if (this.bufferPool == null) {
            this.setByteBufferPool((ByteBufferPool)new MappedByteBufferPool());
        }
        if (this.connectionFactory == null) {
            HTTP2ClientConnectionFactory h2 = new HTTP2ClientConnectionFactory();
            this.setClientConnectionFactory((endPoint, context) -> {
                HTTP2ClientConnectionFactory factory = h2;
                SslContextFactory sslContextFactory = (SslContextFactory)context.get("ssl.context.factory");
                if (sslContextFactory != null) {
                    ALPNClientConnectionFactory alpn = new ALPNClientConnectionFactory(this.getExecutor(), (ClientConnectionFactory)h2, this.getProtocols());
                    factory = this.newSslClientConnectionFactory(sslContextFactory, (ClientConnectionFactory)alpn);
                }
                return factory.newConnection(endPoint, context);
            });
        }
        if (this.selector == null) {
            this.selector = this.newSelectorManager();
            this.addBean(this.selector);
        }
        this.selector.setConnectTimeout(this.getConnectTimeout());
        super.doStart();
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory connectionFactory) {
        return new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), connectionFactory);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public void setByteBufferPool(ByteBufferPool bufferPool) {
        this.updateBean(this.bufferPool, bufferPool);
        this.bufferPool = bufferPool;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public void setClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        this.updateBean(this.connectionFactory, connectionFactory);
        this.connectionFactory = connectionFactory;
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    @ManagedAttribute(value="The number of selectors")
    public int getSelectors() {
        return this.selectors;
    }

    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    @ManagedAttribute(value="The idle timeout in milliseconds")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @ManagedAttribute(value="The stream idle timeout in milliseconds")
    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    @ManagedAttribute(value="The connect timeout in milliseconds")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        SelectorManager selector = this.selector;
        if (selector != null) {
            selector.setConnectTimeout(connectTimeout);
        }
    }

    @ManagedAttribute(value="Whether the connect() operation is blocking")
    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public void setConnectBlocking(boolean connectBlocking) {
        this.connectBlocking = connectBlocking;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @ManagedAttribute(value="The size of the buffer used to read from the network")
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @ManagedAttribute(value="The ALPN protocol list")
    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    @Deprecated
    @ManagedAttribute(value="The max frame length in bytes")
    public int getMaxFrameLength() {
        return this.getMaxFrameSize();
    }

    @Deprecated
    public void setMaxFrameLength(int maxFrameLength) {
        this.setMaxFrameSize(maxFrameLength);
    }

    @ManagedAttribute(value="The max frame size in bytes")
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @ManagedAttribute(value="The max number of concurrent pushed streams")
    public int getMaxConcurrentPushedStreams() {
        return this.maxConcurrentPushedStreams;
    }

    public void setMaxConcurrentPushedStreams(int maxConcurrentPushedStreams) {
        this.maxConcurrentPushedStreams = maxConcurrentPushedStreams;
    }

    @ManagedAttribute(value="The max number of keys in all SETTINGS frames")
    public int getMaxSettingsKeys() {
        return this.maxSettingsKeys;
    }

    public void setMaxSettingsKeys(int maxSettingsKeys) {
        this.maxSettingsKeys = maxSettingsKeys;
    }

    @ManagedAttribute(value="The HPACK encoder dynamic table maximum capacity")
    public int getMaxEncoderTableCapacity() {
        return this.maxEncoderTableCapacity;
    }

    public void setMaxEncoderTableCapacity(int maxEncoderTableCapacity) {
        this.maxEncoderTableCapacity = maxEncoderTableCapacity;
    }

    @ManagedAttribute(value="The HPACK decoder dynamic table maximum capacity")
    public int getMaxDecoderTableCapacity() {
        return this.maxDecoderTableCapacity;
    }

    public void setMaxDecoderTableCapacity(int maxDecoderTableCapacity) {
        this.maxDecoderTableCapacity = maxDecoderTableCapacity;
    }

    @Deprecated
    @ManagedAttribute(value="The HPACK dynamic table maximum size")
    public int getMaxDynamicTableSize() {
        return this.getMaxDecoderTableCapacity();
    }

    @Deprecated
    public void setMaxDynamicTableSize(int maxDynamicTableSize) {
        this.setMaxDecoderTableCapacity(maxDynamicTableSize);
    }

    @ManagedAttribute(value="The max size of header block fragments")
    public int getMaxHeaderBlockFragment() {
        return this.maxHeaderBlockFragment;
    }

    public void setMaxHeaderBlockFragment(int maxHeaderBlockFragment) {
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
    }

    @ManagedAttribute(value="The max size of response headers")
    public int getMaxResponseHeadersSize() {
        return this.maxResponseHeadersSize;
    }

    public void setMaxResponseHeadersSize(int maxResponseHeadersSize) {
        this.maxResponseHeadersSize = maxResponseHeadersSize;
    }

    public void connect(InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(null, address, listener, promise);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(sslContextFactory, address, listener, promise, null);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        try {
            SocketChannel channel = SocketChannel.open();
            SocketAddress bindAddress = this.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(channel);
            boolean connected = true;
            if (this.isConnectBlocking()) {
                channel.socket().connect(address, (int)this.getConnectTimeout());
                channel.configureBlocking(false);
            } else {
                channel.configureBlocking(false);
                connected = channel.connect(address);
            }
            context = this.contextFrom(sslContextFactory, address, listener, promise, context);
            if (connected) {
                this.selector.accept((SelectableChannel)channel, context);
            } else {
                this.selector.connect((SelectableChannel)channel, context);
            }
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    public void accept(SslContextFactory sslContextFactory, SocketChannel channel, Session.Listener listener, Promise<Session> promise) {
        try {
            if (!channel.isConnected()) {
                throw new IllegalStateException("SocketChannel must be connected");
            }
            channel.configureBlocking(false);
            Map<String, Object> context = this.contextFrom(sslContextFactory, (InetSocketAddress)channel.getRemoteAddress(), listener, promise, null);
            this.selector.accept((SelectableChannel)channel, context);
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    private Map<String, Object> contextFrom(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        if (context == null) {
            context = new ConcurrentHashMap<String, Object>();
        }
        context.put("http2.client", (Object)this);
        context.put("http2.client.sessionListener", listener);
        context.put("http2.client.sessionPromise", promise);
        if (sslContextFactory != null) {
            context.put("ssl.context.factory", sslContextFactory);
        }
        context.put("ssl.peer.host", address.getHostString());
        context.put("ssl.peer.port", address.getPort());
        context.putIfAbsent("client.connector", (Object)this);
        return context;
    }

    protected void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(this.isTCPNoDelay());
    }

    private class ClientSelectorManager
    extends SelectorManager {
        private ClientSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) throws IOException {
            SocketChannelEndPoint endp = new SocketChannelEndPoint(channel, selector, selectionKey, this.getScheduler());
            endp.setIdleTimeout(HTTP2Client.this.getIdleTimeout());
            return endp;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            context.put("http2.client.byteBufferPool", HTTP2Client.this.getByteBufferPool());
            context.put("http2.client.executor", this.getExecutor());
            context.put("http2.client.scheduler", this.getScheduler());
            return HTTP2Client.this.getClientConnectionFactory().newConnection(endpoint, context);
        }

        protected void connectionFailed(SelectableChannel channel, Throwable failure, Object attachment) {
            Map context = (Map)attachment;
            if (LOG.isDebugEnabled()) {
                Object host = context.get("ssl.peer.host");
                Object port = context.get("ssl.peer.port");
                LOG.debug("Could not connect to {}:{}", new Object[]{host, port});
            }
            Promise promise = (Promise)context.get("http2.client.sessionPromise");
            promise.failed(failure);
        }
    }
}

