/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.ArrayValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Loader;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.ObjectValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Strategy;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Value;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Node;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.NodeMap;
import java.lang.reflect.Array;
import java.util.Map;

public class TreeStrategy
implements Strategy {
    private final Loader loader = new Loader();
    private final String length;
    private final String label;

    public TreeStrategy() {
        this("class", "length");
    }

    public TreeStrategy(String string, String string2) {
        this.length = string2;
        this.label = string;
    }

    @Override
    public Value read(Type type, NodeMap nodeMap, Map map) {
        Class clazz = this.readValue(type, nodeMap);
        Class clazz2 = type.getType();
        if (clazz2.isArray()) {
            return this.readArray(clazz, nodeMap);
        }
        if (clazz2 != clazz) {
            return new ObjectValue(clazz);
        }
        return null;
    }

    private Value readArray(Class clazz, NodeMap nodeMap) {
        Node node = nodeMap.remove(this.length);
        int n = 0;
        if (node != null) {
            String string = node.getValue();
            n = Integer.parseInt(string);
        }
        return new ArrayValue(clazz, n);
    }

    private Class readValue(Type type, NodeMap nodeMap) {
        Node node = nodeMap.remove(this.label);
        Class clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (node != null) {
            String string = node.getValue();
            clazz = this.loader.load(string);
        }
        return clazz;
    }

    @Override
    public boolean write(Type type, Object object, NodeMap nodeMap, Map map) {
        Class clazz = object.getClass();
        Class clazz2 = type.getType();
        Class clazz3 = clazz;
        if (clazz.isArray()) {
            clazz3 = this.writeArray(clazz2, object, nodeMap);
        }
        if (clazz != clazz2) {
            nodeMap.put(this.label, clazz3.getName());
        }
        return false;
    }

    private Class writeArray(Class clazz, Object object, NodeMap nodeMap) {
        int n = Array.getLength(object);
        if (this.length != null) {
            nodeMap.put(this.length, String.valueOf(n));
        }
        return clazz.getComponentType();
    }
}

