/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Extractor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ExtractorFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Group;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.GroupExtractor$Registry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Format;
import java.lang.annotation.Annotation;

class GroupExtractor
implements Group {
    private final ExtractorFactory factory;
    private final Annotation label;
    private final GroupExtractor$Registry registry;
    private final LabelMap elements;

    public GroupExtractor(Contact contact, Annotation annotation, Format format) {
        this.factory = new ExtractorFactory(contact, annotation, format);
        this.elements = new LabelMap();
        this.registry = new GroupExtractor$Registry(this.elements);
        this.label = annotation;
        this.extract();
    }

    public String[] getNames() {
        return this.elements.getKeys();
    }

    public String[] getPaths() {
        return this.elements.getPaths();
    }

    @Override
    public LabelMap getElements() {
        return this.elements.getLabels();
    }

    @Override
    public Label getLabel(Class clazz) {
        return this.registry.resolve(clazz);
    }

    @Override
    public Label getText() {
        return this.registry.resolveText();
    }

    public boolean isValid(Class clazz) {
        return this.registry.resolve(clazz) != null;
    }

    public boolean isDeclared(Class clazz) {
        return this.registry.containsKey(clazz);
    }

    @Override
    public boolean isInline() {
        for (Label label : this.registry) {
            if (label.isInline()) continue;
            return false;
        }
        return !this.registry.isEmpty();
    }

    @Override
    public boolean isTextList() {
        return this.registry.isText();
    }

    private void extract() {
        Extractor extractor = this.factory.getInstance();
        if (extractor != null) {
            this.extract(extractor);
        }
    }

    private void extract(Extractor extractor) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = extractor.getAnnotations()) {
            this.extract(extractor, annotation);
        }
    }

    private void extract(Extractor extractor, Annotation annotation) {
        Label label = extractor.getLabel(annotation);
        Class clazz = extractor.getType(annotation);
        if (this.registry != null) {
            this.registry.register(clazz, label);
        }
    }

    @Override
    public String toString() {
        return this.label.toString();
    }
}

