/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer$LoggingSuppressor;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer$SuppressingSuppressor;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer$Suppressor;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Closer
implements Closeable {
    private static final Closer$Suppressor SUPPRESSOR = Closer$SuppressingSuppressor.isAvailable() ? Closer$SuppressingSuppressor.INSTANCE : Closer$LoggingSuppressor.INSTANCE;
    final Closer$Suppressor suppressor;
    private final Deque stack = new ArrayDeque(4);
    private @MonotonicNonNull Throwable thrown;

    public static Closer create() {
        return new Closer(SUPPRESSOR);
    }

    Closer(Closer$Suppressor closer$Suppressor) {
        this.suppressor = (Closer$Suppressor)Preconditions.checkNotNull(closer$Suppressor);
    }

    @CanIgnoreReturnValue
    public Closeable register(@Nullable Closeable closeable) {
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return closeable;
    }

    public RuntimeException rethrow(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        this.thrown = throwable;
        Throwables.propagateIfPossible(throwable, IOException.class);
        throw new RuntimeException(throwable);
    }

    @Override
    public void close() {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            Closeable closeable = (Closeable)this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    continue;
                }
                this.suppressor.suppress(closeable, throwable, throwable2);
            }
        }
        if (this.thrown == null && throwable != null) {
            Throwables.propagateIfPossible(throwable, IOException.class);
            throw new AssertionError((Object)throwable);
        }
    }
}

