/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CompactHashMap$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CompactHashMap$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CompactHashMap$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CompactHashMap$EntrySetView;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CompactHashMap$KeySetView;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CompactHashMap$ValuesView;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class CompactHashMap
extends AbstractMap
implements Serializable {
    private transient int @MonotonicNonNull [] table;
    transient long @MonotonicNonNull [] entries;
    transient Object @MonotonicNonNull [] keys;
    transient Object @MonotonicNonNull [] values;
    transient float loadFactor;
    transient int modCount;
    private transient int threshold;
    private transient int size;
    private transient @MonotonicNonNull Set keySetView;
    private transient @MonotonicNonNull Set entrySetView;
    private transient @MonotonicNonNull Collection valuesView;

    private static int[] newTable(int n) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private static int getHash(long l) {
        return (int)(l >>> 32);
    }

    private static int getNext(long l) {
        return (int)l;
    }

    private static long swapNext(long l, int n) {
        return 0xFFFFFFFF00000000L & l | 0xFFFFFFFFL & (long)n;
    }

    void accessEntry(int n) {
    }

    @Override
    @CanIgnoreReturnValue
    public @Nullable Object put(@Nullable Object object, @Nullable Object object2) {
        int n;
        long[] lArray = this.entries;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n2 = Hashing.smearedHash(object);
        int n3 = n2 & this.hashTableMask();
        int n4 = this.size;
        int n5 = this.table[n3];
        if (n5 == -1) {
            this.table[n3] = n4;
        } else {
            long l;
            do {
                n = n5;
                l = lArray[n5];
                if (CompactHashMap.getHash(l) != n2 || !Objects.equal(object, objectArray[n5])) continue;
                Object object3 = objectArray2[n5];
                objectArray2[n5] = object2;
                this.accessEntry(n5);
                return object3;
            } while ((n5 = CompactHashMap.getNext(l)) != -1);
            lArray[n] = CompactHashMap.swapNext(l, n4);
        }
        if (n4 == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        n = n4 + 1;
        this.resizeMeMaybe(n);
        this.insertEntry(n4, object, object2, n2);
        this.size = n;
        if (n4 >= this.threshold) {
            this.resizeTable(2 * this.table.length);
        }
        ++this.modCount;
        return null;
    }

    void insertEntry(int n, @Nullable Object object, @Nullable Object object2, int n2) {
        this.entries[n] = (long)n2 << 32 | 0xFFFFFFFFL;
        this.keys[n] = object;
        this.values[n] = object2;
    }

    private void resizeMeMaybe(int n) {
        int n2 = this.entries.length;
        if (n > n2) {
            int n3 = n2 + Math.max(1, n2 >>> 1);
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            if (n3 != n2) {
                this.resizeEntries(n3);
            }
        }
    }

    void resizeEntries(int n) {
        this.keys = Arrays.copyOf(this.keys, n);
        this.values = Arrays.copyOf(this.values, n);
        long[] lArray = this.entries;
        int n2 = lArray.length;
        lArray = Arrays.copyOf(lArray, n);
        if (n > n2) {
            Arrays.fill(lArray, n2, n, -1L);
        }
        this.entries = lArray;
    }

    private void resizeTable(int n) {
        int[] nArray = this.table;
        int n2 = nArray.length;
        if (n2 >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n3 = 1 + (int)((float)n * this.loadFactor);
        int[] nArray2 = CompactHashMap.newTable(n);
        long[] lArray = this.entries;
        int n4 = nArray2.length - 1;
        for (int i = 0; i < this.size; ++i) {
            long l = lArray[i];
            int n5 = CompactHashMap.getHash(l);
            int n6 = n5 & n4;
            int n7 = nArray2[n6];
            nArray2[n6] = i;
            lArray[i] = (long)n5 << 32 | 0xFFFFFFFFL & (long)n7;
        }
        this.threshold = n3;
        this.table = nArray2;
    }

    private int indexOf(@Nullable Object object) {
        int n = Hashing.smearedHash(object);
        int n2 = this.table[n & this.hashTableMask()];
        while (n2 != -1) {
            long l = this.entries[n2];
            if (CompactHashMap.getHash(l) == n && Objects.equal(object, this.keys[n2])) {
                return n2;
            }
            n2 = CompactHashMap.getNext(l);
        }
        return -1;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Object get(@Nullable Object object) {
        int n = this.indexOf(object);
        this.accessEntry(n);
        return n == -1 ? null : this.values[n];
    }

    @Override
    @CanIgnoreReturnValue
    public @Nullable Object remove(@Nullable Object object) {
        return this.remove(object, Hashing.smearedHash(object));
    }

    private @Nullable Object remove(@Nullable Object object, int n) {
        int n2 = n & this.hashTableMask();
        int n3 = this.table[n2];
        if (n3 == -1) {
            return null;
        }
        int n4 = -1;
        do {
            if (CompactHashMap.getHash(this.entries[n3]) == n && Objects.equal(object, this.keys[n3])) {
                Object object2 = this.values[n3];
                if (n4 == -1) {
                    this.table[n2] = CompactHashMap.getNext(this.entries[n3]);
                } else {
                    this.entries[n4] = CompactHashMap.swapNext(this.entries[n4], CompactHashMap.getNext(this.entries[n3]));
                }
                this.moveLastEntry(n3);
                --this.size;
                ++this.modCount;
                return object2;
            }
            n4 = n3;
        } while ((n3 = CompactHashMap.getNext(this.entries[n3])) != -1);
        return null;
    }

    @CanIgnoreReturnValue
    private Object removeEntry(int n) {
        return this.remove(this.keys[n], CompactHashMap.getHash(this.entries[n]));
    }

    void moveLastEntry(int n) {
        int n2 = this.size() - 1;
        if (n < n2) {
            long l;
            this.keys[n] = this.keys[n2];
            this.values[n] = this.values[n2];
            this.keys[n2] = null;
            this.values[n2] = null;
            this.entries[n] = l = this.entries[n2];
            this.entries[n2] = -1L;
            int n3 = CompactHashMap.getHash(l) & this.hashTableMask();
            int n4 = this.table[n3];
            if (n4 == n2) {
                this.table[n3] = n;
            } else {
                long l2;
                do {
                    int n5 = n4;
                } while ((n4 = CompactHashMap.getNext(l2 = this.entries[n4])) != n2);
                this.entries[n5] = CompactHashMap.swapNext(l2, n);
            }
        } else {
            this.keys[n] = null;
            this.values[n] = null;
            this.entries[n] = -1L;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int n) {
        return n + 1 < this.size ? n + 1 : -1;
    }

    int adjustAfterRemove(int n, int n2) {
        return n - 1;
    }

    @Override
    public void replaceAll(BiFunction biFunction) {
        Preconditions.checkNotNull(biFunction);
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = biFunction.apply(this.keys[i], this.values[i]);
        }
    }

    @Override
    public Set keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    Set createKeySet() {
        return new CompactHashMap$KeySetView(this);
    }

    Iterator keySetIterator() {
        return new CompactHashMap$1(this);
    }

    @Override
    public void forEach(BiConsumer biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (int i = 0; i < this.size; ++i) {
            biConsumer.accept(this.keys[i], this.values[i]);
        }
    }

    @Override
    public Set entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    Set createEntrySet() {
        return new CompactHashMap$EntrySetView(this);
    }

    Iterator entrySetIterator() {
        return new CompactHashMap$2(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equal(object, this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection values() {
        return this.valuesView == null ? (this.valuesView = this.createValues()) : this.valuesView;
    }

    Collection createValues() {
        return new CompactHashMap$ValuesView(this);
    }

    Iterator valuesIterator() {
        return new CompactHashMap$3(this);
    }

    @Override
    public void clear() {
        ++this.modCount;
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, -1L);
        this.size = 0;
    }

    static /* synthetic */ Object access$000(CompactHashMap compactHashMap, int n) {
        return compactHashMap.removeEntry(n);
    }

    static /* synthetic */ int access$100(CompactHashMap compactHashMap) {
        return compactHashMap.size;
    }

    static /* synthetic */ int access$200(CompactHashMap compactHashMap, Object object) {
        return compactHashMap.indexOf(object);
    }
}

