/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.AbstractCache$StatsCounter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader$InvalidCacheLoadException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$AccessQueue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$LoadingValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$Segment$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$WriteQueue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalCause;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalNotification;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ExecutionError;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Futures;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.MoreExecutors;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.j2objc.annotations.Weak;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class LocalCache$Segment
extends ReentrantLock {
    @Weak
    final LocalCache map;
    volatile int count;
    @GuardedBy(value="this")
    long totalWeight;
    int modCount;
    int threshold;
    volatile @MonotonicNonNull AtomicReferenceArray table;
    final long maxSegmentWeight;
    final @Nullable ReferenceQueue keyReferenceQueue;
    final @Nullable ReferenceQueue valueReferenceQueue;
    final Queue recencyQueue;
    final AtomicInteger readCount = new AtomicInteger();
    @GuardedBy(value="this")
    final Queue writeQueue;
    @GuardedBy(value="this")
    final Queue accessQueue;
    final AbstractCache$StatsCounter statsCounter;

    LocalCache$Segment(LocalCache localCache, int n, long l, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        this.map = localCache;
        this.maxSegmentWeight = l;
        this.statsCounter = (AbstractCache$StatsCounter)Preconditions.checkNotNull(abstractCache$StatsCounter);
        this.initTable(this.newEntryArray(n));
        this.keyReferenceQueue = localCache.usesKeyReferences() ? new ReferenceQueue() : null;
        this.valueReferenceQueue = localCache.usesValueReferences() ? new ReferenceQueue() : null;
        this.recencyQueue = localCache.usesAccessQueue() ? new ConcurrentLinkedQueue() : LocalCache.discardingQueue();
        this.writeQueue = localCache.usesWriteQueue() ? new LocalCache$WriteQueue() : LocalCache.discardingQueue();
        this.accessQueue = localCache.usesAccessQueue() ? new LocalCache$AccessQueue() : LocalCache.discardingQueue();
    }

    AtomicReferenceArray newEntryArray(int n) {
        return new AtomicReferenceArray(n);
    }

    void initTable(AtomicReferenceArray atomicReferenceArray) {
        this.threshold = atomicReferenceArray.length() * 3 / 4;
        if (!this.map.customWeigher() && (long)this.threshold == this.maxSegmentWeight) {
            ++this.threshold;
        }
        this.table = atomicReferenceArray;
    }

    @GuardedBy(value="this")
    ReferenceEntry newEntry(Object object, int n, @Nullable ReferenceEntry referenceEntry) {
        return this.map.entryFactory.newEntry(this, Preconditions.checkNotNull(object), n, referenceEntry);
    }

    @GuardedBy(value="this")
    ReferenceEntry copyEntry(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
        if (referenceEntry.getKey() == null) {
            return null;
        }
        LocalCache$ValueReference localCache$ValueReference = referenceEntry.getValueReference();
        Object object = localCache$ValueReference.get();
        if (object == null && localCache$ValueReference.isActive()) {
            return null;
        }
        ReferenceEntry referenceEntry3 = this.map.entryFactory.copyEntry(this, referenceEntry, referenceEntry2);
        referenceEntry3.setValueReference(localCache$ValueReference.copyFor(this.valueReferenceQueue, object, referenceEntry3));
        return referenceEntry3;
    }

    @GuardedBy(value="this")
    void setValue(ReferenceEntry referenceEntry, Object object, Object object2, long l) {
        LocalCache$ValueReference localCache$ValueReference = referenceEntry.getValueReference();
        int n = this.map.weigher.weigh(object, object2);
        Preconditions.checkState(n >= 0, "Weights must be non-negative");
        LocalCache$ValueReference localCache$ValueReference2 = this.map.valueStrength.referenceValue(this, referenceEntry, object2, n);
        referenceEntry.setValueReference(localCache$ValueReference2);
        this.recordWrite(referenceEntry, n, l);
        localCache$ValueReference.notifyNewValue(object2);
    }

    Object get(Object object, int n, CacheLoader cacheLoader) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(cacheLoader);
        try {
            Object object2;
            if (this.count != 0 && (object2 = this.getEntry(object, n)) != null) {
                long l = this.map.ticker.read();
                Object object3 = this.getLiveValue((ReferenceEntry)object2, l);
                if (object3 != null) {
                    this.recordRead((ReferenceEntry)object2, l);
                    this.statsCounter.recordHits(1);
                    Object object4 = this.scheduleRefresh((ReferenceEntry)object2, object, n, object3, l, cacheLoader);
                    return object4;
                }
                LocalCache$ValueReference localCache$ValueReference = object2.getValueReference();
                if (localCache$ValueReference.isLoading()) {
                    Object object5 = this.waitForLoadingValue((ReferenceEntry)object2, object, localCache$ValueReference);
                    return object5;
                }
            }
            object2 = this.lockedGetOrLoad(object, n, cacheLoader);
            return object2;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Error) {
                throw new ExecutionError((Error)throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw new UncheckedExecutionException(throwable);
            }
            throw executionException;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Object get(Object object, int n) {
        try {
            if (this.count != 0) {
                long l = this.map.ticker.read();
                ReferenceEntry referenceEntry = this.getLiveEntry(object, n, l);
                if (referenceEntry == null) {
                    Object var6_6 = null;
                    return var6_6;
                }
                Object object2 = referenceEntry.getValueReference().get();
                if (object2 != null) {
                    this.recordRead(referenceEntry, l);
                    Object object3 = this.scheduleRefresh(referenceEntry, referenceEntry.getKey(), n, object2, l, this.map.defaultLoader);
                    return object3;
                }
                this.tryDrainReferenceQueues();
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lockedGetOrLoad(Object object, int n, CacheLoader cacheLoader) {
        ReferenceEntry referenceEntry;
        LocalCache$ValueReference localCache$ValueReference = null;
        LocalCache$LoadingValueReference localCache$LoadingValueReference = null;
        boolean bl = true;
        this.lock();
        try {
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry = referenceEntry2 = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                Object object2 = referenceEntry.getKey();
                if (referenceEntry.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                localCache$ValueReference = referenceEntry.getValueReference();
                if (localCache$ValueReference.isLoading()) {
                    bl = false;
                    break;
                }
                Object object3 = localCache$ValueReference.get();
                if (object3 == null) {
                    this.enqueueNotification(object2, n, object3, localCache$ValueReference.getWeight(), RemovalCause.COLLECTED);
                } else if (this.map.isExpired(referenceEntry, l)) {
                    this.enqueueNotification(object2, n, object3, localCache$ValueReference.getWeight(), RemovalCause.EXPIRED);
                } else {
                    this.recordLockedRead(referenceEntry, l);
                    this.statsCounter.recordHits(1);
                    Object object4 = object3;
                    return object4;
                }
                this.writeQueue.remove(referenceEntry);
                this.accessQueue.remove(referenceEntry);
                this.count = n2;
                break;
            }
            if (bl) {
                localCache$LoadingValueReference = new LocalCache$LoadingValueReference();
                if (referenceEntry == null) {
                    referenceEntry = this.newEntry(object, n, referenceEntry2);
                    referenceEntry.setValueReference(localCache$LoadingValueReference);
                    atomicReferenceArray.set(n3, referenceEntry);
                } else {
                    referenceEntry.setValueReference(localCache$LoadingValueReference);
                }
            }
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
        if (bl) {
            try {
                ReferenceEntry referenceEntry3 = referenceEntry;
                synchronized (referenceEntry3) {
                    Object object5 = this.loadSync(object, n, localCache$LoadingValueReference, cacheLoader);
                    return object5;
                }
            }
            finally {
                this.statsCounter.recordMisses(1);
            }
        }
        return this.waitForLoadingValue(referenceEntry, object, localCache$ValueReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object waitForLoadingValue(ReferenceEntry referenceEntry, Object object, LocalCache$ValueReference localCache$ValueReference) {
        if (!localCache$ValueReference.isLoading()) {
            throw new AssertionError();
        }
        Preconditions.checkState(!Thread.holdsLock(referenceEntry), "Recursive load of: %s", object);
        try {
            Object object2 = localCache$ValueReference.waitForValue();
            if (object2 == null) {
                throw new CacheLoader$InvalidCacheLoadException("CacheLoader returned null for key " + object + ".");
            }
            long l = this.map.ticker.read();
            this.recordRead(referenceEntry, l);
            Object object3 = object2;
            return object3;
        }
        finally {
            this.statsCounter.recordMisses(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object compute(Object object, int n, BiFunction biFunction) {
        LocalCache$ValueReference localCache$ValueReference = null;
        LocalCache$LoadingValueReference localCache$LoadingValueReference = null;
        boolean bl = true;
        this.lock();
        try {
            Object object2;
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                object2 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                localCache$ValueReference = referenceEntry2.getValueReference();
                if (this.map.isExpired(referenceEntry2, l)) {
                    this.enqueueNotification(object2, n, localCache$ValueReference.get(), localCache$ValueReference.getWeight(), RemovalCause.EXPIRED);
                }
                this.writeQueue.remove(referenceEntry2);
                this.accessQueue.remove(referenceEntry2);
                bl = false;
                break;
            }
            localCache$LoadingValueReference = new LocalCache$LoadingValueReference(localCache$ValueReference);
            if (referenceEntry2 == null) {
                bl = true;
                referenceEntry2 = this.newEntry(object, n, referenceEntry);
                referenceEntry2.setValueReference(localCache$LoadingValueReference);
                atomicReferenceArray.set(n2, referenceEntry2);
            } else {
                referenceEntry2.setValueReference(localCache$LoadingValueReference);
            }
            Object object3 = localCache$LoadingValueReference.compute(object, biFunction);
            if (object3 != null) {
                if (localCache$ValueReference != null && object3 == localCache$ValueReference.get()) {
                    localCache$LoadingValueReference.set(object3);
                    this.setValue(referenceEntry2, object, object3, l);
                    object2 = object3;
                    return object2;
                }
                object2 = this.getAndRecordStats(object, n, localCache$LoadingValueReference, Futures.immediateFuture(object3));
                return object2;
            }
            if (bl) {
                this.removeLoadingValue(object, n, localCache$LoadingValueReference);
                object2 = null;
                return object2;
            }
            this.removeEntry(referenceEntry2, n, RemovalCause.EXPLICIT);
            object2 = null;
            return object2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    Object loadSync(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, CacheLoader cacheLoader) {
        ListenableFuture listenableFuture = localCache$LoadingValueReference.loadFuture(object, cacheLoader);
        return this.getAndRecordStats(object, n, localCache$LoadingValueReference, listenableFuture);
    }

    ListenableFuture loadAsync(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, CacheLoader cacheLoader) {
        ListenableFuture listenableFuture = localCache$LoadingValueReference.loadFuture(object, cacheLoader);
        listenableFuture.addListener(new LocalCache$Segment$1(this, object, n, localCache$LoadingValueReference, listenableFuture), MoreExecutors.directExecutor());
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAndRecordStats(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, ListenableFuture listenableFuture) {
        Object object2 = null;
        try {
            object2 = Uninterruptibles.getUninterruptibly(listenableFuture);
            if (object2 == null) {
                throw new CacheLoader$InvalidCacheLoadException("CacheLoader returned null for key " + object + ".");
            }
            this.statsCounter.recordLoadSuccess(localCache$LoadingValueReference.elapsedNanos());
            this.storeLoadedValue(object, n, localCache$LoadingValueReference, object2);
            Object object3 = object2;
            return object3;
        }
        finally {
            if (object2 == null) {
                this.statsCounter.recordLoadException(localCache$LoadingValueReference.elapsedNanos());
                this.removeLoadingValue(object, n, localCache$LoadingValueReference);
            }
        }
    }

    Object scheduleRefresh(ReferenceEntry referenceEntry, Object object, int n, Object object2, long l, CacheLoader cacheLoader) {
        Object object3;
        if (this.map.refreshes() && l - referenceEntry.getWriteTime() > this.map.refreshNanos && !referenceEntry.getValueReference().isLoading() && (object3 = this.refresh(object, n, cacheLoader, true)) != null) {
            return object3;
        }
        return object2;
    }

    @Nullable Object refresh(Object object, int n, CacheLoader cacheLoader, boolean bl) {
        LocalCache$LoadingValueReference localCache$LoadingValueReference = this.insertLoadingValueReference(object, n, bl);
        if (localCache$LoadingValueReference == null) {
            return null;
        }
        ListenableFuture listenableFuture = this.loadAsync(object, n, localCache$LoadingValueReference, cacheLoader);
        if (listenableFuture.isDone()) {
            try {
                return Uninterruptibles.getUninterruptibly(listenableFuture);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable LocalCache$LoadingValueReference insertLoadingValueReference(Object object, int n, boolean bl) {
        ReferenceEntry referenceEntry = null;
        this.lock();
        try {
            Object object2;
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry = referenceEntry2 = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                object2 = referenceEntry.getKey();
                if (referenceEntry.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry.getValueReference();
                if (localCache$ValueReference.isLoading() || bl && l - referenceEntry.getWriteTime() < this.map.refreshNanos) {
                    LocalCache$LoadingValueReference localCache$LoadingValueReference = null;
                    return localCache$LoadingValueReference;
                }
                ++this.modCount;
                LocalCache$LoadingValueReference localCache$LoadingValueReference = new LocalCache$LoadingValueReference(localCache$ValueReference);
                referenceEntry.setValueReference(localCache$LoadingValueReference);
                LocalCache$LoadingValueReference localCache$LoadingValueReference2 = localCache$LoadingValueReference;
                return localCache$LoadingValueReference2;
            }
            ++this.modCount;
            object2 = new LocalCache$LoadingValueReference();
            referenceEntry = this.newEntry(object, n, referenceEntry2);
            referenceEntry.setValueReference((LocalCache$ValueReference)object2);
            atomicReferenceArray.set(n2, referenceEntry);
            Object object3 = object2;
            return object3;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    void tryDrainReferenceQueues() {
        if (this.tryLock()) {
            try {
                this.drainReferenceQueues();
            }
            finally {
                this.unlock();
            }
        }
    }

    @GuardedBy(value="this")
    void drainReferenceQueues() {
        if (this.map.usesKeyReferences()) {
            this.drainKeyReferenceQueue();
        }
        if (this.map.usesValueReferences()) {
            this.drainValueReferenceQueue();
        }
    }

    @GuardedBy(value="this")
    void drainKeyReferenceQueue() {
        Reference reference;
        int n = 0;
        while ((reference = this.keyReferenceQueue.poll()) != null) {
            ReferenceEntry referenceEntry = (ReferenceEntry)((Object)reference);
            this.map.reclaimKey(referenceEntry);
            if (++n != 16) continue;
            break;
        }
    }

    @GuardedBy(value="this")
    void drainValueReferenceQueue() {
        Reference reference;
        int n = 0;
        while ((reference = this.valueReferenceQueue.poll()) != null) {
            LocalCache$ValueReference localCache$ValueReference = (LocalCache$ValueReference)((Object)reference);
            this.map.reclaimValue(localCache$ValueReference);
            if (++n != 16) continue;
            break;
        }
    }

    void clearReferenceQueues() {
        if (this.map.usesKeyReferences()) {
            this.clearKeyReferenceQueue();
        }
        if (this.map.usesValueReferences()) {
            this.clearValueReferenceQueue();
        }
    }

    void clearKeyReferenceQueue() {
        while (this.keyReferenceQueue.poll() != null) {
        }
    }

    void clearValueReferenceQueue() {
        while (this.valueReferenceQueue.poll() != null) {
        }
    }

    void recordRead(ReferenceEntry referenceEntry, long l) {
        if (this.map.recordsAccess()) {
            referenceEntry.setAccessTime(l);
        }
        this.recencyQueue.add(referenceEntry);
    }

    @GuardedBy(value="this")
    void recordLockedRead(ReferenceEntry referenceEntry, long l) {
        if (this.map.recordsAccess()) {
            referenceEntry.setAccessTime(l);
        }
        this.accessQueue.add(referenceEntry);
    }

    @GuardedBy(value="this")
    void recordWrite(ReferenceEntry referenceEntry, int n, long l) {
        this.drainRecencyQueue();
        this.totalWeight += (long)n;
        if (this.map.recordsAccess()) {
            referenceEntry.setAccessTime(l);
        }
        if (this.map.recordsWrite()) {
            referenceEntry.setWriteTime(l);
        }
        this.accessQueue.add(referenceEntry);
        this.writeQueue.add(referenceEntry);
    }

    @GuardedBy(value="this")
    void drainRecencyQueue() {
        ReferenceEntry referenceEntry;
        while ((referenceEntry = (ReferenceEntry)this.recencyQueue.poll()) != null) {
            if (!this.accessQueue.contains(referenceEntry)) continue;
            this.accessQueue.add(referenceEntry);
        }
    }

    void tryExpireEntries(long l) {
        if (this.tryLock()) {
            try {
                this.expireEntries(l);
            }
            finally {
                this.unlock();
            }
        }
    }

    @GuardedBy(value="this")
    void expireEntries(long l) {
        ReferenceEntry referenceEntry;
        this.drainRecencyQueue();
        while ((referenceEntry = (ReferenceEntry)this.writeQueue.peek()) != null && this.map.isExpired(referenceEntry, l)) {
            if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) {
                throw new AssertionError();
            }
        }
        while ((referenceEntry = (ReferenceEntry)this.accessQueue.peek()) != null && this.map.isExpired(referenceEntry, l)) {
            if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) {
                throw new AssertionError();
            }
        }
    }

    @GuardedBy(value="this")
    void enqueueNotification(@Nullable Object object, int n, @Nullable Object object2, int n2, RemovalCause removalCause) {
        this.totalWeight -= (long)n2;
        if (removalCause.wasEvicted()) {
            this.statsCounter.recordEviction();
        }
        if (this.map.removalNotificationQueue != LocalCache.DISCARDING_QUEUE) {
            RemovalNotification removalNotification = RemovalNotification.create(object, object2, removalCause);
            this.map.removalNotificationQueue.offer(removalNotification);
        }
    }

    @GuardedBy(value="this")
    void evictEntries(ReferenceEntry referenceEntry) {
        if (!this.map.evictsBySize()) {
            return;
        }
        this.drainRecencyQueue();
        if ((long)referenceEntry.getValueReference().getWeight() > this.maxSegmentWeight && !this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
            throw new AssertionError();
        }
        while (this.totalWeight > this.maxSegmentWeight) {
            ReferenceEntry referenceEntry2 = this.getNextEvictable();
            if (!this.removeEntry(referenceEntry2, referenceEntry2.getHash(), RemovalCause.SIZE)) {
                throw new AssertionError();
            }
        }
    }

    @GuardedBy(value="this")
    ReferenceEntry getNextEvictable() {
        for (ReferenceEntry referenceEntry : this.accessQueue) {
            int n = referenceEntry.getValueReference().getWeight();
            if (n <= 0) continue;
            return referenceEntry;
        }
        throw new AssertionError();
    }

    ReferenceEntry getFirst(int n) {
        AtomicReferenceArray atomicReferenceArray = this.table;
        return (ReferenceEntry)atomicReferenceArray.get(n & atomicReferenceArray.length() - 1);
    }

    @Nullable ReferenceEntry getEntry(Object object, int n) {
        for (ReferenceEntry referenceEntry = this.getFirst(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
            if (referenceEntry.getHash() != n) continue;
            Object object2 = referenceEntry.getKey();
            if (object2 == null) {
                this.tryDrainReferenceQueues();
                continue;
            }
            if (!this.map.keyEquivalence.equivalent(object, object2)) continue;
            return referenceEntry;
        }
        return null;
    }

    @Nullable ReferenceEntry getLiveEntry(Object object, int n, long l) {
        ReferenceEntry referenceEntry = this.getEntry(object, n);
        if (referenceEntry == null) {
            return null;
        }
        if (this.map.isExpired(referenceEntry, l)) {
            this.tryExpireEntries(l);
            return null;
        }
        return referenceEntry;
    }

    Object getLiveValue(ReferenceEntry referenceEntry, long l) {
        if (referenceEntry.getKey() == null) {
            this.tryDrainReferenceQueues();
            return null;
        }
        Object object = referenceEntry.getValueReference().get();
        if (object == null) {
            this.tryDrainReferenceQueues();
            return null;
        }
        if (this.map.isExpired(referenceEntry, l)) {
            this.tryExpireEntries(l);
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsKey(Object object, int n) {
        try {
            if (this.count != 0) {
                long l = this.map.ticker.read();
                ReferenceEntry referenceEntry = this.getLiveEntry(object, n, l);
                if (referenceEntry == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = referenceEntry.getValueReference().get() != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Object put(Object object, int n, Object object2, boolean bl) {
        this.lock();
        try {
            Object object3;
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count + 1;
            if (n2 > this.threshold) {
                this.expand();
                n2 = this.count + 1;
            }
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                object3 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (object4 == null) {
                    ++this.modCount;
                    if (localCache$ValueReference.isActive()) {
                        this.enqueueNotification(object, n, object4, localCache$ValueReference.getWeight(), RemovalCause.COLLECTED);
                        this.setValue(referenceEntry2, object, object2, l);
                        n2 = this.count;
                    } else {
                        this.setValue(referenceEntry2, object, object2, l);
                        n2 = this.count + 1;
                    }
                    this.count = n2;
                    this.evictEntries(referenceEntry2);
                    Object var15_14 = null;
                    return var15_14;
                }
                if (bl) {
                    this.recordLockedRead(referenceEntry2, l);
                    Object object5 = object4;
                    return object5;
                }
                ++this.modCount;
                this.enqueueNotification(object, n, object4, localCache$ValueReference.getWeight(), RemovalCause.REPLACED);
                this.setValue(referenceEntry2, object, object2, l);
                this.evictEntries(referenceEntry2);
                Object object6 = object4;
                return object6;
            }
            ++this.modCount;
            referenceEntry2 = this.newEntry(object, n, referenceEntry);
            this.setValue(referenceEntry2, object, object2, l);
            atomicReferenceArray.set(n3, referenceEntry2);
            this.count = n2 = this.count + 1;
            this.evictEntries(referenceEntry2);
            object3 = null;
            return object3;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    @GuardedBy(value="this")
    void expand() {
        AtomicReferenceArray atomicReferenceArray = this.table;
        int n = atomicReferenceArray.length();
        if (n >= 0x40000000) {
            return;
        }
        int n2 = this.count;
        AtomicReferenceArray atomicReferenceArray2 = this.newEntryArray(n << 1);
        this.threshold = atomicReferenceArray2.length() * 3 / 4;
        int n3 = atomicReferenceArray2.length() - 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2 = (ReferenceEntry)atomicReferenceArray.get(i);
            if (referenceEntry2 == null) continue;
            ReferenceEntry referenceEntry3 = referenceEntry2.getNext();
            int n5 = referenceEntry2.getHash() & n3;
            if (referenceEntry3 == null) {
                atomicReferenceArray2.set(n5, referenceEntry2);
                continue;
            }
            ReferenceEntry referenceEntry4 = referenceEntry2;
            int n6 = n5;
            for (referenceEntry = referenceEntry3; referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                n4 = referenceEntry.getHash() & n3;
                if (n4 == n6) continue;
                n6 = n4;
                referenceEntry4 = referenceEntry;
            }
            atomicReferenceArray2.set(n6, referenceEntry4);
            for (referenceEntry = referenceEntry2; referenceEntry != referenceEntry4; referenceEntry = referenceEntry.getNext()) {
                n4 = referenceEntry.getHash() & n3;
                ReferenceEntry referenceEntry5 = (ReferenceEntry)atomicReferenceArray2.get(n4);
                ReferenceEntry referenceEntry6 = this.copyEntry(referenceEntry, referenceEntry5);
                if (referenceEntry6 != null) {
                    atomicReferenceArray2.set(n4, referenceEntry6);
                    continue;
                }
                this.removeCollectedEntry(referenceEntry);
                --n2;
            }
        }
        this.table = atomicReferenceArray2;
        this.count = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replace(Object object, int n, Object object2, Object object3) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                Object object4 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object4 == null || !this.map.keyEquivalence.equivalent(object, object4)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                Object object5 = localCache$ValueReference.get();
                if (object5 == null) {
                    int n3;
                    if (localCache$ValueReference.isActive()) {
                        n3 = this.count - 1;
                        ++this.modCount;
                        ReferenceEntry referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, object4, n, object5, localCache$ValueReference, RemovalCause.COLLECTED);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n2, referenceEntry3);
                        this.count = n3;
                    }
                    n3 = 0;
                    return n3 != 0;
                }
                if (this.map.valueEquivalence.equivalent(object2, object5)) {
                    ++this.modCount;
                    this.enqueueNotification(object, n, object5, localCache$ValueReference.getWeight(), RemovalCause.REPLACED);
                    this.setValue(referenceEntry2, object, object3, l);
                    this.evictEntries(referenceEntry2);
                    boolean bl = true;
                    return bl;
                }
                this.recordLockedRead(referenceEntry2, l);
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Object replace(Object object, int n, Object object2) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                Object object3 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (object4 == null) {
                    if (localCache$ValueReference.isActive()) {
                        int n3 = this.count - 1;
                        ++this.modCount;
                        ReferenceEntry referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, object3, n, object4, localCache$ValueReference, RemovalCause.COLLECTED);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n2, referenceEntry3);
                        this.count = n3;
                    }
                    Object var13_13 = null;
                    return var13_13;
                }
                ++this.modCount;
                this.enqueueNotification(object, n, object4, localCache$ValueReference.getWeight(), RemovalCause.REPLACED);
                this.setValue(referenceEntry2, object, object2, l);
                this.evictEntries(referenceEntry2);
                Object object5 = object4;
                return object5;
            }
            referenceEntry2 = null;
            return referenceEntry2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable Object remove(Object object, int n) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                RemovalCause removalCause;
                Object object2 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                Object object3 = localCache$ValueReference.get();
                if (object3 != null) {
                    removalCause = RemovalCause.EXPLICIT;
                } else if (localCache$ValueReference.isActive()) {
                    removalCause = RemovalCause.COLLECTED;
                } else {
                    Object var14_13 = null;
                    return var14_13;
                }
                ++this.modCount;
                ReferenceEntry referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, object2, n, object3, localCache$ValueReference, removalCause);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, referenceEntry3);
                this.count = n2;
                Object object4 = object3;
                return object4;
            }
            referenceEntry2 = null;
            return referenceEntry2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Object object, int n, Object object2) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                RemovalCause removalCause;
                Object object3 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (this.map.valueEquivalence.equivalent(object2, object4)) {
                    removalCause = RemovalCause.EXPLICIT;
                } else if (object4 == null && localCache$ValueReference.isActive()) {
                    removalCause = RemovalCause.COLLECTED;
                } else {
                    boolean bl = false;
                    return bl;
                }
                ++this.modCount;
                ReferenceEntry referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, object3, n, object4, localCache$ValueReference, removalCause);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, referenceEntry3);
                this.count = n2;
                boolean bl = removalCause == RemovalCause.EXPLICIT;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean storeLoadedValue(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, Object object2) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count + 1;
            if (n2 > this.threshold) {
                this.expand();
                n2 = this.count + 1;
            }
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                Object object3 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (localCache$LoadingValueReference == localCache$ValueReference || object4 == null && localCache$ValueReference != LocalCache.UNSET) {
                    ++this.modCount;
                    if (localCache$LoadingValueReference.isActive()) {
                        RemovalCause removalCause = object4 == null ? RemovalCause.COLLECTED : RemovalCause.REPLACED;
                        this.enqueueNotification(object, n, object4, localCache$LoadingValueReference.getWeight(), removalCause);
                        --n2;
                    }
                    this.setValue(referenceEntry2, object, object2, l);
                    this.count = n2;
                    this.evictEntries(referenceEntry2);
                    boolean bl = true;
                    return bl;
                }
                this.enqueueNotification(object, n, object2, 0, RemovalCause.REPLACED);
                boolean bl = false;
                return bl;
            }
            ++this.modCount;
            referenceEntry2 = this.newEntry(object, n, referenceEntry);
            this.setValue(referenceEntry2, object, object2, l);
            atomicReferenceArray.set(n3, referenceEntry2);
            this.count = n2;
            this.evictEntries(referenceEntry2);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                int n;
                long l = this.map.ticker.read();
                this.preWriteCleanup(l);
                AtomicReferenceArray atomicReferenceArray = this.table;
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    for (ReferenceEntry referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        if (!referenceEntry.getValueReference().isActive()) continue;
                        Object object = referenceEntry.getKey();
                        Object object2 = referenceEntry.getValueReference().get();
                        RemovalCause removalCause = object == null || object2 == null ? RemovalCause.COLLECTED : RemovalCause.EXPLICIT;
                        this.enqueueNotification(object, referenceEntry.getHash(), object2, referenceEntry.getValueReference().getWeight(), removalCause);
                    }
                }
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    atomicReferenceArray.set(n, null);
                }
                this.clearReferenceQueues();
                this.writeQueue.clear();
                this.accessQueue.clear();
                this.readCount.set(0);
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }
    }

    @GuardedBy(value="this")
    @Nullable ReferenceEntry removeValueFromChain(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2, @Nullable Object object, int n, Object object2, LocalCache$ValueReference localCache$ValueReference, RemovalCause removalCause) {
        this.enqueueNotification(object, n, object2, localCache$ValueReference.getWeight(), removalCause);
        this.writeQueue.remove(referenceEntry2);
        this.accessQueue.remove(referenceEntry2);
        if (localCache$ValueReference.isLoading()) {
            localCache$ValueReference.notifyNewValue(null);
            return referenceEntry;
        }
        return this.removeEntryFromChain(referenceEntry, referenceEntry2);
    }

    @GuardedBy(value="this")
    @Nullable ReferenceEntry removeEntryFromChain(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
        int n = this.count;
        ReferenceEntry referenceEntry3 = referenceEntry2.getNext();
        for (ReferenceEntry referenceEntry4 = referenceEntry; referenceEntry4 != referenceEntry2; referenceEntry4 = referenceEntry4.getNext()) {
            ReferenceEntry referenceEntry5 = this.copyEntry(referenceEntry4, referenceEntry3);
            if (referenceEntry5 != null) {
                referenceEntry3 = referenceEntry5;
                continue;
            }
            this.removeCollectedEntry(referenceEntry4);
            --n;
        }
        this.count = n;
        return referenceEntry3;
    }

    @GuardedBy(value="this")
    void removeCollectedEntry(ReferenceEntry referenceEntry) {
        this.enqueueNotification(referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry.getValueReference().get(), referenceEntry.getValueReference().getWeight(), RemovalCause.COLLECTED);
        this.writeQueue.remove(referenceEntry);
        this.accessQueue.remove(referenceEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimKey(ReferenceEntry referenceEntry, int n) {
        this.lock();
        try {
            ReferenceEntry referenceEntry2;
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (ReferenceEntry referenceEntry3 = referenceEntry2 = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
                if (referenceEntry3 != referenceEntry) continue;
                ++this.modCount;
                ReferenceEntry referenceEntry4 = this.removeValueFromChain(referenceEntry2, referenceEntry3, referenceEntry3.getKey(), n, referenceEntry3.getValueReference().get(), referenceEntry3.getValueReference(), RemovalCause.COLLECTED);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, referenceEntry4);
                this.count = n2;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimValue(Object object, int n, LocalCache$ValueReference localCache$ValueReference) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                Object object2 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference2 = referenceEntry2.getValueReference();
                if (localCache$ValueReference2 == localCache$ValueReference) {
                    ++this.modCount;
                    ReferenceEntry referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, object2, n, localCache$ValueReference.get(), localCache$ValueReference, RemovalCause.COLLECTED);
                    n2 = this.count - 1;
                    atomicReferenceArray.set(n3, referenceEntry3);
                    this.count = n2;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            if (!this.isHeldByCurrentThread()) {
                this.postWriteCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeLoadingValue(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference) {
        this.lock();
        try {
            ReferenceEntry referenceEntry;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                Object object2 = referenceEntry2.getKey();
                if (referenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference = referenceEntry2.getValueReference();
                if (localCache$ValueReference == localCache$LoadingValueReference) {
                    if (localCache$LoadingValueReference.isActive()) {
                        referenceEntry2.setValueReference(localCache$LoadingValueReference.getOldValue());
                    } else {
                        ReferenceEntry referenceEntry3 = this.removeEntryFromChain(referenceEntry, referenceEntry2);
                        atomicReferenceArray.set(n2, referenceEntry3);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    @GuardedBy(value="this")
    boolean removeEntry(ReferenceEntry referenceEntry, int n, RemovalCause removalCause) {
        ReferenceEntry referenceEntry2;
        int n2 = this.count - 1;
        AtomicReferenceArray atomicReferenceArray = this.table;
        int n3 = n & atomicReferenceArray.length() - 1;
        for (ReferenceEntry referenceEntry3 = referenceEntry2 = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
            if (referenceEntry3 != referenceEntry) continue;
            ++this.modCount;
            ReferenceEntry referenceEntry4 = this.removeValueFromChain(referenceEntry2, referenceEntry3, referenceEntry3.getKey(), n, referenceEntry3.getValueReference().get(), referenceEntry3.getValueReference(), removalCause);
            n2 = this.count - 1;
            atomicReferenceArray.set(n3, referenceEntry4);
            this.count = n2;
            return true;
        }
        return false;
    }

    void postReadCleanup() {
        if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
            this.cleanUp();
        }
    }

    @GuardedBy(value="this")
    void preWriteCleanup(long l) {
        this.runLockedCleanup(l);
    }

    void postWriteCleanup() {
        this.runUnlockedCleanup();
    }

    void cleanUp() {
        long l = this.map.ticker.read();
        this.runLockedCleanup(l);
        this.runUnlockedCleanup();
    }

    void runLockedCleanup(long l) {
        if (this.tryLock()) {
            try {
                this.drainReferenceQueues();
                this.expireEntries(l);
                this.readCount.set(0);
            }
            finally {
                this.unlock();
            }
        }
    }

    void runUnlockedCleanup() {
        if (!this.isHeldByCurrentThread()) {
            this.map.processPendingNotifications();
        }
    }
}

