/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.runtime.Unit;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;

public class Puffin {
    private Puffin() {
    }

    public static <G, F> Builder<G, F> builder(Supplier<G> globalStateFactory, Function<G, F> fileStateFactory) {
        return new BuilderImpl(globalStateFactory, fileStateFactory, PairList.of(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    }

    public static Builder<Unit, Unit> builder() {
        return Puffin.builder(() -> Unit.INSTANCE, u -> u);
    }

    private static class BuilderImpl<G, F>
    implements Builder<G, F> {
        private final Supplier<G> globalStateFactory;
        private final Function<G, F> fileStateFactory;
        final PairList<Predicate<Line<G, F>>, Consumer<Line<G, F>>> onLineList;
        final List<Consumer<Context<G, F>>> beforeSourceList;
        final List<Consumer<Context<G, F>>> afterSourceList;
        final List<Consumer<Context<G, F>>> beforeList;
        final List<Consumer<Context<G, F>>> afterList;

        private BuilderImpl(Supplier<G> globalStateFactory, Function<G, F> fileStateFactory, PairList<Predicate<Line<G, F>>, Consumer<Line<G, F>>> onLineList, List<Consumer<Context<G, F>>> beforeSourceList, List<Consumer<Context<G, F>>> afterSourceList, List<Consumer<Context<G, F>>> beforeList, List<Consumer<Context<G, F>>> afterList) {
            this.globalStateFactory = globalStateFactory;
            this.fileStateFactory = fileStateFactory;
            this.onLineList = onLineList;
            this.beforeSourceList = beforeSourceList;
            this.afterSourceList = afterSourceList;
            this.beforeList = beforeList;
            this.afterList = afterList;
        }

        @Override
        public Builder<G, F> add(Predicate<Line<G, F>> linePredicate, Consumer<Line<G, F>> action) {
            this.onLineList.add(linePredicate, action);
            return this;
        }

        @Override
        public Builder<G, F> beforeSource(Consumer<Context<G, F>> action) {
            this.beforeSourceList.add(action);
            return this;
        }

        @Override
        public Builder<G, F> afterSource(Consumer<Context<G, F>> action) {
            this.afterSourceList.add(action);
            return this;
        }

        @Override
        public Builder<G, F> before(Consumer<Context<G, F>> action) {
            this.beforeList.add(action);
            return this;
        }

        @Override
        public Builder<G, F> after(Consumer<Context<G, F>> action) {
            this.afterList.add(action);
            return this;
        }

        @Override
        public Program<G> build() {
            return new ProgramImpl(this.globalStateFactory, this.fileStateFactory, this.onLineList.immutable(), ImmutableList.copyOf(this.beforeSourceList), ImmutableList.copyOf(this.afterSourceList), ImmutableList.copyOf(this.beforeList), ImmutableList.copyOf(this.afterList));
        }
    }

    private static class ProgramImpl<G, F>
    implements Program<G> {
        private final Supplier<G> globalStateFactory;
        private final Function<G, F> fileStateFactory;
        private final PairList<Predicate<Line<G, F>>, Consumer<Line<G, F>>> onLineList;
        private final ImmutableList<Consumer<Context<G, F>>> beforeSourceList;
        private final ImmutableList<Consumer<Context<G, F>>> afterSourceList;
        private final ImmutableList<Consumer<Context<G, F>>> beforeList;
        private final ImmutableList<Consumer<Context<G, F>>> afterList;
        private final LoadingCache<String, Pattern> patternCache0 = CacheBuilder.newBuilder().build(CacheLoader.from(regex -> Pattern.compile(regex)));
        private final Function<String, Pattern> patternCache = arg_0 -> this.patternCache0.getUnchecked(arg_0);

        private ProgramImpl(Supplier<G> globalStateFactory, Function<G, F> fileStateFactory, PairList<Predicate<Line<G, F>>, Consumer<Line<G, F>>> onLineList, ImmutableList<Consumer<Context<G, F>>> beforeSourceList, ImmutableList<Consumer<Context<G, F>>> afterSourceList, ImmutableList<Consumer<Context<G, F>>> beforeList, ImmutableList<Consumer<Context<G, F>>> afterList) {
            this.globalStateFactory = globalStateFactory;
            this.fileStateFactory = fileStateFactory;
            this.onLineList = onLineList;
            this.beforeSourceList = beforeSourceList;
            this.afterSourceList = afterSourceList;
            this.beforeList = beforeList;
            this.afterList = afterList;
        }

        @Override
        public G execute(Stream<? extends Source> sources, PrintWriter out) {
            G globalState = this.globalStateFactory.get();
            Source source0 = Sources.of("");
            F fileState0 = this.fileStateFactory.apply(globalState);
            ContextImpl x0 = new ContextImpl(out, source0, this.patternCache, globalState, fileState0);
            this.beforeList.forEach(action -> action.accept(x0));
            sources.forEach(source -> this.execute(globalState, (Source)source, out));
            this.afterList.forEach(action -> action.accept(x0));
            return globalState;
        }

        private void execute(G globalState, Source source, PrintWriter out) {
            try (Reader r = source.reader();
                 BufferedReader br = new BufferedReader(r);){
                String lineText;
                F fileState = this.fileStateFactory.apply(globalState);
                ContextImpl x = new ContextImpl(out, source, this.patternCache, globalState, fileState);
                this.beforeSourceList.forEach(action -> action.accept(x));
                while ((lineText = br.readLine()) != null) {
                    ++x.fnr;
                    x.line = lineText;
                    this.onLineList.forEach((predicate, action) -> {
                        if (predicate.test(x)) {
                            action.accept(x);
                        }
                    });
                }
                this.afterSourceList.forEach(action -> action.accept(x));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class ContextImpl<G, F>
    extends Context<G, F>
    implements Line<G, F> {
        ContextImpl(PrintWriter out, Source source, Function<String, Pattern> patternCache, G globalState, F state) {
            super(out, source, patternCache, globalState, state);
        }

        @Override
        public int fnr() {
            return this.fnr;
        }

        @Override
        public String filename() {
            return this.source().toString();
        }

        @Override
        public Source source() {
            return this.source;
        }

        @Override
        public boolean startsWith(String prefix) {
            return this.line.startsWith(prefix);
        }

        @Override
        public boolean contains(CharSequence s) {
            return this.line.contains(s);
        }

        @Override
        public boolean endsWith(String suffix) {
            return this.line.endsWith(suffix);
        }

        @Override
        public boolean matches(String regex) {
            return this.pattern(regex).matcher(this.line).matches();
        }

        @Override
        public String line() {
            return this.line;
        }
    }

    public static class Context<G, F> {
        final PrintWriter out;
        final Source source;
        final F fileState;
        final G globalState;
        private final Function<String, Pattern> patternCache;
        String line = "";
        int fnr = 0;

        Context(PrintWriter out, Source source, Function<String, Pattern> patternCache, G globalState, F fileState) {
            this.out = Objects.requireNonNull(out, "out");
            this.source = Objects.requireNonNull(source, "source");
            this.patternCache = Objects.requireNonNull(patternCache, "patternCache");
            this.globalState = Objects.requireNonNull(globalState, "globalState");
            this.fileState = Objects.requireNonNull(fileState, "fileState");
        }

        public F state() {
            return this.fileState;
        }

        public G globalState() {
            return this.globalState;
        }

        public void println(String s) {
            this.out.println(s);
        }

        Pattern pattern(String regex) {
            return this.patternCache.apply(regex);
        }
    }

    public static interface Line<G, F> {
        public G globalState();

        public F state();

        public int fnr();

        public String filename();

        public Source source();

        public boolean startsWith(String var1);

        public boolean contains(CharSequence var1);

        public boolean endsWith(String var1);

        public boolean matches(String var1);

        public String line();
    }

    public static interface Program<G> {
        public G execute(Stream<? extends Source> var1, PrintWriter var2);

        default public void execute(Stream<? extends Source> sources, OutputStream out) {
            try (PrintWriter w = Util.printWriter(out);){
                this.execute(sources, w);
            }
        }

        default public void execute(Source source, OutputStream out) {
            this.execute(Stream.of(source), out);
        }
    }

    public static interface Builder<G, F> {
        public Builder<G, F> add(Predicate<Line<G, F>> var1, Consumer<Line<G, F>> var2);

        public Builder<G, F> beforeSource(Consumer<Context<G, F>> var1);

        public Builder<G, F> afterSource(Consumer<Context<G, F>> var1);

        public Builder<G, F> before(Consumer<Context<G, F>> var1);

        public Builder<G, F> after(Consumer<Context<G, F>> var1);

        public Program<G> build();
    }
}

