/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import org.apache.knox.gateway.shell.table.KnoxShellTable;

public class KnoxShellTableAggregator {
    private KnoxShellTable tableToAggregate;
    private String[] cols;

    public KnoxShellTableAggregator(KnoxShellTable table) {
        this.tableToAggregate = table;
    }

    public KnoxShellTableAggregator columns(String cols) {
        this.cols = cols.split("\\s*,\\s*");
        return this;
    }

    public KnoxShellTable functions(String funcs) {
        String[] functions = funcs.split("\\s*,\\s*");
        KnoxShellTable table = new KnoxShellTable();
        table.header("");
        for (String col : this.cols) {
            table.header(col);
        }
        for (String func : functions) {
            table.row();
            table.value((Comparable<? extends Object>)((Object)func));
            for (String col : this.cols) {
                table.value(this.executeFunction(col, func));
            }
        }
        return table;
    }

    private Double executeFunction(String col, String func) {
        Double value = 0.0;
        if ("min".equalsIgnoreCase(func)) {
            value = this.tableToAggregate.min(col);
        } else if ("max".equalsIgnoreCase(func)) {
            value = this.tableToAggregate.max(col);
        } else if ("mean".equalsIgnoreCase(func)) {
            value = this.tableToAggregate.mean(col);
        } else if ("mode".equalsIgnoreCase(func)) {
            value = this.tableToAggregate.mode(col);
        } else if ("median".equalsIgnoreCase(func)) {
            value = this.tableToAggregate.median(col);
        } else if ("sum".equalsIgnoreCase(func)) {
            value = this.tableToAggregate.sum(col);
        }
        return value;
    }
}

