/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public enum CORSRequestType {
    ACTUAL,
    PREFLIGHT,
    OTHER;


    public static CORSRequestType detect(HttpServletRequest request) {
        block6: {
            if (request.getHeader("Origin") == null) {
                return OTHER;
            }
            if (request.getHeader("Host") != null) {
                String originAsString = request.getHeader("Origin");
                String hostAsString = request.getScheme() + "://" + request.getHeader("Host");
                try {
                    URL origin = new URL(originAsString);
                    URL host = new URL(hostAsString);
                    if (CORSRequestType.protocolMatches(origin, host) && CORSRequestType.hostMatches(origin, host) && CORSRequestType.portMatches(origin, host)) {
                        return OTHER;
                    }
                }
                catch (MalformedURLException e) {
                    if (!hostAsString.equals(originAsString)) break block6;
                    return OTHER;
                }
            }
        }
        if (request.getHeader("Access-Control-Request-Method") != null && request.getMethod() != null && request.getMethod().equalsIgnoreCase("OPTIONS")) {
            return PREFLIGHT;
        }
        return ACTUAL;
    }

    private static boolean hostMatches(URL origin, URL host) {
        return origin.getHost().equals(host.getHost());
    }

    private static boolean protocolMatches(URL origin, URL host) {
        return origin.getProtocol().equals(host.getProtocol());
    }

    private static boolean portMatches(URL origin, URL host) {
        int originPort = origin.getPort() == -1 ? origin.getDefaultPort() : origin.getPort();
        int hostPort = host.getPort() == -1 ? host.getDefaultPort() : host.getPort();
        return originPort == hostPort;
    }
}

