/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Arguments used for Rolling Restart commands.")
public class ApiRollingRestartArgs {
    @SerializedName(value="slaveBatchSize")
    private BigDecimal slaveBatchSize = null;
    @SerializedName(value="sleepSeconds")
    private BigDecimal sleepSeconds = null;
    @SerializedName(value="slaveFailCountThreshold")
    private BigDecimal slaveFailCountThreshold = null;
    @SerializedName(value="staleConfigsOnly")
    private Boolean staleConfigsOnly = null;
    @SerializedName(value="unUpgradedOnly")
    private Boolean unUpgradedOnly = null;
    @SerializedName(value="restartRoleTypes")
    private List<String> restartRoleTypes = null;
    @SerializedName(value="restartRoleNames")
    private List<String> restartRoleNames = null;

    public ApiRollingRestartArgs slaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
        return this;
    }

    @Schema(description="Number of slave roles to restart at a time. Must be greater than zero. Default is 1.  Please note that for HDFS, this number should be less than the replication factor (default 3) to ensure data availability during rolling restart.")
    public BigDecimal getSlaveBatchSize() {
        return this.slaveBatchSize;
    }

    public void setSlaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
    }

    public ApiRollingRestartArgs sleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
        return this;
    }

    @Schema(description="Number of seconds to sleep between restarts of slave role batches.  Must be greater than or equal to 0. Default is 0.")
    public BigDecimal getSleepSeconds() {
        return this.sleepSeconds;
    }

    public void setSleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public ApiRollingRestartArgs slaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
        return this;
    }

    @Schema(description="The threshold for number of slave batches that are allowed to fail to restart before the entire command is considered failed.  Must be greather than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>")
    public BigDecimal getSlaveFailCountThreshold() {
        return this.slaveFailCountThreshold;
    }

    public void setSlaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
    }

    public ApiRollingRestartArgs staleConfigsOnly(Boolean staleConfigsOnly) {
        this.staleConfigsOnly = staleConfigsOnly;
        return this;
    }

    @Schema(description="Restart roles with stale configs only.")
    public Boolean isStaleConfigsOnly() {
        return this.staleConfigsOnly;
    }

    public void setStaleConfigsOnly(Boolean staleConfigsOnly) {
        this.staleConfigsOnly = staleConfigsOnly;
    }

    public ApiRollingRestartArgs unUpgradedOnly(Boolean unUpgradedOnly) {
        this.unUpgradedOnly = unUpgradedOnly;
        return this;
    }

    @Schema(description="Restart roles that haven't been upgraded yet.")
    public Boolean isUnUpgradedOnly() {
        return this.unUpgradedOnly;
    }

    public void setUnUpgradedOnly(Boolean unUpgradedOnly) {
        this.unUpgradedOnly = unUpgradedOnly;
    }

    public ApiRollingRestartArgs restartRoleTypes(List<String> restartRoleTypes) {
        this.restartRoleTypes = restartRoleTypes;
        return this;
    }

    public ApiRollingRestartArgs addRestartRoleTypesItem(String restartRoleTypesItem) {
        if (this.restartRoleTypes == null) {
            this.restartRoleTypes = new ArrayList<String>();
        }
        this.restartRoleTypes.add(restartRoleTypesItem);
        return this;
    }

    @Schema(description="Role types to restart. If not specified, all startable roles are restarted.  Both role types and role names should not be specified.")
    public List<String> getRestartRoleTypes() {
        return this.restartRoleTypes;
    }

    public void setRestartRoleTypes(List<String> restartRoleTypes) {
        this.restartRoleTypes = restartRoleTypes;
    }

    public ApiRollingRestartArgs restartRoleNames(List<String> restartRoleNames) {
        this.restartRoleNames = restartRoleNames;
        return this;
    }

    public ApiRollingRestartArgs addRestartRoleNamesItem(String restartRoleNamesItem) {
        if (this.restartRoleNames == null) {
            this.restartRoleNames = new ArrayList<String>();
        }
        this.restartRoleNames.add(restartRoleNamesItem);
        return this;
    }

    @Schema(description="List of specific roles to restart. If none are specified, then all roles of specified role types are restarted.  Both role types and role names should not be specified.")
    public List<String> getRestartRoleNames() {
        return this.restartRoleNames;
    }

    public void setRestartRoleNames(List<String> restartRoleNames) {
        this.restartRoleNames = restartRoleNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRollingRestartArgs apiRollingRestartArgs = (ApiRollingRestartArgs)o;
        return Objects.equals(this.slaveBatchSize, apiRollingRestartArgs.slaveBatchSize) && Objects.equals(this.sleepSeconds, apiRollingRestartArgs.sleepSeconds) && Objects.equals(this.slaveFailCountThreshold, apiRollingRestartArgs.slaveFailCountThreshold) && Objects.equals(this.staleConfigsOnly, apiRollingRestartArgs.staleConfigsOnly) && Objects.equals(this.unUpgradedOnly, apiRollingRestartArgs.unUpgradedOnly) && Objects.equals(this.restartRoleTypes, apiRollingRestartArgs.restartRoleTypes) && Objects.equals(this.restartRoleNames, apiRollingRestartArgs.restartRoleNames);
    }

    public int hashCode() {
        return Objects.hash(this.slaveBatchSize, this.sleepSeconds, this.slaveFailCountThreshold, this.staleConfigsOnly, this.unUpgradedOnly, this.restartRoleTypes, this.restartRoleNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRollingRestartArgs {\n");
        sb.append("    slaveBatchSize: ").append(this.toIndentedString(this.slaveBatchSize)).append("\n");
        sb.append("    sleepSeconds: ").append(this.toIndentedString(this.sleepSeconds)).append("\n");
        sb.append("    slaveFailCountThreshold: ").append(this.toIndentedString(this.slaveFailCountThreshold)).append("\n");
        sb.append("    staleConfigsOnly: ").append(this.toIndentedString(this.staleConfigsOnly)).append("\n");
        sb.append("    unUpgradedOnly: ").append(this.toIndentedString(this.unUpgradedOnly)).append("\n");
        sb.append("    restartRoleTypes: ").append(this.toIndentedString(this.restartRoleTypes)).append("\n");
        sb.append("    restartRoleNames: ").append(this.toIndentedString(this.restartRoleNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

