/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterTemplateClusterSpec;
import com.cloudera.api.swagger.model.ApiClusterTemplateHostTemplate;
import com.cloudera.api.swagger.model.ApiClusterTemplateInstantiator;
import com.cloudera.api.swagger.model.ApiClusterTemplateService;
import com.cloudera.api.swagger.model.ApiEntityTag;
import com.cloudera.api.swagger.model.ApiProductVersion;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Details of cluster template")
public class ApiClusterTemplate {
    @SerializedName(value="cdhVersion")
    private String cdhVersion = null;
    @SerializedName(value="experienceVersion")
    private String experienceVersion = null;
    @SerializedName(value="dataServicesVersion")
    private String dataServicesVersion = null;
    @SerializedName(value="products")
    private List<ApiProductVersion> products = null;
    @SerializedName(value="services")
    private List<ApiClusterTemplateService> services = null;
    @SerializedName(value="hostTemplates")
    private List<ApiClusterTemplateHostTemplate> hostTemplates = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="cmVersion")
    private String cmVersion = null;
    @SerializedName(value="instantiator")
    private ApiClusterTemplateInstantiator instantiator = null;
    @SerializedName(value="repositories")
    private List<String> repositories = null;
    @SerializedName(value="clusterSpec")
    private ApiClusterTemplateClusterSpec clusterSpec = null;
    @SerializedName(value="tags")
    private List<ApiEntityTag> tags = null;

    public ApiClusterTemplate cdhVersion(String cdhVersion) {
        this.cdhVersion = cdhVersion;
        return this;
    }

    @Schema(description="CDH version")
    public String getCdhVersion() {
        return this.cdhVersion;
    }

    public void setCdhVersion(String cdhVersion) {
        this.cdhVersion = cdhVersion;
    }

    public ApiClusterTemplate experienceVersion(String experienceVersion) {
        this.experienceVersion = experienceVersion;
        return this;
    }

    @Schema(description="Deprecated. Use dataServicesVersion instead.")
    public String getExperienceVersion() {
        return this.experienceVersion;
    }

    public void setExperienceVersion(String experienceVersion) {
        this.experienceVersion = experienceVersion;
    }

    public ApiClusterTemplate dataServicesVersion(String dataServicesVersion) {
        this.dataServicesVersion = dataServicesVersion;
        return this;
    }

    @Schema(description="Data Services version")
    public String getDataServicesVersion() {
        return this.dataServicesVersion;
    }

    public void setDataServicesVersion(String dataServicesVersion) {
        this.dataServicesVersion = dataServicesVersion;
    }

    public ApiClusterTemplate products(List<ApiProductVersion> products) {
        this.products = products;
        return this;
    }

    public ApiClusterTemplate addProductsItem(ApiProductVersion productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<ApiProductVersion>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Schema(description="All the parcels that needs to be deployed and activated")
    public List<ApiProductVersion> getProducts() {
        return this.products;
    }

    public void setProducts(List<ApiProductVersion> products) {
        this.products = products;
    }

    public ApiClusterTemplate services(List<ApiClusterTemplateService> services) {
        this.services = services;
        return this;
    }

    public ApiClusterTemplate addServicesItem(ApiClusterTemplateService servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<ApiClusterTemplateService>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Schema(description="All the services that needs to be deployed")
    public List<ApiClusterTemplateService> getServices() {
        return this.services;
    }

    public void setServices(List<ApiClusterTemplateService> services) {
        this.services = services;
    }

    public ApiClusterTemplate hostTemplates(List<ApiClusterTemplateHostTemplate> hostTemplates) {
        this.hostTemplates = hostTemplates;
        return this;
    }

    public ApiClusterTemplate addHostTemplatesItem(ApiClusterTemplateHostTemplate hostTemplatesItem) {
        if (this.hostTemplates == null) {
            this.hostTemplates = new ArrayList<ApiClusterTemplateHostTemplate>();
        }
        this.hostTemplates.add(hostTemplatesItem);
        return this;
    }

    @Schema(description="All host templates")
    public List<ApiClusterTemplateHostTemplate> getHostTemplates() {
        return this.hostTemplates;
    }

    public void setHostTemplates(List<ApiClusterTemplateHostTemplate> hostTemplates) {
        this.hostTemplates = hostTemplates;
    }

    public ApiClusterTemplate displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Cluster display name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiClusterTemplate cmVersion(String cmVersion) {
        this.cmVersion = cmVersion;
        return this;
    }

    @Schema(description="CM version for which the template")
    public String getCmVersion() {
        return this.cmVersion;
    }

    public void setCmVersion(String cmVersion) {
        this.cmVersion = cmVersion;
    }

    public ApiClusterTemplate instantiator(ApiClusterTemplateInstantiator instantiator) {
        this.instantiator = instantiator;
        return this;
    }

    @Schema(description="")
    public ApiClusterTemplateInstantiator getInstantiator() {
        return this.instantiator;
    }

    public void setInstantiator(ApiClusterTemplateInstantiator instantiator) {
        this.instantiator = instantiator;
    }

    public ApiClusterTemplate repositories(List<String> repositories) {
        this.repositories = repositories;
        return this;
    }

    public ApiClusterTemplate addRepositoriesItem(String repositoriesItem) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.add(repositoriesItem);
        return this;
    }

    @Schema(description="List of all repositories registered with CM")
    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public ApiClusterTemplate clusterSpec(ApiClusterTemplateClusterSpec clusterSpec) {
        this.clusterSpec = clusterSpec;
        return this;
    }

    @Schema(description="")
    public ApiClusterTemplateClusterSpec getClusterSpec() {
        return this.clusterSpec;
    }

    public void setClusterSpec(ApiClusterTemplateClusterSpec clusterSpec) {
        this.clusterSpec = clusterSpec;
    }

    public ApiClusterTemplate tags(List<ApiEntityTag> tags) {
        this.tags = tags;
        return this;
    }

    public ApiClusterTemplate addTagsItem(ApiEntityTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ApiEntityTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Schema(description="Tags associated with the cluster")
    public List<ApiEntityTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ApiEntityTag> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterTemplate apiClusterTemplate = (ApiClusterTemplate)o;
        return Objects.equals(this.cdhVersion, apiClusterTemplate.cdhVersion) && Objects.equals(this.experienceVersion, apiClusterTemplate.experienceVersion) && Objects.equals(this.dataServicesVersion, apiClusterTemplate.dataServicesVersion) && Objects.equals(this.products, apiClusterTemplate.products) && Objects.equals(this.services, apiClusterTemplate.services) && Objects.equals(this.hostTemplates, apiClusterTemplate.hostTemplates) && Objects.equals(this.displayName, apiClusterTemplate.displayName) && Objects.equals(this.cmVersion, apiClusterTemplate.cmVersion) && Objects.equals(this.instantiator, apiClusterTemplate.instantiator) && Objects.equals(this.repositories, apiClusterTemplate.repositories) && Objects.equals(this.clusterSpec, apiClusterTemplate.clusterSpec) && Objects.equals(this.tags, apiClusterTemplate.tags);
    }

    public int hashCode() {
        return Objects.hash(this.cdhVersion, this.experienceVersion, this.dataServicesVersion, this.products, this.services, this.hostTemplates, this.displayName, this.cmVersion, this.instantiator, this.repositories, this.clusterSpec, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterTemplate {\n");
        sb.append("    cdhVersion: ").append(this.toIndentedString(this.cdhVersion)).append("\n");
        sb.append("    experienceVersion: ").append(this.toIndentedString(this.experienceVersion)).append("\n");
        sb.append("    dataServicesVersion: ").append(this.toIndentedString(this.dataServicesVersion)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    hostTemplates: ").append(this.toIndentedString(this.hostTemplates)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    cmVersion: ").append(this.toIndentedString(this.cmVersion)).append("\n");
        sb.append("    instantiator: ").append(this.toIndentedString(this.instantiator)).append("\n");
        sb.append("    repositories: ").append(this.toIndentedString(this.repositories)).append("\n");
        sb.append("    clusterSpec: ").append(this.toIndentedString(this.clusterSpec)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

