/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.http.AsyncHttpRDF;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.IteratorParsers;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.web.HttpSC;

public class QueryExecHTTP
implements QueryExec {
    public static final String QUERY_MIME_TYPE = "application/sparql-query;charset=utf-8";
    private final Query query;
    private final String queryString;
    private final String service;
    private final Context context;
    private Params params = null;
    private final QuerySendMode sendMode;
    private int urlLimit = HttpEnv.urlLimit;
    private List<String> defaultGraphURIs = new ArrayList<String>();
    private List<String> namedGraphURIs = new ArrayList<String>();
    private boolean closed = false;
    private long readTimeout = -1L;
    private TimeUnit readTimeoutUnit = TimeUnit.MILLISECONDS;
    private final String selectAcceptHeader;
    private final String askAcceptHeader;
    private final String graphAcceptHeader;
    private final String datasetAcceptHeader;
    @Deprecated(forRemoval=true)
    private String overrideAcceptHeader = null;
    private String httpResponseContentType = null;
    private HttpClient httpClient = HttpEnv.getDftHttpClient();
    private Map<String, String> httpHeaders;
    private volatile boolean isAborted = false;
    private final Object abortLock = new Object();
    private volatile CompletableFuture<HttpResponse<InputStream>> future = null;
    private InputStream retainedConnection = null;
    private volatile InputStream retainedConnectionView = null;
    private boolean cancelFutureOnAbort = true;

    public static QueryExecHTTPBuilder newBuilder() {
        return QueryExecHTTPBuilder.create();
    }

    public static QueryExecHTTPBuilder service(String serviceURL) {
        return (QueryExecHTTPBuilder)QueryExecHTTP.newBuilder().endpoint(serviceURL);
    }

    @Deprecated(forRemoval=true)
    public QueryExecHTTP(String serviceURL, Query query2, String queryString, int urlLimit, HttpClient httpClient, Map<String, String> httpHeaders, Params params, Context context2, List<String> defaultGraphURIs, List<String> namedGraphURIs, QuerySendMode sendMode, String overrideAcceptHeader, long timeout, TimeUnit timeoutUnit) {
        this(serviceURL, query2, queryString, urlLimit, httpClient, httpHeaders, params, context2, defaultGraphURIs, namedGraphURIs, sendMode, HttpLib.dft(overrideAcceptHeader, WebContent.defaultSparqlResultsHeader), HttpLib.dft(overrideAcceptHeader, WebContent.defaultSparqlAskHeader), HttpLib.dft(overrideAcceptHeader, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3"), HttpLib.dft(overrideAcceptHeader, "application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3"), timeout, timeoutUnit);
        this.overrideAcceptHeader = overrideAcceptHeader;
        if (httpHeaders.containsKey("Accept")) {
            if (this.overrideAcceptHeader != null) {
                String acceptHeader;
                this.overrideAcceptHeader = acceptHeader = httpHeaders.get("Accept");
            }
            this.httpHeaders.remove("Accept");
        }
    }

    protected QueryExecHTTP(String serviceURL, Query query2, String queryString, int urlLimit, HttpClient httpClient, Map<String, String> httpHeaders, Params params, Context context2, List<String> defaultGraphURIs, List<String> namedGraphURIs, QuerySendMode sendMode, String selectAcceptHeader, String askAcceptHeader, String graphAcceptHeader, String datasetAcceptHeader, long timeout, TimeUnit timeoutUnit) {
        this.context = context2 == null ? ARQ.getContext().copy() : context2.copy();
        this.service = serviceURL;
        this.query = query2;
        this.queryString = queryString;
        this.urlLimit = urlLimit;
        this.httpHeaders = httpHeaders;
        this.defaultGraphURIs = defaultGraphURIs;
        this.namedGraphURIs = namedGraphURIs;
        this.sendMode = Objects.requireNonNull(sendMode);
        this.selectAcceptHeader = selectAcceptHeader;
        this.askAcceptHeader = askAcceptHeader;
        this.graphAcceptHeader = graphAcceptHeader;
        this.datasetAcceptHeader = datasetAcceptHeader;
        this.httpHeaders = httpHeaders;
        this.params = params;
        this.readTimeout = timeout;
        this.readTimeoutUnit = timeoutUnit;
        this.httpClient = HttpLib.dft(httpClient, HttpEnv.getDftHttpClient());
    }

    public String getAcceptHeaderSelect() {
        return this.selectAcceptHeader;
    }

    public String getAcceptHeaderAsk() {
        return this.askAcceptHeader;
    }

    public String getAcceptHeaderDescribe() {
        return this.graphAcceptHeader;
    }

    public String getAcceptHeaderConstructGraph() {
        return this.graphAcceptHeader;
    }

    public String getAcceptHeaderConstructDataset() {
        return this.datasetAcceptHeader;
    }

    @Deprecated(forRemoval=true)
    public String getAppProvidedAcceptHeader() {
        return this.overrideAcceptHeader;
    }

    public String getHttpResponseContentType() {
        return this.httpResponseContentType;
    }

    @Override
    public RowSet select() {
        this.checkNotClosed();
        this.check(QueryType.SELECT);
        RowSet rs = this.execRowSet();
        return rs;
    }

    private RowSet execRowSet() {
        boolean unsupportedFormat;
        Lang lang;
        String actualContentType;
        HttpRequest request = this.effectiveHttpRequest(this.selectAcceptHeader);
        HttpResponse<InputStream> response = this.executeQuery(request);
        InputStream in = this.registerInputStream(response);
        this.httpResponseContentType = actualContentType = HttpLib.responseHeader(response, "Content-Type");
        if ((actualContentType = this.removeCharset(actualContentType)) == null || actualContentType.equals("")) {
            actualContentType = "application/sparql-results+xml";
        }
        boolean unknownLang = (lang = WebContent.contentTypeToLangResultSet(actualContentType)) == null;
        boolean bl = unsupportedFormat = !unknownLang && !ResultSetReaderRegistry.isRegistered(lang);
        if (unknownLang || unsupportedFormat) {
            String errorTerm = unknownLang ? "recognized" : "supported";
            String errorMsg = String.format("Endpoint returned Content-Type: %s which is not %s for SELECT queries", actualContentType, errorTerm);
            this.raiseException(errorMsg, request, response, in);
        }
        ResultSet result = ResultSetMgr.read(in, lang);
        return RowSet.adapt(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ask() {
        Lang lang;
        String actualContentType;
        this.checkNotClosed();
        this.check(QueryType.ASK);
        HttpRequest request = this.effectiveHttpRequest(this.askAcceptHeader);
        HttpResponse<InputStream> response = this.executeQuery(request);
        InputStream in = this.registerInputStream(response);
        this.httpResponseContentType = actualContentType = HttpLib.responseHeader(response, "Content-Type");
        actualContentType = this.removeCharset(actualContentType);
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = this.askAcceptHeader;
        }
        if ((lang = RDFLanguages.contentTypeToLang(actualContentType)) == null) {
            if (actualContentType.equals("application/xml")) {
                lang = ResultSetLang.RS_XML;
            } else if (actualContentType.equals("application/json")) {
                lang = ResultSetLang.RS_JSON;
            }
        }
        if (lang == null) {
            this.raiseException("Endpoint returned Content-Type: " + actualContentType + " which is not supported for ASK queries", request, response, in);
        }
        try {
            boolean result;
            boolean bl = result = ResultSetMgr.readBoolean(in, lang);
            return bl;
        }
        finally {
            HttpLib.finishInputStream(in);
        }
    }

    private String removeCharset(String contentType) {
        if (contentType == null) {
            return contentType;
        }
        int idx = contentType.indexOf(59);
        if (idx < 0) {
            return contentType;
        }
        return contentType.substring(0, idx);
    }

    @Override
    public Graph construct(Graph graph) {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT);
        return this.execGraph(graph, this.graphAcceptHeader);
    }

    @Override
    public Iterator<Triple> constructTriples() {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT);
        return this.execTriples(this.graphAcceptHeader);
    }

    @Override
    public Iterator<Quad> constructQuads() {
        this.checkNotClosed();
        return this.execQuads();
    }

    @Override
    public DatasetGraph constructDataset() {
        this.checkNotClosed();
        return this.constructDataset(DatasetGraphFactory.createTxnMem());
    }

    @Override
    public DatasetGraph constructDataset(DatasetGraph dataset) {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT);
        return this.execDataset(dataset);
    }

    @Override
    public Graph describe(Graph graph) {
        this.checkNotClosed();
        this.check(QueryType.DESCRIBE);
        return this.execGraph(graph, this.graphAcceptHeader);
    }

    @Override
    public Iterator<Triple> describeTriples() {
        this.checkNotClosed();
        return this.execTriples(this.graphAcceptHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph execGraph(Graph graph, String acceptHeader) {
        Pair<InputStream, Lang> p = this.execRdfWorker(acceptHeader, "application/rdf+xml");
        InputStream in = p.getLeft();
        Lang lang = p.getRight();
        try {
            RDFDataMgr.read(graph, in, lang);
        }
        finally {
            HttpLib.finishInputStream(in);
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasetGraph execDataset(DatasetGraph dataset) {
        Pair<InputStream, Lang> p = this.execRdfWorker(this.datasetAcceptHeader, "application/n-quads");
        InputStream in = p.getLeft();
        Lang lang = p.getRight();
        try {
            RDFDataMgr.read(dataset, in, lang);
        }
        finally {
            HttpLib.finishInputStream(in);
        }
        return dataset;
    }

    private Iterator<Triple> execTriples(String acceptHeader) {
        Pair<InputStream, Lang> p = this.execRdfWorker(acceptHeader, "application/rdf+xml");
        InputStream input = p.getLeft();
        Lang lang = p.getRight();
        Iterator<Triple> iter = IteratorParsers.createIteratorTriples(input, lang, null);
        return Iter.onCloseIO(iter, input);
    }

    private Iterator<Quad> execQuads() {
        this.checkNotClosed();
        Pair<InputStream, Lang> p = this.execRdfWorker(this.datasetAcceptHeader, "application/n-quads");
        InputStream input = p.getLeft();
        Lang lang = p.getRight();
        Iterator<Quad> iter = IteratorParsers.createIteratorQuads(input, lang, null);
        return Iter.onCloseIO(iter, input);
    }

    private Pair<InputStream, Lang> execRdfWorker(String contentType, String ifNoContentType) {
        Lang lang;
        String actualContentType;
        this.checkNotClosed();
        String thisAcceptHeader = contentType;
        HttpRequest request = this.effectiveHttpRequest(thisAcceptHeader);
        HttpResponse<InputStream> response = this.executeQuery(request);
        InputStream in = this.registerInputStream(response);
        this.httpResponseContentType = actualContentType = HttpLib.responseHeader(response, "Content-Type");
        actualContentType = this.removeCharset(actualContentType);
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = ifNoContentType;
        }
        if (!RDFLanguages.isQuads(lang = RDFLanguages.contentTypeToLang(actualContentType)) && !RDFLanguages.isTriples(lang)) {
            this.raiseException("Endpoint returned Content Type: " + actualContentType + " which is not a valid RDF syntax", request, response, in);
        }
        return Pair.create(in, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonArray execJson() {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT_JSON);
        String thisAcceptHeader = HttpLib.dft(this.overrideAcceptHeader, "application/json");
        HttpRequest request = this.effectiveHttpRequest(thisAcceptHeader);
        HttpResponse<InputStream> response = this.executeQuery(request);
        InputStream in = this.registerInputStream(response);
        try {
            JsonArray jsonArray = JSON.parseAny(in).getAsArray();
            return jsonArray;
        }
        finally {
            HttpLib.finishInputStream(in);
        }
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        JsonArray array = this.execJson().getAsArray();
        ArrayList x = new ArrayList(array.size());
        array.forEach(elt -> {
            if (!elt.isObject()) {
                throw new QueryExecException("Item in an array from a JSON query isn't an object");
            }
            x.add(elt.getAsObject());
        });
        return x.iterator();
    }

    private void check(QueryType queryType) {
        if (this.query == null) {
            return;
        }
        if (this.query.queryType() != queryType) {
            throw new QueryExecException("Not the right form of query. Expected " + String.valueOf((Object)queryType) + " but got " + String.valueOf((Object)this.query.queryType()));
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public DatasetGraph getDataset() {
        return null;
    }

    @Override
    public Query getQuery() {
        if (this.query != null) {
            return this.query;
        }
        if (this.queryString != null) {
            try {
                return QueryFactory.create(this.queryString, Syntax.syntaxARQ);
            }
            catch (QueryParseException queryParseException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    private void raiseException(String errorMsg, HttpRequest request, HttpResponse<?> response, InputStream in) {
        Object bodyStr;
        int bodySummaryLength = 1024;
        int statusCode = response.statusCode();
        String statusCodeMsg = HttpSC.getMessage(statusCode);
        String actualContentType = HttpLib.responseHeader(response, "Content-Type");
        MediaType ct = MediaType.create(actualContentType);
        String charsetName = ct == null ? null : ct.getCharset();
        Charset charset = null;
        try {
            charset = charsetName == null ? null : Charset.forName(charsetName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try {
            bodyStr = in == null ? "(no data supplied)" : IO.abbreviate(in, charset, bodySummaryLength, "...");
        }
        catch (Throwable e2) {
            bodyStr = "(failed to retrieve HTTP body due to: " + e2.getMessage() + ")";
        }
        throw new QueryException(String.format("%s.\nStatus code %d %s, Method %s, Request Headers: %s\nBody (extracted with charset %s): %s", errorMsg, statusCode, statusCodeMsg, request.method(), request.headers().map(), charset.name(), bodyStr));
    }

    private HttpRequest effectiveHttpRequest(String reqAcceptHeader) {
        if (this.closed) {
            throw new ARQException("HTTP execution already closed");
        }
        Params thisParams = Params.create(this.params);
        if (this.defaultGraphURIs != null) {
            for (String dft : this.defaultGraphURIs) {
                thisParams.add("default-graph-uri", dft);
            }
        }
        if (this.namedGraphURIs != null) {
            for (String name : this.namedGraphURIs) {
                thisParams.add("named-graph-uri", name);
            }
        }
        HttpLib.modifyByService(this.service, this.context, thisParams, this.httpHeaders);
        HttpRequest request = this.makeRequest(thisParams, reqAcceptHeader);
        return request;
    }

    private HttpRequest makeRequest(Params thisParams, String reqAcceptHeader) {
        QuerySendMode actualSendMode = this.actualSendMode();
        return (switch (actualSendMode) {
            case QuerySendMode.asGetAlways -> this.executeQueryGet(thisParams, reqAcceptHeader);
            case QuerySendMode.asPostForm -> this.executeQueryPostForm(thisParams, reqAcceptHeader);
            case QuerySendMode.asPost -> this.executeQueryPostBody(thisParams, reqAcceptHeader);
            default -> throw new InternalErrorException("Invalid value for 'actualSendMode' " + String.valueOf((Object)actualSendMode));
        }).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse<InputStream> executeQuery(HttpRequest request) {
        this.checkNotClosed();
        if (this.future != null) {
            throw new IllegalStateException("Execution was already started.");
        }
        try {
            Object object = this.abortLock;
            synchronized (object) {
                this.checkNotAborted();
                QueryExecHTTP.logQuery(this.queryString, request);
                this.future = HttpLib.executeAsync(this.httpClient, request);
            }
            HttpResponse<InputStream> response = AsyncHttpRDF.getOrElseThrow(this.future, request);
            HttpLib.handleHttpStatusCode(response);
            return response;
        }
        catch (HttpException httpEx) {
            throw QueryExceptionHTTP.rewrap(httpEx);
        }
    }

    private QuerySendMode actualSendMode() {
        int thisLengthLimit = this.urlLimit;
        switch (this.sendMode) {
            case asGetAlways: 
            case asPostForm: 
            case asPost: {
                return this.sendMode;
            }
        }
        String requestURL = this.service;
        int paramsLength = this.params.httpString().length();
        int qEncodedLength = QueryExecHTTP.calcEncodeStringLength(this.queryString);
        int length = this.service.length() + 1 + "query".length() + qEncodedLength + 1 + paramsLength;
        if (length <= thisLengthLimit) {
            return QuerySendMode.asGetAlways;
        }
        return this.sendMode == QuerySendMode.asGetWithLimitBody ? QuerySendMode.asPost : QuerySendMode.asPostForm;
    }

    private static int calcEncodeStringLength(String str2) {
        String qs = HttpLib.urlEncodeQueryString(str2);
        int encodedLength = qs.length();
        return encodedLength;
    }

    private HttpRequest.Builder executeQueryGet(Params thisParams, String acceptHeader) {
        thisParams.add("query", this.queryString);
        String requestURL = HttpLib.requestURL(this.service, thisParams.httpString());
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.readTimeout, this.readTimeoutUnit);
        HttpLib.acceptHeader(builder, acceptHeader);
        return builder.GET();
    }

    private HttpRequest.Builder executeQueryPostForm(Params thisParams, String acceptHeader) {
        thisParams.add("query", this.queryString);
        String requestURL = this.service;
        String formBody = thisParams.httpString();
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.readTimeout, this.readTimeoutUnit);
        HttpLib.acceptHeader(builder, acceptHeader);
        HttpLib.contentTypeHeader(builder, "application/x-www-form-urlencoded");
        return builder.POST(HttpRequest.BodyPublishers.ofString(formBody, StandardCharsets.US_ASCII));
    }

    private HttpRequest.Builder executeQueryPostBody(Params thisParams, String acceptHeader) {
        String requestURL = HttpLib.requestURL(this.service, thisParams.httpString());
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.readTimeout, this.readTimeoutUnit);
        HttpLib.contentTypeHeader(builder, QUERY_MIME_TYPE);
        HttpLib.acceptHeader(builder, acceptHeader);
        return builder.POST(HttpRequest.BodyPublishers.ofString(this.queryString));
    }

    private static void logQuery(String queryString, HttpRequest request) {
    }

    @Override
    public void abort() {
        this.isAborted = true;
        if (this.cancelFutureOnAbort) {
            QueryExecHTTP.cancelFuture(this.future);
        }
    }

    private InputStream registerInputStream(HttpResponse<InputStream> httpResponse) {
        InputStream in = HttpLib.getInputStream(httpResponse);
        this.registerInputStream(in);
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream registerInputStream(InputStream input) {
        Object object = this.abortLock;
        synchronized (object) {
            this.retainedConnection = input;
            this.retainedConnectionView = new ProxyInputStream(input){

                @Override
                protected void beforeRead(int n) throws IOException {
                    QueryExecHTTP.this.checkNotAborted();
                    super.beforeRead(n);
                }

                @Override
                public void close() {
                    this.in = ClosedInputStream.INSTANCE;
                }
            };
            this.checkNotAborted();
        }
        return this.retainedConnectionView;
    }

    @Override
    public void close() {
        this.closed = true;
        IOUtils.closeQuietly(this.retainedConnectionView);
        this.closeRetainedConnection();
    }

    private static void cancelFuture(CompletableFuture<?> future) {
        if (future != null) {
            future.cancel(true);
        }
    }

    private void closeRetainedConnection() {
        if (this.retainedConnection != null) {
            try {
                if (this.retainedConnection.read() != -1) {
                    Log.warn(this, "HTTP response not fully consumed, if HTTP Client is reusing connections (its default behaviour) then it will consume the remaining response data which may take a long time and cause this application to become unresponsive");
                }
                this.retainedConnection.close();
            }
            catch (IOException | RuntimeIOException exception) {
            }
            finally {
                this.retainedConnection = null;
            }
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new QueryExecException("HTTP QueryExecHTTP has been closed");
        }
    }

    protected void checkNotAborted() {
        if (this.isAborted) {
            throw new QueryCancelledException();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

