/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.Random;
import java.util.UUID;
import java.util.function.LongSupplier;

public final class PrefixCombFactory
extends AbstCombFactory {
    public PrefixCombFactory() {
        this(PrefixCombFactory.builder());
    }

    public PrefixCombFactory(Clock clock) {
        this((Builder)PrefixCombFactory.builder().withClock(clock));
    }

    public PrefixCombFactory(Random random) {
        this((Builder)PrefixCombFactory.builder().withRandom(random));
    }

    public PrefixCombFactory(Random random, Clock clock) {
        this((Builder)((Builder)PrefixCombFactory.builder().withRandom(random)).withClock(clock));
    }

    public PrefixCombFactory(LongSupplier randomFunction) {
        this((Builder)PrefixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public PrefixCombFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)PrefixCombFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    private PrefixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID create() {
        this.lock.lock();
        try {
            long time = ((Instant)this.instantFunction.get()).toEpochMilli();
            long long1 = this.random.nextLong(2);
            long long2 = this.random.nextLong(8);
            UUID uUID = this.make(time, long1, long2);
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    private UUID make(long time, long long1, long long2) {
        return this.toUuid(time << 16 | long1 & 0xFFFFL, long2);
    }

    public static class Builder
    extends AbstCombFactory.Builder<PrefixCombFactory, Builder> {
        @Override
        public PrefixCombFactory build() {
            return new PrefixCombFactory(this);
        }
    }
}

