/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.HyperLogLog;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.ObjectBigArray;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class HyperLogLogBigArray {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(HyperLogLogBigArray.class);
    private final ObjectBigArray<HyperLogLog> array = new ObjectBigArray();
    private long sizeOfHyperLogLog;

    public long sizeOf() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf(this.array) + this.sizeOfHyperLogLog;
    }

    public HyperLogLog get(long index) {
        return this.array.get(index);
    }

    public HyperLogLog get(long index, double maxStandardError) {
        return this.get(index, new HyperLogLog(maxStandardError));
    }

    public HyperLogLog get(long index, HyperLogLog hll) {
        HyperLogLog result = this.array.get(index);
        if (result == null) {
            this.set(index, hll);
            return hll;
        }
        return result;
    }

    public void set(long index, HyperLogLog hll) {
        this.updateRetainedSize(index, hll);
        this.array.set(index, hll);
    }

    public boolean isEmpty() {
        return this.sizeOfHyperLogLog == 0L;
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    public void updateRetainedSize(long index, HyperLogLog value) {
        HyperLogLog hll = this.array.get(index);
        if (hll != null) {
            this.sizeOfHyperLogLog -= hll.getEstimatedSize();
        }
        if (value != null) {
            this.sizeOfHyperLogLog += value.getEstimatedSize();
        }
    }

    public void reset() {
        this.array.forEach(item -> {
            if (item != null) {
                item.reset();
            }
        });
    }
}

