/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PollFilePayload
implements SubscriptionPollPayload {
    private transient SubscriptionCommitContext commitContext;
    private transient long writingOffset;

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public long getWritingOffset() {
        return this.writingOffset;
    }

    public PollFilePayload() {
    }

    public PollFilePayload(SubscriptionCommitContext commitContext, long writingOffset) {
        this.commitContext = commitContext;
        this.writingOffset = writingOffset;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.commitContext.serialize(stream);
        ReadWriteIOUtils.write((long)this.writingOffset, (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        this.commitContext = SubscriptionCommitContext.deserialize(buffer);
        this.writingOffset = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PollFilePayload that = (PollFilePayload)obj;
        return Objects.equals(this.commitContext, that.commitContext) && Objects.equals(this.writingOffset, that.writingOffset);
    }

    public int hashCode() {
        return Objects.hash(this.commitContext, this.writingOffset);
    }

    public String toString() {
        return "PollFilePayload{commitContext=" + this.commitContext + ", writingOffset=" + this.writingOffset + "}";
    }
}

