/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.heartbeat;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeSinkCriticalException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMetaInCoordinator;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.heartbeat.PipeHeartbeat;
import org.apache.iotdb.confignode.manager.pipe.resource.PipeConfigNodeResourceManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatParser.class);
    private final ConfigManager configManager;
    private long heartbeatCounter;
    private int registeredNodeNumber;
    private final AtomicBoolean needWriteConsensusOnConfigNodes;
    private final AtomicBoolean needPushPipeMetaToDataNodes;

    PipeHeartbeatParser(ConfigManager configManager) {
        this.configManager = configManager;
        this.heartbeatCounter = 0L;
        this.registeredNodeNumber = 1;
        this.needWriteConsensusOnConfigNodes = new AtomicBoolean(false);
        this.needPushPipeMetaToDataNodes = new AtomicBoolean(false);
    }

    synchronized void parseHeartbeat(int nodeId, PipeHeartbeat pipeHeartbeat) {
        long heartbeatCount = ++this.heartbeatCounter;
        AtomicBoolean canSubmitHandleMetaChangeProcedure = new AtomicBoolean(false);
        if (heartbeatCount % (long)this.registeredNodeNumber == 0L) {
            canSubmitHandleMetaChangeProcedure.set(true);
            this.registeredNodeNumber = this.configManager.getNodeManager().getRegisteredNodeCount();
            if (this.registeredNodeNumber <= 0) {
                LOGGER.warn("registeredNodeNumber is {} when parseHeartbeat from node (id={}).", (Object)this.registeredNodeNumber, (Object)nodeId);
                this.registeredNodeNumber = 1;
            }
        }
        if (pipeHeartbeat.isEmpty() && (!canSubmitHandleMetaChangeProcedure.get() || !this.needWriteConsensusOnConfigNodes.get() && !this.needPushPipeMetaToDataNodes.get())) {
            return;
        }
        this.configManager.getPipeManager().getPipeRuntimeCoordinator().getProcedureSubmitter().submit(() -> {
            AtomicReference<PipeTaskInfo> pipeTaskInfo = this.configManager.getPipeManager().getPipeTaskCoordinator().tryLock();
            if (pipeTaskInfo == null) {
                LOGGER.warn("Failed to acquire lock when parseHeartbeat from node (id={}).", (Object)nodeId);
                return;
            }
            try {
                if (!pipeHeartbeat.isEmpty()) {
                    this.parseHeartbeatAndSaveMetaChangeLocally(pipeTaskInfo, nodeId, pipeHeartbeat);
                }
                if (canSubmitHandleMetaChangeProcedure.get() && (this.needWriteConsensusOnConfigNodes.get() || this.needPushPipeMetaToDataNodes.get())) {
                    this.configManager.getProcedureManager().pipeHandleMetaChange(this.needWriteConsensusOnConfigNodes.get(), this.needPushPipeMetaToDataNodes.get());
                    this.needWriteConsensusOnConfigNodes.set(false);
                    this.needPushPipeMetaToDataNodes.set(false);
                }
            }
            finally {
                this.configManager.getPipeManager().getPipeTaskCoordinator().unlock();
            }
        });
    }

    private void parseHeartbeatAndSaveMetaChangeLocally(AtomicReference<PipeTaskInfo> pipeTaskInfo, int nodeId, PipeHeartbeat pipeHeartbeat) {
        for (PipeMeta pipeMetaFromCoordinator : pipeTaskInfo.get().getPipeMetaList()) {
            PipeStaticMeta staticMeta = pipeMetaFromCoordinator.getStaticMeta();
            PipeMeta pipeMetaFromAgent = pipeHeartbeat.getPipeMeta(staticMeta);
            if (pipeMetaFromAgent == null) {
                LOGGER.info("PipeRuntimeCoordinator meets error in updating pipeMetaKeeper, pipeMetaFromAgent is null, pipeMetaFromCoordinator: {}", (Object)pipeMetaFromCoordinator);
                continue;
            }
            PipeTemporaryMetaInCoordinator temporaryMeta = (PipeTemporaryMetaInCoordinator)pipeMetaFromCoordinator.getTemporaryMeta();
            Boolean isPipeCompletedFromAgent = pipeHeartbeat.isCompleted(staticMeta);
            if (Boolean.TRUE.equals(isPipeCompletedFromAgent)) {
                temporaryMeta.markDataNodeCompleted(nodeId);
                Set<Integer> uncompletedDataNodeIds = this.configManager.getNodeManager().getRegisteredDataNodeLocations().keySet();
                uncompletedDataNodeIds.removeAll(temporaryMeta.getCompletedDataNodeIds());
                if (uncompletedDataNodeIds.isEmpty()) {
                    pipeTaskInfo.get().removePipeMeta(staticMeta.getPipeName());
                    LOGGER.info("Detected completion of pipe {}, static meta: {}, remove it.", (Object)staticMeta.getPipeName(), (Object)staticMeta);
                    this.needWriteConsensusOnConfigNodes.set(true);
                    this.needPushPipeMetaToDataNodes.set(true);
                    continue;
                }
            }
            temporaryMeta.setRemainingEvent(nodeId, pipeHeartbeat.getRemainingEventCount(staticMeta).longValue());
            temporaryMeta.setRemainingTime(nodeId, pipeHeartbeat.getRemainingTime(staticMeta).doubleValue());
            ConcurrentMap pipeTaskMetaMapFromCoordinator = pipeMetaFromCoordinator.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            ConcurrentMap pipeTaskMetaMapFromAgent = pipeMetaFromAgent.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            for (Map.Entry runtimeMetaFromCoordinator : pipeTaskMetaMapFromCoordinator.entrySet()) {
                if (((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getLeaderNodeId() != nodeId) continue;
                PipeTaskMeta runtimeMetaFromAgent = (PipeTaskMeta)pipeTaskMetaMapFromAgent.get(runtimeMetaFromCoordinator.getKey());
                if (runtimeMetaFromAgent == null) {
                    LOGGER.debug("No corresponding Pipe is running in the reported DataRegion. runtimeMetaFromAgent is null, runtimeMetaFromCoordinator: {}", runtimeMetaFromCoordinator);
                    continue;
                }
                if (!((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getProgressIndex().isAfter(runtimeMetaFromAgent.getProgressIndex()) && !((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getProgressIndex().equals(runtimeMetaFromAgent.getProgressIndex())) {
                    ProgressIndex updatedProgressIndex = ((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).updateProgressIndex(runtimeMetaFromAgent.getProgressIndex());
                    PipeConfigNodeResourceManager.log().schedule(PipeHeartbeatParser.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), pipeHeartbeat.getPipeMetaSize()).ifPresent(l -> l.info("Updated progress index for (pipe name: {}, consensus group id: {}) ... Progress index on coordinator: {}, progress index from agent: {}, updated progressIndex: {}", new Object[]{pipeMetaFromCoordinator.getStaticMeta().getPipeName(), runtimeMetaFromCoordinator.getKey(), ((PipeTaskMeta)runtimeMetaFromCoordinator.getValue()).getProgressIndex(), runtimeMetaFromAgent.getProgressIndex(), updatedProgressIndex}));
                    this.needWriteConsensusOnConfigNodes.set(true);
                }
                PipeTaskMeta pipeTaskMetaFromCoordinator = (PipeTaskMeta)runtimeMetaFromCoordinator.getValue();
                pipeTaskMetaFromCoordinator.clearExceptionMessages();
                for (PipeRuntimeException exception : runtimeMetaFromAgent.getExceptionMessages()) {
                    pipeTaskMetaFromCoordinator.trackExceptionMessage(exception);
                    if (!(exception instanceof PipeRuntimeCriticalException)) continue;
                    String pipeName = pipeMetaFromCoordinator.getStaticMeta().getPipeName();
                    if (!((PipeStatus)pipeMetaFromCoordinator.getRuntimeMeta().getStatus().get()).equals((Object)PipeStatus.STOPPED)) {
                        PipeRuntimeMeta runtimeMeta2 = pipeMetaFromCoordinator.getRuntimeMeta();
                        runtimeMeta2.getStatus().set(PipeStatus.STOPPED);
                        runtimeMeta2.setIsStoppedByRuntimeException(true);
                        this.needWriteConsensusOnConfigNodes.set(true);
                        this.needPushPipeMetaToDataNodes.set(false);
                        LOGGER.warn("Detect PipeRuntimeCriticalException {} from agent, stop pipe {}.", (Object)exception, (Object)pipeName);
                    }
                    if (!(exception instanceof PipeRuntimeSinkCriticalException)) continue;
                    ((PipeTableResp)pipeTaskInfo.get().showPipes()).filter(true, pipeName).getAllPipeMeta().stream().filter(pipeMeta -> !pipeMeta.getStaticMeta().getPipeName().equals(pipeName)).map(PipeMeta::getRuntimeMeta).filter(runtimeMeta -> !((PipeStatus)runtimeMeta.getStatus().get()).equals((Object)PipeStatus.STOPPED)).forEach(runtimeMeta -> {
                        ConcurrentMap exceptionMap = runtimeMeta.getNodeId2PipeRuntimeExceptionMap();
                        if (!exceptionMap.containsKey(nodeId) || ((PipeRuntimeException)exceptionMap.get(nodeId)).getTimeStamp() < exception.getTimeStamp()) {
                            exceptionMap.put(nodeId, exception);
                        }
                        runtimeMeta.getStatus().set(PipeStatus.STOPPED);
                        runtimeMeta.setIsStoppedByRuntimeException(true);
                        this.needWriteConsensusOnConfigNodes.set(true);
                        this.needPushPipeMetaToDataNodes.set(false);
                        LOGGER.warn(String.format("Detect PipeRuntimeConnectorCriticalException %s from agent, stop pipe %s.", exception, pipeName));
                    });
                }
            }
        }
    }
}

