/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.memory;

import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;

public abstract class PipelineMemoryEstimator {
    protected final List<PipelineMemoryEstimator> children;
    protected final Operator root;
    protected final int dependencyPipelineIndex;

    protected PipelineMemoryEstimator(Operator root, int dependencyPipelineIndex) {
        this.root = root;
        this.dependencyPipelineIndex = dependencyPipelineIndex;
        this.children = new LinkedList<PipelineMemoryEstimator>();
    }

    public long getEstimatedMemoryUsageInBytes() {
        return this.calculateEstimatedRunningMemorySize() + this.calculateRetainedMemorySize();
    }

    public abstract long calculateEstimatedRunningMemorySize();

    protected long calculateRetainedMemorySize() {
        return this.root.ramBytesUsed() + this.children.stream().map(PipelineMemoryEstimator::calculateRetainedMemorySize).reduce(0L, Long::sum);
    }

    public void addChildren(List<PipelineMemoryEstimator> child) {
        this.children.addAll(child);
    }

    protected int getDependencyPipelineIndex() {
        return this.dependencyPipelineIndex;
    }

    public List<PipelineMemoryEstimator> getChildren() {
        return this.children;
    }

    public Operator getRoot() {
        return this.root;
    }
}

