/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.runtime.OidcTenantConfig;
import java.util.Map;

public final class LogoutUtils {
    private static final String FORM_POST_LOGOUT_START = "<html>   <head><title>Logout Form</title></head>   <body onload=\"javascript:document.forms[0].submit()\">    <form method=\"post\" action=\"";
    private static final String FORM_POST_LOGOUT_END = "    </form></body></html>";

    private LogoutUtils() {
    }

    public static String createFormPostLogout(OidcTenantConfig.Logout logoutConfig, String logoutUrl, String idToken, String postLogoutUrl, String postLogoutState) {
        Map<String, String> extraParams;
        StringBuilder sb = new StringBuilder();
        sb.append(FORM_POST_LOGOUT_START);
        sb.append(logoutUrl).append("\">");
        if (idToken != null) {
            LogoutUtils.addInput(sb, "id_token_hint", idToken);
        }
        if (postLogoutUrl != null) {
            LogoutUtils.addInput(sb, logoutConfig.postLogoutUriParam(), postLogoutUrl);
        }
        if (postLogoutState != null) {
            LogoutUtils.addInput(sb, "state", postLogoutState);
        }
        if ((extraParams = logoutConfig.extraParams()) != null) {
            for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                LogoutUtils.addInput(sb, entry.getKey(), entry.getValue());
            }
        }
        sb.append(FORM_POST_LOGOUT_END);
        return sb.toString();
    }

    private static void addInput(StringBuilder sb, String name, String value) {
        sb.append("<input type=\"hidden\" name=\"").append(name).append("\" ").append("value=\"").append(value).append("\"").append("/>");
    }
}

