/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.StorageLocation;

public abstract class InMemoryStorageIntegration<T extends PolarisStorageConfigurationInfo>
extends PolarisStorageIntegration<T> {
    public InMemoryStorageIntegration(String identifierOrId) {
        super(identifierOrId);
    }

    public static Map<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>> validateSubpathsOfAllowedLocations(@Nonnull PolarisStorageConfigurationInfo storageConfig, @Nonnull Set<PolarisStorageActions> actions, @Nonnull Set<String> locations) {
        Set allowedLocationStrings = storageConfig.getAllowedLocations().stream().map(str -> {
            if (str.endsWith("/") && str.length() > 1) {
                return str.substring(0, str.length() - 1);
            }
            return str;
        }).map(str -> str.replace("file:///", "file:/")).collect(Collectors.toSet());
        List allowedLocations = allowedLocationStrings.stream().map(StorageLocation::of).collect(Collectors.toList());
        boolean allowWildcardLocation = Optional.ofNullable(CallContext.getCurrentContext()).map(ctx -> ctx.getPolarisCallContext().getConfigurationStore().getConfiguration(ctx.getRealmContext(), "ALLOW_WILDCARD_LOCATION", false)).orElse(false);
        if (allowWildcardLocation && allowedLocationStrings.contains("*")) {
            return locations.stream().collect(Collectors.toMap(Function.identity(), loc -> actions.stream().collect(Collectors.toMap(Function.identity(), a -> new PolarisStorageIntegration.ValidationResult(true, loc + " in the list of allowed locations")))));
        }
        HashMap<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>> resultMap = new HashMap<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>>();
        for (String rawLocation : locations) {
            StorageLocation storageLocation = StorageLocation.of(rawLocation);
            boolean isValidLocation = allowedLocations.stream().anyMatch(storageLocation::isChildOf);
            Map locationResult = actions.stream().collect(Collectors.toMap(Function.identity(), a -> new PolarisStorageIntegration.ValidationResult(isValidLocation, rawLocation + " is " + (isValidLocation ? "" : "not ") + "in the list of allowed locations: " + String.valueOf(allowedLocations))));
            resultMap.put(rawLocation, locationResult);
        }
        return resultMap;
    }

    @Override
    @Nonnull
    public Map<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>> validateAccessToLocations(@Nonnull T storageConfig, @Nonnull Set<PolarisStorageActions> actions, @Nonnull Set<String> locations) {
        return InMemoryStorageIntegration.validateSubpathsOfAllowedLocations(storageConfig, actions, locations);
    }
}

