/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { CommonI18n } from "../CommonI18n";
import { names } from "../names";

export const en: CommonI18n = {
  names,
  terms: {
    apply: "Apply",
    available: "Available",
    back: "Back",
    cancel: "Cancel",
    change: "Change",
    close: "Close",
    copy: "Copy",
    configure: "Configure",
    confirm: "Confirm",
    connected: "Connected",
    continue: "Continue",
    cut: "Cut",
    deploy: "Deploy",
    disconnected: "Disconnected",
    dismiss: "Dismiss",
    done: "Done",
    download: "Download",
    edit: "Edit",
    edited: "Edited",
    evaluation: "Evaluation",
    exit: "Exit",
    file: "File",
    files: "Files",
    forum: "Forum",
    fullScreen: "Full Screen",
    host: "Host",
    install: "Install",
    inputs: "Inputs",
    launch: "Launch",
    loading: "Loading",
    macosApplicationFolder: "Application",
    namespace: "Namespace (project)",
    new: "New",
    next: "Next",
    note: "Note",
    open: "Open",
    oops: "Oops",
    os: {
      initials: "OS",
      full: "Operating System",
    },
    outputs: "Outputs",
    paste: "Paste",
    poweredBy: "Powered by",
    quit: "Quit",
    readonly: "Read-only",
    redo: "Redo",
    reset: "Reset",
    run: "Run",
    save: "Save",
    selection: "Selection",
    setup: "Setup",
    start: "Start",
    token: "Token",
    undo: "Undo",
    uninstall: "Uninstall",
    username: "Username",
    validation: "Validation",
  },
};
