/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.configuration.annotation.Secret;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConverterToMapVisitorBuilder;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.util.IgniteUtils;

public class ConverterToMapVisitor
implements ConfigurationVisitor<Object> {
    private static final String MASKED_VALUE = "********";
    private final boolean includeInternal;
    private final boolean includeDeprecated;
    private final boolean skipEmptyValues;
    private final boolean maskSecretValues;
    private final Deque<Object> deque = new ArrayDeque<Object>();

    public static ConverterToMapVisitorBuilder builder() {
        return new ConverterToMapVisitorBuilder();
    }

    ConverterToMapVisitor(boolean includeInternal, boolean includeDeprecated, boolean skipEmptyValues, boolean maskSecretValues) {
        this.includeInternal = includeInternal;
        this.includeDeprecated = includeDeprecated;
        this.skipEmptyValues = skipEmptyValues;
        this.maskSecretValues = maskSecretValues;
    }

    @Override
    public Object visitLeafNode(Field field, String key, Serializable val) {
        if (!this.includeDeprecated && field.isAnnotationPresent(Deprecated.class)) {
            return null;
        }
        Object valObj = val;
        if (val instanceof Character || val instanceof UUID) {
            valObj = val.toString();
        } else if (val != null && val.getClass().isArray()) {
            valObj = ConverterToMapVisitor.toListOfObjects(val);
        } else if (val instanceof String) {
            valObj = this.maskIfNeeded(field, (String)((Object)val));
        }
        this.addToParent(key, valObj);
        return valObj;
    }

    @Override
    public Object visitInnerNode(Field field, String key, InnerNode node) {
        if (this.skipEmptyValues && node == null) {
            return null;
        }
        if (!this.includeDeprecated && field != null && field.isAnnotationPresent(Deprecated.class)) {
            return null;
        }
        HashMap innerMap = new HashMap();
        this.deque.push(innerMap);
        node.traverseChildren(this, this.includeInternal);
        this.deque.pop();
        String injectedValueFieldName = node.injectedValueFieldName();
        if (injectedValueFieldName != null) {
            Object injectedValue = innerMap.get(injectedValueFieldName);
            this.addToParent(key, injectedValue);
            return injectedValue;
        }
        this.addToParent(key, innerMap);
        return innerMap;
    }

    @Override
    public Object visitNamedListNode(Field field, String key, NamedListNode<?> node) {
        Cloneable renderedList;
        boolean hasInjectedValues;
        if (this.skipEmptyValues && node.isEmpty()) {
            return null;
        }
        if (!this.includeDeprecated && field.isAnnotationPresent(Deprecated.class)) {
            return null;
        }
        boolean bl = hasInjectedValues = !node.isEmpty() && ConverterToMapVisitor.getFirstNode(node).injectedValueFieldName() != null;
        if (hasInjectedValues) {
            HashMap map = IgniteUtils.newHashMap((int)node.size());
            this.deque.push(map);
            for (String subkey : node.namedListKeys()) {
                InnerNode innerNode = node.getInnerNode(subkey);
                innerNode.accept(field, subkey, this);
            }
            renderedList = map;
        } else {
            ArrayList list = new ArrayList(node.size());
            this.deque.push(list);
            for (String subkey : node.namedListKeys()) {
                InnerNode innerNode = node.getInnerNode(subkey);
                innerNode.accept(field, subkey, this);
                ((Map)list.get(list.size() - 1)).put(node.syntheticKeyName(), subkey);
            }
            renderedList = list;
        }
        this.deque.pop();
        this.addToParent(key, renderedList);
        return renderedList;
    }

    private static InnerNode getFirstNode(NamedListNode<?> namedListNode) {
        String firstKey = namedListNode.namedListKeys().get(0);
        return namedListNode.getInnerNode(firstKey);
    }

    private void addToParent(String key, Object val) {
        Object parent = this.deque.peek();
        if (this.skipEmptyValues && val == null) {
            return;
        }
        if (parent instanceof Map) {
            Map map;
            if (this.skipEmptyValues && val instanceof Map && (map = (Map)val).isEmpty()) {
                return;
            }
            ((Map)parent).put(key, val);
        } else if (parent instanceof List) {
            List list;
            if (this.skipEmptyValues && val instanceof List && (list = (List)val).isEmpty()) {
                return;
            }
            ((Collection)parent).add(val);
        }
    }

    private static List<?> toListOfObjects(Serializable val) {
        Stream<Object> stream = IntStream.range(0, Array.getLength(val)).mapToObj(i -> Array.get(val, i));
        if (val.getClass().getComponentType() == Character.TYPE || val.getClass().getComponentType() == UUID.class) {
            stream = stream.map(Object::toString);
        }
        return stream.collect(Collectors.toList());
    }

    private Object maskIfNeeded(Field field, String val) {
        if (!this.maskSecretValues) {
            return val;
        }
        if (field != null && field.isAnnotationPresent(Secret.class)) {
            return MASKED_VALUE;
        }
        return val;
    }
}

