/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HiveSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withIdentifierQuoteString("`").withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new HiveSqlDialect(DEFAULT_CONTEXT);
    private final boolean emulateNullDirection;

    public HiveSqlDialect(SqlDialect.Context context) {
        super(context);
        this.emulateNullDirection = context.databaseMajorVersion() < 2 || context.databaseMajorVersion() == 2 && context.databaseMinorVersion() < 1;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        HiveSqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.emulateNullDirection) {
            return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
        }
        return null;
    }

    @Override
    public RexNode prepareUnparse(RexNode rexNode) {
        return RelToSqlConverterUtil.unparseIsTrueOrFalse(rexNode);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case ARRAY_VALUE_CONSTRUCTOR: 
            case MAP_VALUE_CONSTRUCTOR: {
                RelToSqlConverterUtil.unparseSparkArrayAndMap(writer, call, leftPrec, rightPrec);
                break;
            }
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("INSTR");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    writer.sep(",");
                    ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
                }
                if (4 == call.operandCount()) {
                    writer.sep(",");
                    ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
                    writer.sep(",");
                    ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
                }
                writer.endFunCall(frame);
                break;
            }
            case MOD: {
                SqlBinaryOperator op = SqlStdOperatorTable.PERCENT_REMAINDER;
                SqlSyntax.BINARY.unparse(writer, op, call, leftPrec, rightPrec);
                break;
            }
            case TRIM: {
                RelToSqlConverterUtil.unparseHiveTrim(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public boolean supportsTimestampPrecision() {
        return false;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            switch (type.getSqlTypeName()) {
                case REAL: {
                    return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("FLOAT", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
                }
                case INTEGER: {
                    SqlAlienSystemTypeNameSpec typeNameSpec = new SqlAlienSystemTypeNameSpec("INT", type.getSqlTypeName(), SqlParserPos.ZERO);
                    return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO);
                }
                case VARCHAR: {
                    if (type.getPrecision() != -1) break;
                    return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("STRING", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
                }
            }
        }
        if (type instanceof AbstractSqlType) {
            switch (type.getSqlTypeName()) {
                case ARRAY: 
                case MAP: 
                case MULTISET: {
                    throw new UnsupportedOperationException("Hive dialect does not support cast to " + (Object)((Object)type.getSqlTypeName()));
                }
            }
        }
        return super.getCastSpec(type);
    }

    @Override
    public SqlNode rewriteSingleValueExpr(SqlNode aggCall, RelDataType relDataType) {
        Object operand = ((SqlBasicCall)aggCall).operand(0);
        SqlLiteral nullLiteral = SqlLiteral.createNull(SqlParserPos.ZERO);
        SqlNodeList sqlNodesList = new SqlNodeList(SqlParserPos.ZERO);
        sqlNodesList.add(SqlLiteral.createBoolean(false, SqlParserPos.ZERO));
        SqlCase caseExpr = new SqlCase(SqlParserPos.ZERO, SqlStdOperatorTable.COUNT.createCall(SqlParserPos.ZERO, (List<? extends SqlNode>)ImmutableList.of((Object)SqlIdentifier.STAR)), SqlNodeList.of(SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO), SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO)), SqlNodeList.of(nullLiteral, SqlStdOperatorTable.MIN.createCall(SqlParserPos.ZERO, new SqlNode[]{operand})), RelToSqlConverterUtil.specialOperatorByName("ASSERT_TRUE").createCall(sqlNodesList));
        LOGGER.debug("SINGLE_VALUE rewritten into [{}]", (Object)caseExpr);
        return caseExpr;
    }
}

