/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.UnitVersionStatus;

public class UnitStatuses {
    private final String id;
    private final List<UnitVersionStatus> versionToStatus;

    private UnitStatuses(String id, List<UnitVersionStatus> versionToStatus) {
        this.id = id;
        this.versionToStatus = versionToStatus;
        this.versionToStatus.sort(Comparator.comparing(UnitVersionStatus::getVersion));
    }

    public String id() {
        return this.id;
    }

    public List<UnitVersionStatus> versionStatuses() {
        return Collections.unmodifiableList(this.versionToStatus);
    }

    public static UnitStatusesBuilder builder(String id) {
        Objects.requireNonNull(id);
        return new UnitStatusesBuilder(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitStatuses that = (UnitStatuses)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.versionToStatus, that.versionToStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.versionToStatus);
    }

    public String toString() {
        return "UnitStatuses{id='" + this.id + "', versionToStatus=" + String.valueOf(this.versionToStatus) + "}";
    }

    public static class UnitStatusesBuilder {
        private final String id;
        private final List<UnitVersionStatus> versionToStatus = new CopyOnWriteArrayList<UnitVersionStatus>();

        public UnitStatusesBuilder(String id) {
            this.id = id;
        }

        public UnitStatusesBuilder append(Version version, DeploymentStatus deploymentStatus) {
            this.versionToStatus.add(new UnitVersionStatus(version, deploymentStatus));
            return this;
        }

        public UnitStatuses build() {
            return new UnitStatuses(this.id, this.versionToStatus);
        }
    }
}

