/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;

public class CollignonProjection
extends Projection {
    private static final double FXC = 1.1283791670955126;
    private static final double FYC = 1.772453850905516;
    private static final double ONEEPS = 1.0000001;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double d;
        out.y = 1.0 - Math.sin(lpphi);
        out.y = d <= 0.0 ? 0.0 : Math.sqrt(out.y);
        out.x = 1.1283791670955126 * lplam * out.y;
        out.y = 1.772453850905516 * (1.0 - out.y);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        double d;
        double d2;
        double lpphi = xyy / 1.772453850905516 - 1.0;
        out.y = 1.0 - lpphi * lpphi;
        if (Math.abs(d2) < 1.0) {
            out.y = Math.asin(lpphi);
        } else {
            if (Math.abs(lpphi) > 1.0000001) {
                throw new ProjectionException("I");
            }
            out.y = lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        out.x = 1.0 - Math.sin(lpphi);
        out.x = d <= 0.0 ? 0.0 : xyx / (1.1283791670955126 * Math.sqrt(out.x));
        out.y = lpphi;
        return out;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Collignon";
    }
}

