/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbProfileView;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.WriteBufferManager;

public class RocksDbStorageProfile {
    private final RocksDbProfileView storageProfileConfig;
    private Cache cache;
    private WriteBufferManager writeBufferManager;

    public RocksDbStorageProfile(RocksDbProfileView storageProfileConfig) {
        this.storageProfileConfig = storageProfileConfig;
    }

    public void start() {
        long writeBufferSize = this.storageProfileConfig.writeBufferSize();
        long totalCacheSize = this.storageProfileConfig.size() + writeBufferSize;
        this.cache = new LRUCache(totalCacheSize, -1, false);
        this.writeBufferManager = new WriteBufferManager(writeBufferSize, this.cache);
    }

    public String name() {
        return this.storageProfileConfig.name();
    }

    public void stop() throws Exception {
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writeBufferManager, this.cache});
    }

    public WriteBufferManager writeBufferManager() {
        return this.writeBufferManager;
    }
}

