/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessageBuilder;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class FinishedTransactionsBatchMessageDeserializer
implements MessageDeserializer<FinishedTransactionsBatchMessage> {
    private final FinishedTransactionsBatchMessageBuilder msg;

    FinishedTransactionsBatchMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.finishedTransactionsBatchMessage();
    }

    public Class<FinishedTransactionsBatchMessage> klass() {
        return FinishedTransactionsBatchMessage.class;
    }

    public FinishedTransactionsBatchMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readCollection("transactions", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactions((Collection<UUID>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FinishedTransactionsBatchMessage.class);
    }
}

