/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.BitSet;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite.internal.sql.engine.exec.rel.StorageScanNode;
import org.apache.ignite.internal.sql.engine.util.FieldDeserializingProjectedTuple;
import org.apache.ignite.internal.util.subscription.TransformingPublisher;
import org.jetbrains.annotations.Nullable;

public class DataSourceScanNode<RowT>
extends StorageScanNode<RowT> {
    private final ScannableDataSource dataSource;
    private final Function<InternalTuple, RowT> converter;

    /*
     * Enabled aggressive block sorting
     */
    public DataSourceScanNode(ExecutionContext<RowT> ctx, RowHandler.RowFactory<RowT> rowFactory, BinaryTupleSchema schema, ScannableDataSource dataSource, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer, @Nullable BitSet requiredColumns) {
        super(ctx, filters, rowTransformer);
        this.dataSource = dataSource;
        if (requiredColumns != null && requiredColumns.cardinality() != schema.elementCount()) {
            int[] mapping = requiredColumns.stream().toArray();
            this.converter = tuple -> rowFactory.create(new FieldDeserializingProjectedTuple(schema, (InternalTuple)tuple, mapping));
            return;
        }
        this.converter = rowFactory::create;
    }

    @Override
    protected Flow.Publisher<RowT> scan() {
        return new TransformingPublisher(this.dataSource.scan(), this.converter);
    }
}

