/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.time.ZoneId;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesHelper;
import org.apache.ignite.table.QualifiedName;
import org.jetbrains.annotations.Nullable;

class ClientSqlProperties {
    @Nullable
    private final String schema;
    private final int pageSize;
    private final long queryTimeout;
    private final long idleTimeout;
    @Nullable
    private final String timeZoneId;

    ClientSqlProperties(ClientMessageUnpacker in) {
        this.schema = in.tryUnpackNil() ? null : QualifiedName.fromSimple((String)in.unpackString()).objectName();
        this.pageSize = in.tryUnpackNil() ? 1024 : in.unpackInt();
        this.queryTimeout = in.tryUnpackNil() ? 0L : in.unpackLong();
        this.idleTimeout = in.tryUnpackNil() ? 0L : in.unpackLong();
        this.timeZoneId = in.tryUnpackNil() ? null : in.unpackString();
        in.unpackInt();
        in.readBinaryUnsafe();
    }

    @Nullable
    public String schema() {
        return this.schema;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public long queryTimeout() {
        return this.queryTimeout;
    }

    public long idleTimeout() {
        return this.idleTimeout;
    }

    SqlProperties toSqlProps() {
        SqlProperties.Builder builder = SqlPropertiesHelper.newBuilder().set(QueryProperty.QUERY_TIMEOUT, (Object)this.queryTimeout);
        if (this.schema != null) {
            builder.set(QueryProperty.DEFAULT_SCHEMA, (Object)this.schema);
        }
        if (this.timeZoneId != null) {
            builder.set(QueryProperty.TIME_ZONE_ID, (Object)ZoneId.of(this.timeZoneId));
        }
        return builder.build();
    }
}

