/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.Arrays;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class RemoveIndexEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<RemoveIndexEntry> SERIALIZER = new RemoveIndexEntrySerializer();
    private final int indexId;

    public RemoveIndexEntry(int indexId) {
        this.indexId = indexId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.REMOVE_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_REMOVED;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new RemoveIndexEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogSchemaDescriptor schema = AbstractChangeIndexStatusEntry.schemaByIndexId(catalog, this.indexId);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), (CatalogIndexDescriptor[])Arrays.stream(schema.indexes()).filter(t -> t.id() != this.indexId).toArray(CatalogIndexDescriptor[]::new), schema.systemViews(), causalityToken), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class RemoveIndexEntrySerializer
    implements CatalogObjectSerializer<RemoveIndexEntry> {
        private RemoveIndexEntrySerializer() {
        }

        @Override
        public RemoveIndexEntry readFrom(IgniteDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            return new RemoveIndexEntry(indexId);
        }

        @Override
        public void writeTo(RemoveIndexEntry entry, IgniteDataOutput out) throws IOException {
            out.writeVarInt((long)entry.indexId);
        }
    }
}

