/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb.flush;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rocksdb.LoggingRocksDbFlushListener;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite.internal.util.CompletableFutures;
import org.rocksdb.FlushJobInfo;
import org.rocksdb.RocksDB;

class RocksDbFlushListener
extends LoggingRocksDbFlushListener {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbFlushListener.class);
    private final RocksDbFlusher flusher;
    private final LogSyncer logSyncer;
    private volatile CompletableFuture<?> lastFlushProcessed = CompletableFutures.nullCompletedFuture();

    RocksDbFlushListener(String name, RocksDbFlusher flusher, LogSyncer logSyncer) {
        super(name);
        this.flusher = flusher;
        this.logSyncer = logSyncer;
    }

    @Override
    protected void onFlushBeginCallback(RocksDB db, FlushJobInfo flushJobInfo) {
        this.lastFlushProcessed.join();
        try {
            this.logSyncer.sync();
        }
        catch (Exception e) {
            LOG.error("Couldn't sync RocksDB WAL on flush begin", (Throwable)e);
        }
    }

    @Override
    protected void onFlushCompletedCallback(RocksDB db, FlushJobInfo flushJobInfo) {
        this.lastFlushProcessed = this.flusher.onFlushCompleted();
    }

    @Override
    public void onFlushCompleted(RocksDB db, FlushJobInfo flushJobInfo) {
        super.onFlushCompleted(db, flushJobInfo);
        this.lastFlushProcessed.whenCompleteAsync((o, throwable) -> this.flusher.completeFutures(flushJobInfo.getLargestSeqno()), (Executor)this.flusher.threadPool);
    }
}

