/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.schema;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TableNotFoundException;

public class SchemaVersionsImpl
implements SchemaVersions {
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;
    private final ClockService clockService;

    public SchemaVersionsImpl(SchemaSyncService schemaSyncService, CatalogService catalogService, ClockService clockService) {
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
        this.clockService = clockService;
    }

    @Override
    public CompletableFuture<Integer> schemaVersionAt(HybridTimestamp timestamp, int tableId) {
        return this.tableDescriptor(tableId, timestamp).thenApply(CatalogTableDescriptor::tableVersion);
    }

    private CompletableFuture<CatalogTableDescriptor> tableDescriptor(int tableId, HybridTimestamp timestamp) {
        return this.schemaSyncService.waitForMetadataCompleteness(timestamp).thenApply(unused -> {
            CatalogTableDescriptor table = this.catalogService.table(tableId, timestamp.longValue());
            if (table == null) {
                throw SchemaVersionsImpl.tableNotFoundException(tableId);
            }
            return table;
        });
    }

    public static TableNotFoundException tableNotFoundException(int tableId) {
        String message = "Table does not exist or was dropped concurrently: " + tableId;
        return new TableNotFoundException(UUID.randomUUID(), ErrorGroups.Table.TABLE_NOT_FOUND_ERR, message, null);
    }

    @Override
    public CompletableFuture<Integer> schemaVersionAtCurrentTime(int tableId) {
        return this.schemaVersionAt(this.clockService.current(), tableId);
    }
}

