/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class TimeZoneHoursCompiledPattern
extends CompiledPattern {
    public TimeZoneHoursCompiledPattern(Set<PatternModifier> modifiers) {
        super(ChronoUnitEnum.TIMEZONE_HOURS, modifiers);
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        return String.format(Locale.ROOT, "%+02d", dateTime.getOffset().getTotalSeconds() / 3600);
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        int timezoneHours;
        int inputOffset = inputPosition.getIndex();
        String inputTrimmed = input.substring(inputOffset);
        boolean isPositive = true;
        if (inputTrimmed.charAt(0) == '-') {
            isPositive = false;
        } else if (inputTrimmed.charAt(0) != '+') {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        inputTrimmed = input.substring(++inputOffset);
        if (!Character.isDigit(inputTrimmed.charAt(0))) {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        int endIndex = inputOffset + 1;
        if (endIndex > input.length() || !Character.isDigit(input.charAt(inputOffset))) {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        if (endIndex < input.length() && Character.isDigit(input.charAt(endIndex))) {
            ++endIndex;
        }
        if ((timezoneHours = Integer.parseInt(input.substring(inputOffset, endIndex))) > 15) {
            throw new ParseException("Value is outside of valid range", inputPosition.getIndex());
        }
        inputPosition.setIndex(endIndex);
        return isPositive ? timezoneHours : -1 * timezoneHours;
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return 3;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

