/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlReturnTypeInferenceChain
implements SqlReturnTypeInference {
    private final ImmutableList<SqlReturnTypeInference> rules;

    SqlReturnTypeInferenceChain(SqlReturnTypeInference ... rules) {
        Preconditions.checkArgument((rules.length > 1 ? 1 : 0) != 0);
        this.rules = ImmutableList.copyOf((Object[])rules);
    }

    @Override
    public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (SqlReturnTypeInference rule : this.rules) {
            RelDataType ret = rule.inferReturnType(opBinding);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

