/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.type;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.sql.ColumnType;

public final class NativeTypeSpec
extends Enum<NativeTypeSpec> {
    public static final /* enum */ NativeTypeSpec INT8 = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec INT16 = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec INT32 = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec INT64 = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec FLOAT = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec DOUBLE = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec DECIMAL = new NativeTypeSpec(false);
    public static final /* enum */ NativeTypeSpec UUID = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec STRING = new NativeTypeSpec(false);
    public static final /* enum */ NativeTypeSpec BYTES = new NativeTypeSpec(false);
    public static final /* enum */ NativeTypeSpec DATE = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec TIME = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec DATETIME = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec TIMESTAMP = new NativeTypeSpec(true);
    public static final /* enum */ NativeTypeSpec BOOLEAN = new NativeTypeSpec(true);
    private static final NativeTypeSpec[] VALUES;
    private final boolean fixedSize;
    private static final /* synthetic */ NativeTypeSpec[] $VALUES;

    public static NativeTypeSpec[] values() {
        return (NativeTypeSpec[])$VALUES.clone();
    }

    public static NativeTypeSpec valueOf(String name) {
        return Enum.valueOf(NativeTypeSpec.class, name);
    }

    private NativeTypeSpec(boolean fixedSize) {
        this.fixedSize = fixedSize;
    }

    @Nullable
    public static NativeTypeSpec fromOrdinal(byte ordinal) {
        return ordinal < 0 || ordinal >= VALUES.length ? null : VALUES[ordinal];
    }

    public boolean fixedLength() {
        return this.fixedSize;
    }

    @Nullable
    public static NativeTypeSpec fromClass(Class<?> cls) {
        assert (cls != null);
        if (cls == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (cls == Byte.TYPE) {
            return INT8;
        }
        if (cls == Short.TYPE) {
            return INT16;
        }
        if (cls == Integer.TYPE) {
            return INT32;
        }
        if (cls == Long.TYPE) {
            return INT64;
        }
        if (cls == Float.TYPE) {
            return FLOAT;
        }
        if (cls == Double.TYPE) {
            return DOUBLE;
        }
        if (cls == Boolean.class) {
            return BOOLEAN;
        }
        if (cls == Byte.class) {
            return INT8;
        }
        if (cls == Short.class) {
            return INT16;
        }
        if (cls == Integer.class) {
            return INT32;
        }
        if (cls == Long.class) {
            return INT64;
        }
        if (cls == Float.class) {
            return FLOAT;
        }
        if (cls == Double.class) {
            return DOUBLE;
        }
        if (cls == LocalDate.class) {
            return DATE;
        }
        if (cls == LocalTime.class) {
            return TIME;
        }
        if (cls == LocalDateTime.class) {
            return DATETIME;
        }
        if (cls == Instant.class) {
            return TIMESTAMP;
        }
        if (cls == byte[].class) {
            return BYTES;
        }
        if (cls == String.class) {
            return STRING;
        }
        if (cls == UUID.class) {
            return UUID;
        }
        if (cls == BigDecimal.class) {
            return DECIMAL;
        }
        return null;
    }

    public static Class<?> toClass(NativeTypeSpec spec, boolean nullable) {
        assert (spec != null);
        switch (spec.ordinal()) {
            case 14: {
                return nullable ? Boolean.class : Boolean.TYPE;
            }
            case 0: {
                return nullable ? Byte.class : Byte.TYPE;
            }
            case 1: {
                return nullable ? Short.class : Short.TYPE;
            }
            case 2: {
                return nullable ? Integer.class : Integer.TYPE;
            }
            case 3: {
                return nullable ? Long.class : Long.TYPE;
            }
            case 4: {
                return nullable ? Float.class : Float.TYPE;
            }
            case 5: {
                return nullable ? Double.class : Double.TYPE;
            }
            case 9: {
                return byte[].class;
            }
            case 8: {
                return String.class;
            }
            case 10: {
                return LocalDate.class;
            }
            case 11: {
                return LocalTime.class;
            }
            case 13: {
                return Instant.class;
            }
            case 12: {
                return LocalDateTime.class;
            }
            case 7: {
                return UUID.class;
            }
            case 6: {
                return BigDecimal.class;
            }
        }
        throw new IllegalStateException("Unknown typeSpec " + String.valueOf((Object)spec));
    }

    public ColumnType asColumnType() {
        ColumnType columnType = this.asColumnTypeOrNull();
        if (columnType == null) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unsupported native type: " + String.valueOf((Object)this));
        }
        return columnType;
    }

    @Nullable
    public ColumnType asColumnTypeOrNull() {
        switch (this.ordinal()) {
            case 14: {
                return ColumnType.BOOLEAN;
            }
            case 0: {
                return ColumnType.INT8;
            }
            case 1: {
                return ColumnType.INT16;
            }
            case 2: {
                return ColumnType.INT32;
            }
            case 3: {
                return ColumnType.INT64;
            }
            case 4: {
                return ColumnType.FLOAT;
            }
            case 5: {
                return ColumnType.DOUBLE;
            }
            case 6: {
                return ColumnType.DECIMAL;
            }
            case 7: {
                return ColumnType.UUID;
            }
            case 8: {
                return ColumnType.STRING;
            }
            case 9: {
                return ColumnType.BYTE_ARRAY;
            }
            case 10: {
                return ColumnType.DATE;
            }
            case 11: {
                return ColumnType.TIME;
            }
            case 12: {
                return ColumnType.DATETIME;
            }
            case 13: {
                return ColumnType.TIMESTAMP;
            }
        }
        return null;
    }

    @Nullable
    public static NativeTypeSpec fromObject(@Nullable Object val) {
        return val != null ? NativeTypeSpec.fromClass(val.getClass()) : null;
    }

    public static NativeTypeSpec fromColumnType(ColumnType columnType) {
        switch (columnType) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case DATE: {
                return DATE;
            }
            case TIME: {
                return TIME;
            }
            case DATETIME: {
                return DATETIME;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case UUID: {
                return UUID;
            }
            case STRING: {
                return STRING;
            }
            case BYTE_ARRAY: {
                return BYTES;
            }
        }
        throw new IllegalArgumentException("No native type spec for column type: " + String.valueOf((Object)columnType));
    }

    public String toString() {
        return S.toString(NativeTypeSpec.class.getSimpleName(), "name", (Object)this.name(), "fixed", (Object)this.fixedLength());
    }

    private static /* synthetic */ NativeTypeSpec[] $values() {
        return new NativeTypeSpec[]{INT8, INT16, INT32, INT64, FLOAT, DOUBLE, DECIMAL, UUID, STRING, BYTES, DATE, TIME, DATETIME, TIMESTAMP, BOOLEAN};
    }

    static {
        $VALUES = NativeTypeSpec.$values();
        VALUES = NativeTypeSpec.values();
    }
}

