/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.deployment.uri.GridUriDeploymentFileResourceLoader;

final class GridUriDeploymentDiscovery {
    private GridUriDeploymentDiscovery() {
    }

    static Set<Class<? extends ComputeTask<?, ?>>> getClasses(ClassLoader clsLdr, File file) throws IgniteSpiException {
        HashSet rsrcs = new HashSet();
        if (!file.exists()) {
            return rsrcs;
        }
        GridUriDeploymentFileResourceLoader fileRsrcLdr = new GridUriDeploymentFileResourceLoader(clsLdr, file);
        if (file.isDirectory()) {
            GridUriDeploymentDiscovery.findResourcesInDirectory(fileRsrcLdr, file, rsrcs);
        } else {
            try {
                for (JarEntry entry : U.asIterable(new JarFile(file.getAbsolutePath()).entries())) {
                    Class<? extends ComputeTask<?, ?>> rsrc = fileRsrcLdr.createResource(entry.getName(), false);
                    if (rsrc == null) continue;
                    rsrcs.add(rsrc);
                }
            }
            catch (IOException e) {
                throw new IgniteSpiException("Failed to discover classes in file: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        return rsrcs;
    }

    private static void findResourcesInDirectory(GridUriDeploymentFileResourceLoader clsLdr, File dir, Set<Class<? extends ComputeTask<?, ?>>> rsrcs) {
        assert (dir.isDirectory());
        for (File file : dir.listFiles()) {
            Class<? extends ComputeTask<?, ?>> rsrc;
            block5: {
                if (file.isDirectory()) {
                    GridUriDeploymentDiscovery.findResourcesInDirectory(clsLdr, file, rsrcs);
                    continue;
                }
                rsrc = null;
                try {
                    rsrc = clsLdr.createResource(file.getAbsolutePath(), true);
                }
                catch (IgniteSpiException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            if (rsrc == null) continue;
            rsrcs.add(rsrc);
        }
    }
}

