/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryServerOnlyCustomMessage;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanTags;
import org.apache.ignite.internal.processors.tracing.messages.SpanContainer;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessage;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessagesTable;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutHelper;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.discovery.DiscoveryNotification;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoveryImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.DiscoveryDataPacket;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNodesRing;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAuthFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCheckFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientAckResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientMetricsUpdateMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientPingRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientPingResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientReconnectMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCustomEventMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDuplicateIdMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryHandshakeRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryHandshakeResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryJoinRequestMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryMetricsUpdateMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddFinishedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeLeftMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryPingRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryPingResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRingLatencyCheckMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryServerOnlyCustomEventMessage;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClientImpl
extends TcpDiscoveryImpl {
    private static final Object SPI_STOP = "SPI_STOP";
    private static final Object SPI_RECONNECT_FAILED = "SPI_RECONNECT_FAILED";
    private static final Object SPI_RECONNECT = "SPI_RECONNECT";
    private static final long CLIENT_THROTTLE_RECONNECT_RESET_TIMEOUT = IgniteSystemProperties.getLong("CLIENT_THROTTLE_RECONNECT_RESET_TIMEOUT_INTERVAL", 120000L);
    private final ConcurrentMap<UUID, TcpDiscoveryNode> rmtNodes = new ConcurrentHashMap<UUID, TcpDiscoveryNode>();
    private final List<DiscoveryDataPacket> delayDiscoData = new ArrayList<DiscoveryDataPacket>();
    private final NavigableMap<Long, Collection<ClusterNode>> topHist = new TreeMap<Long, Collection<ClusterNode>>();
    private final ConcurrentMap<UUID, GridFutureAdapter<Boolean>> pingFuts = new ConcurrentHashMap<UUID, GridFutureAdapter<Boolean>>();
    private SocketWriter sockWriter;
    private SocketReader sockReader;
    private volatile State state;
    private volatile IgniteUuid lastMsgId;
    private volatile long topVer;
    private final AtomicReference<IgniteSpiException> joinErr = new AtomicReference();
    private final CountDownLatch joinLatch = new CountDownLatch(1);
    private final CountDownLatch leaveLatch = new CountDownLatch(1);
    private final ScheduledExecutorService executorSrvc;
    private MessageWorker msgWorker;
    private TcpDiscoveryNodeFailedMessage forceFailMsg;
    @GridToStringExclude
    private int joinCnt;

    ClientImpl(TcpDiscoverySpi adapter) {
        super(adapter);
        String instanceName = adapter.ignite() == null || adapter.ignite().name() == null ? "client-node" : adapter.ignite().name();
        this.executorSrvc = Executors.newSingleThreadScheduledExecutor(new IgniteThreadFactory(instanceName, "tcp-discovery-exec"));
    }

    @Override
    public void dumpDebugInfo(IgniteLogger log) {
        StringBuilder b = new StringBuilder(U.nl());
        b.append(">>>").append(U.nl());
        b.append(">>>").append("Dumping discovery SPI debug info.").append(U.nl());
        b.append(">>>").append(U.nl());
        b.append("Local node ID: ").append(this.getLocalNodeId()).append(U.nl()).append(U.nl());
        b.append("Local node: ").append(this.locNode).append(U.nl()).append(U.nl());
        b.append("Internal threads: ").append(U.nl());
        b.append("    Message worker: ").append(ClientImpl.threadStatus(this.msgWorker.runner())).append(U.nl());
        b.append("    Socket reader: ").append(ClientImpl.threadStatus(this.sockReader)).append(U.nl());
        b.append("    Socket writer: ").append(ClientImpl.threadStatus(this.sockWriter)).append(U.nl());
        b.append(U.nl());
        b.append("Nodes: ").append(U.nl());
        for (ClusterNode node : this.allVisibleNodes()) {
            b.append("    ").append(node.id()).append(U.nl());
        }
        b.append(U.nl());
        b.append("Stats: ").append(this.spi.stats).append(U.nl());
        U.quietAndInfo(log, b.toString());
    }

    @Override
    public void dumpRingStructure(IgniteLogger log) {
        Object[] serverNodes = (ClusterNode[])this.getRemoteNodes().stream().filter(node -> !node.isClient()).sorted(Comparator.comparingLong(ClusterNode::order)).toArray(ClusterNode[]::new);
        U.quietAndInfo(log, Arrays.toString(serverNodes));
    }

    @Override
    public long getCurrentTopologyVersion() {
        return this.topVer;
    }

    @Override
    public String getSpiState() {
        if (this.sockWriter.isOnline()) {
            return "connected";
        }
        return "disconnected";
    }

    @Override
    public int getMessageWorkerQueueSize() {
        return this.msgWorker.queueSize();
    }

    @Override
    public UUID getCoordinator() {
        return null;
    }

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.spi.initLocalNode(0, true);
        this.locNode = this.spi.locNode;
        this.marshalCredentials(this.locNode);
        this.sockWriter = new SocketWriter();
        this.sockWriter.start();
        this.sockReader = new SocketReader();
        this.sockReader.start();
        if (this.spi.ipFinder.isShared() && this.spi.isForceServerMode()) {
            this.registerLocalNodeAddress();
        }
        this.msgWorker = new MessageWorker(this.log);
        new IgniteSpiThread(this.msgWorker.igniteInstanceName(), this.msgWorker.name(), this.log){

            @Override
            protected void body() {
                ClientImpl.this.msgWorker.run();
            }
        }.start();
        this.executorSrvc.scheduleAtFixedRate(new MetricsSender(), this.spi.metricsUpdateFreq, this.spi.metricsUpdateFreq, TimeUnit.MILLISECONDS);
        try {
            this.joinLatch.await();
            IgniteSpiException err = this.joinErr.get();
            if (err != null) {
                throw err;
            }
        }
        catch (InterruptedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", e);
        }
        this.spi.printStartInfo();
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        if (this.msgWorker != null && !this.msgWorker.isDone()) {
            this.msgWorker.addMessage(SPI_STOP);
            try {
                if (!this.leaveLatch.await(this.spi.netTimeout, TimeUnit.MILLISECONDS)) {
                    U.warn(this.log, "Failed to left node: timeout [nodeId=" + this.locNode + "]");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (GridFutureAdapter fut : this.pingFuts.values()) {
            fut.onDone(false);
        }
        this.rmtNodes.clear();
        if (this.msgWorker != null) {
            U.interrupt(this.msgWorker.runner());
        }
        U.interrupt(this.sockWriter);
        U.interrupt(this.sockReader);
        if (this.msgWorker != null) {
            U.join(this.msgWorker.runner(), this.log);
        }
        U.join(this.sockWriter, this.log);
        while (!U.join(this.sockReader, this.log, 200L)) {
            U.interrupt(this.sockReader);
        }
        this.executorSrvc.shutdownNow();
        this.spi.printStopInfo();
    }

    @Override
    public void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
    }

    @Override
    public Collection<ClusterNode> getRemoteNodes() {
        return U.arrayList(this.rmtNodes.values(), TcpDiscoveryNodesRing.VISIBLE_NODES);
    }

    @Override
    public boolean allNodesSupport(IgniteFeatures feature) {
        return IgniteFeatures.allNodesSupports(ClientImpl.upcast(this.rmtNodes.values()), feature);
    }

    @Override
    @Nullable
    public ClusterNode getNode(UUID nodeId) {
        if (this.getLocalNodeId().equals(nodeId)) {
            return this.locNode;
        }
        TcpDiscoveryNode node = (TcpDiscoveryNode)this.rmtNodes.get(nodeId);
        return node != null && node.visible() ? node : null;
    }

    @Override
    public boolean pingNode(@NotNull UUID nodeId) {
        if (nodeId.equals(this.getLocalNodeId())) {
            return true;
        }
        TcpDiscoveryNode node = (TcpDiscoveryNode)this.rmtNodes.get(nodeId);
        if (node == null || !node.visible()) {
            return false;
        }
        GridFutureAdapter<Boolean> fut = (GridFutureAdapter<Boolean>)this.pingFuts.get(nodeId);
        if (fut == null) {
            fut = new GridFutureAdapter<Boolean>();
            GridFutureAdapter oldFut = this.pingFuts.putIfAbsent(nodeId, fut);
            if (oldFut != null) {
                fut = oldFut;
            } else {
                State state = this.state;
                if (this.spi.getSpiContext().isStopping() || state == State.STOPPED || state == State.SEGMENTED) {
                    if (this.pingFuts.remove(nodeId, fut)) {
                        fut.onDone(false);
                    }
                    return false;
                }
                if (state == State.DISCONNECTED) {
                    if (this.pingFuts.remove(nodeId, fut)) {
                        fut.onDone(new IgniteClientDisconnectedCheckedException(null, "Failed to ping node, client node disconnected."));
                    }
                } else {
                    GridFutureAdapter<Boolean> finalFut = fut;
                    this.executorSrvc.schedule(() -> {
                        if (this.pingFuts.remove(nodeId, finalFut)) {
                            if (this.state == State.DISCONNECTED) {
                                finalFut.onDone(new IgniteClientDisconnectedCheckedException(null, "Failed to ping node, client node disconnected."));
                            } else {
                                finalFut.onDone(false);
                            }
                        }
                    }, this.spi.netTimeout, TimeUnit.MILLISECONDS);
                    this.sockWriter.sendMessage(new TcpDiscoveryClientPingRequest(this.getLocalNodeId(), nodeId));
                }
            }
        }
        try {
            return (Boolean)fut.get();
        }
        catch (IgniteInterruptedCheckedException ignored) {
            return false;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException(e);
        }
    }

    @Override
    public void disconnect() throws IgniteSpiException {
        if (this.msgWorker != null) {
            U.interrupt(this.msgWorker.runner());
        }
        U.interrupt(this.sockWriter);
        U.interrupt(this.sockReader);
        if (this.msgWorker != null) {
            U.join(this.msgWorker.runner(), this.log);
        }
        U.join(this.sockWriter, this.log);
        U.join(this.sockReader, this.log);
        this.leaveLatch.countDown();
        this.joinLatch.countDown();
        this.spi.getSpiContext().deregisterPorts();
        Collection<ClusterNode> rmts = this.getRemoteNodes();
        DiscoverySpiListener lsnr = this.spi.lsnr;
        if (lsnr != null) {
            for (ClusterNode n : rmts) {
                this.rmtNodes.remove(n.id());
                Collection<ClusterNode> top = this.updateTopologyHistory(this.topVer + 1L, null);
                lsnr.onDiscovery(new DiscoveryNotification(12, this.topVer, n, top, new TreeMap<Long, Collection<ClusterNode>>((SortedMap<Long, Collection<ClusterNode>>)this.topHist), null, null)).get();
            }
        }
        this.rmtNodes.clear();
    }

    @Override
    public void sendCustomEvent(DiscoverySpiCustomMessage evt) {
        State state = this.state;
        if (state == State.DISCONNECTED) {
            throw new IgniteClientDisconnectedException(null, "Failed to send custom message: client is disconnected.");
        }
        if (state == State.STOPPED || state == State.SEGMENTED || state == State.STARTING) {
            throw new IgniteException("Failed to send custom message: client is " + state.name().toLowerCase() + ".");
        }
        try {
            TcpDiscoveryCustomEventMessage msg = ((CustomMessageWrapper)evt).delegate() instanceof DiscoveryServerOnlyCustomMessage ? new TcpDiscoveryServerOnlyCustomEventMessage(this.getLocalNodeId(), evt, U.marshal(this.spi.marshaller(), (Object)evt)) : new TcpDiscoveryCustomEventMessage(this.getLocalNodeId(), evt, U.marshal(this.spi.marshaller(), (Object)evt));
            Span rootSpan = this.tracing.create(TraceableMessagesTable.traceName(msg.getClass())).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> this.getLocalNodeId().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> this.locNode.consistentId().toString()).addTag("message.class", () -> ((CustomMessageWrapper)evt).delegate().getClass().getSimpleName()).addLog(() -> "Created");
            msg.spanContainer().serializedSpanBytes(this.tracing.serialize(rootSpan));
            this.sockWriter.sendMessage(msg);
            rootSpan.addLog(() -> "Sent").end();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal custom event: " + evt, e);
        }
    }

    @Override
    public void failNode(UUID nodeId, @Nullable String warning) {
        TcpDiscoveryNode node = (TcpDiscoveryNode)this.rmtNodes.get(nodeId);
        if (node != null) {
            TcpDiscoveryNodeFailedMessage msg = new TcpDiscoveryNodeFailedMessage(this.getLocalNodeId(), node.id(), node.internalOrder());
            msg.warning(warning);
            msg.force(true);
            this.msgWorker.addMessage(msg);
        }
    }

    @Nullable
    private T2<SocketStream, Boolean> joinTopology(InetSocketAddress prevAddr, long timeout, @Nullable Runnable beforeEachSleep, @Nullable Runnable afterEachSleep) throws IgniteSpiException, InterruptedException {
        ArrayList<InetSocketAddress> addrs = null;
        long startNanos = System.nanoTime();
        while (true) {
            int idx;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (addrs == null || addrs.isEmpty()) {
                addrs = new ArrayList<InetSocketAddress>(this.spi.resolvedAddresses());
                if (!F.isEmpty(addrs)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Resolved addresses from IP finder: " + addrs);
                    continue;
                }
                if (timeout > 0L && U.millisSinceNanos(startNanos) > timeout) {
                    return null;
                }
                LT.warn(this.log, "IP finder returned empty addresses list. Please check IP finder configuration" + (this.spi.ipFinder instanceof TcpDiscoveryMulticastIpFinder ? " and make sure multicast works on your network. " : ". ") + "Will retry every " + this.spi.getReconnectDelay() + " ms. Change 'reconnectDelay' to configure the frequency of retries.", true);
                ClientImpl.sleepEx(this.spi.getReconnectDelay(), beforeEachSleep, afterEachSleep);
            }
            if (prevAddr != null && (idx = addrs.indexOf(prevAddr)) != -1) {
                Collections.swap(addrs, idx, 0);
            }
            ArrayList<InetSocketAddress> addrs0 = new ArrayList<InetSocketAddress>(addrs);
            boolean wait = false;
            block6: for (int i = addrs.size() - 1; i >= 0; --i) {
                InetSocketAddress addr;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                boolean recon = prevAddr != null;
                T3<SocketStream, Integer, Boolean> sockAndRes = this.sendJoinRequest(recon, addr = (InetSocketAddress)addrs.get(i));
                if (sockAndRes == null) {
                    addrs.remove(i);
                    continue;
                }
                assert (sockAndRes.get1() != null && sockAndRes.get2() != null) : sockAndRes;
                Socket sock = ((SocketStream)sockAndRes.get1()).socket();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received response to join request [addr=" + addr + ", res=" + sockAndRes.get2() + "]");
                }
                switch ((Integer)sockAndRes.get2()) {
                    case 1: {
                        return new T2<SocketStream, Boolean>((SocketStream)sockAndRes.get1(), (Boolean)sockAndRes.get3());
                    }
                    case 100: 
                    case 200: {
                        wait = true;
                        U.closeQuiet(sock);
                        continue block6;
                    }
                    default: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received unexpected response to join request: " + sockAndRes.get2());
                        }
                        U.closeQuiet(sock);
                    }
                }
            }
            if (timeout > 0L && U.millisSinceNanos(startNanos) > timeout) {
                return null;
            }
            if (wait) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Will wait before retry join.");
                }
                ClientImpl.sleepEx(this.spi.getReconnectDelay(), beforeEachSleep, afterEachSleep);
                continue;
            }
            if (!addrs.isEmpty()) continue;
            LT.warn(this.log, "Failed to connect to any address from IP finder (will retry to join topology every " + this.spi.getReconnectDelay() + " ms; change 'reconnectDelay' to configure the frequency of retries): " + ClientImpl.toOrderedList(addrs0), true);
            ClientImpl.sleepEx(this.spi.getReconnectDelay(), beforeEachSleep, afterEachSleep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleepEx(long millis, Runnable before, Runnable after) throws InterruptedException {
        if (before != null) {
            before.run();
        }
        try {
            Thread.sleep(millis);
        }
        finally {
            if (after != null) {
                after.run();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    private T3<SocketStream, Integer, Boolean> sendJoinRequest(boolean recon, InetSocketAddress addr) {
        if (!ClientImpl.$assertionsDisabled && addr == null) {
            throw new AssertionError();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Send join request [addr=" + addr + ", reconnect=" + recon + ", locNodeId=" + this.getLocalNodeId() + "]");
        }
        errs = null;
        ackTimeout0 = this.spi.getAckTimeout();
        reconCnt = 0;
        connectAttempts = 1;
        sslConnectAttempts = 3;
        locNodeId = this.getLocalNodeId();
        timeoutHelper = new IgniteSpiOperationTimeoutHelper(this.spi, true);
        discoveryData = null;
        while (true) {
            openSock = false;
            sock = null;
            try {
                tsNanos = System.nanoTime();
                sock = this.spi.openSocket(addr, timeoutHelper);
                openSock = true;
                req = new TcpDiscoveryHandshakeRequest(locNodeId);
                req.client(true);
                this.spi.writeToSocket(sock, req, timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                res = (TcpDiscoveryHandshakeResponse)this.spi.readMessage(sock, null, ackTimeout0);
                rmtNodeId = res.creatorNodeId();
                if (!ClientImpl.$assertionsDisabled && rmtNodeId == null) {
                    throw new AssertionError();
                }
                if (!ClientImpl.$assertionsDisabled && this.getLocalNodeId().equals(rmtNodeId)) {
                    throw new AssertionError();
                }
                this.locNode.clientRouterNodeId(rmtNodeId);
                tsNanos = System.nanoTime();
                if (!recon) {
                    node = this.locNode;
                    if (this.locNode.order() > 0L) {
                        node = this.locNode.clientReconnectNode(this.spi.locNodeAttrs);
                        this.marshalCredentials(node);
                    }
                    if (discoveryData == null) {
                        dataPacket = new DiscoveryDataPacket(this.getLocalNodeId());
                        dataPacket.joiningNodeClient(true);
                        discoveryData = this.spi.collectExchangeData(dataPacket);
                    }
                    joinReqMsg = new TcpDiscoveryJoinRequestMessage(node, discoveryData);
                    nodef = node;
                    joinReqMsg.spanContainer().span(this.tracing.create(TraceableMessagesTable.traceName(joinReqMsg.getClass())).addTag(SpanTags.tag(new String[]{SpanTags.EVENT_NODE, "id"}), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$sendJoinRequest$8(org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode ), ()Ljava/lang/String;)((TcpDiscoveryNode)nodef)).addTag(SpanTags.tag(new String[]{SpanTags.EVENT_NODE, "consistent.id"}), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$sendJoinRequest$9(org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode ), ()Ljava/lang/String;)((TcpDiscoveryNode)nodef)).addLog((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$sendJoinRequest$10(), ()Ljava/lang/String;)()).end());
                    msg /* !! */  = joinReqMsg;
                } else {
                    msg /* !! */  = new TcpDiscoveryClientReconnectMessage(this.getLocalNodeId(), rmtNodeId, this.lastMsgId);
                }
                msg /* !! */ .client(true);
                if (msg /* !! */  instanceof TraceableMessage) {
                    this.tracing.messages().beforeSend((TraceableMessage)msg /* !! */ );
                }
                this.spi.writeToSocket(sock, msg /* !! */ , timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                this.spi.stats.onMessageSent(msg /* !! */ , U.millisSinceNanos(tsNanos));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message has been sent to address [msg=" + msg /* !! */  + ", addr=" + addr + ", rmtNodeId=" + rmtNodeId + "]");
                }
                return new T3<SocketStream, Integer, Boolean>(new SocketStream(sock), this.spi.readReceipt(sock, timeoutHelper.nextTimeoutChunk(ackTimeout0)), res.clientAck());
            }
            catch (IOException | IgniteCheckedException e) {
                U.closeQuiet(sock);
                if (this.log.isDebugEnabled()) {
                    this.log.error("Exception on joining: " + e.getMessage(), e);
                }
                this.onException("Exception on joining: " + e.getMessage(), e);
                if (errs == null) {
                    errs = new ArrayList<Exception>();
                }
                errs.add(e);
                if (X.hasCause((Throwable)e, new Class[]{SSLException.class})) {
                    if (--sslConnectAttempts != 0) continue;
                    throw new IgniteSpiException("Unable to establish secure connection. Was remote cluster configured with SSL? [rmtAddr=" + addr + ", errMsg=\"" + e.getMessage() + "\"]", e);
                }
                if (X.hasCause((Throwable)e, new Class[]{StreamCorruptedException.class})) {
                    if (connectAttempts < 2) {
                        ++connectAttempts;
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connect failed with StreamCorruptedException, skip address: " + addr);
                    }
                } else if (!IgniteSpiOperationTimeoutHelper.checkFailureTimeoutReached(e) && (this.spi.failureDetectionTimeoutEnabled() || ++reconCnt != this.spi.getReconnectCount())) {
                    if (!openSock) {
                        if (connectAttempts < 2) {
                            ++connectAttempts;
                            continue;
                        }
                    } else {
                        if (!this.spi.failureDetectionTimeoutEnabled() && (e instanceof SocketTimeoutException || X.hasCause((Throwable)e, new Class[]{SocketTimeoutException.class})) && !this.checkAckTimeout(ackTimeout0 *= 2L)) ** break;
                        continue;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to join to address [addr=" + addr + ", recon=" + recon + ", errs=" + errs + "]");
                }
                return null;
            }
            break;
        }
    }

    private void marshalCredentials(TcpDiscoveryNode node) throws IgniteSpiException {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
            Object creds = attrs.get("org.apache.ignite.security.cred");
            assert (!(creds instanceof byte[]));
            attrs.put("org.apache.ignite.security.cred", U.marshal(this.spi.marshaller(), creds));
            node.setAttributes(attrs);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal node security credentials: " + node.id(), e);
        }
    }

    private Collection<ClusterNode> updateTopologyHistory(long topVer, @Nullable TcpDiscoveryAbstractMessage msg) {
        this.topVer = topVer;
        if (!this.topHist.isEmpty() && topVer <= (Long)this.topHist.lastKey()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skip topology update since topology already updated [msg=" + msg + ", lastHistKey=" + this.topHist.lastKey() + ", topVer=" + topVer + ", locNode=" + this.locNode + "]");
            }
            Collection top = (Collection)this.topHist.get(topVer);
            assert (top != null) : "Failed to find topology history [msg=" + msg + ", hist=" + this.topHist + "]";
            return top;
        }
        NavigableSet<ClusterNode> allNodes = this.allVisibleNodes();
        if (!this.topHist.containsKey(topVer)) {
            assert (this.topHist.isEmpty() || (Long)this.topHist.lastKey() == topVer - 1L) : "lastVer=" + (this.topHist.isEmpty() ? null : (Long)this.topHist.lastKey()) + ", newVer=" + topVer + ", locNode=" + this.locNode + ", msg=" + msg;
            this.topHist.put(topVer, allNodes);
            if (this.topHist.size() > this.spi.topHistSize) {
                this.topHist.pollFirstEntry();
            }
            assert ((Long)this.topHist.lastKey() == topVer);
            assert (this.topHist.size() <= this.spi.topHistSize);
        }
        return allNodes;
    }

    private NavigableSet<ClusterNode> allVisibleNodes() {
        TreeSet<ClusterNode> allNodes = new TreeSet<ClusterNode>();
        for (TcpDiscoveryNode node : this.rmtNodes.values()) {
            if (!node.visible()) continue;
            allNodes.add(node);
        }
        allNodes.add(this.locNode);
        return allNodes;
    }

    @Override
    void simulateNodeFailure() {
        U.warn(this.log, "Simulating client node failure: " + this.getLocalNodeId());
        U.interrupt(this.sockWriter);
        if (this.msgWorker != null) {
            U.interrupt(this.msgWorker.runner());
        }
        U.join(this.sockWriter, this.log);
        if (this.msgWorker != null) {
            U.join(this.msgWorker.runner(), this.log);
        }
    }

    @Override
    public void reconnect() throws IgniteSpiException {
        this.msgWorker.addMessage(SPI_RECONNECT);
    }

    @Override
    public void brakeConnection() {
        SocketStream sockStream = this.msgWorker.currSock;
        if (sockStream != null) {
            U.closeQuiet(sockStream.socket());
        }
    }

    @Override
    public void checkRingLatency(int maxHops) {
        TcpDiscoveryRingLatencyCheckMessage msg = new TcpDiscoveryRingLatencyCheckMessage(this.getLocalNodeId(), maxHops);
        if (this.log.isInfoEnabled()) {
            this.log.info("Latency check initiated: " + msg.id());
        }
        this.sockWriter.sendMessage(msg);
    }

    @Override
    protected Collection<IgniteSpiThread> threads() {
        Thread runner;
        ArrayList<IgniteSpiThread> res = new ArrayList<IgniteSpiThread>();
        res.add(this.sockWriter);
        MessageWorker msgWorker0 = this.msgWorker;
        if (msgWorker0 != null && (runner = msgWorker0.runner()) instanceof IgniteSpiThread) {
            res.add((IgniteSpiThread)runner);
        }
        return res;
    }

    @Override
    public void updateMetrics(UUID nodeId, ClusterMetrics metrics, Map<Integer, CacheMetrics> cacheMetrics, long tsNanos) {
        TcpDiscoveryNode node;
        assert (nodeId != null);
        assert (metrics != null);
        assert (cacheMetrics != null);
        TcpDiscoveryNode tcpDiscoveryNode = node = nodeId.equals(this.getLocalNodeId()) ? this.locNode : (TcpDiscoveryNode)this.rmtNodes.get(nodeId);
        if (node != null && node.visible()) {
            node.setMetrics(metrics);
            node.setCacheMetrics(cacheMetrics);
            node.lastUpdateTimeNanos(tsNanos);
            this.msgWorker.notifyDiscovery(13, this.topVer, node, this.allVisibleNodes(), null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Received metrics from unknown node: " + nodeId);
        }
    }

    public void waitForClientMessagePrecessed() {
        Object last = this.msgWorker.queue.peekLast();
        while (last != null && !this.msgWorker.isDone() && this.msgWorker.queue.contains(last)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void joinError(IgniteSpiException err) {
        assert (err != null);
        this.joinErr.compareAndSet(null, err);
        this.joinLatch.countDown();
    }

    private WorkersRegistry getWorkersRegistry() {
        Ignite ignite = this.spi.ignite();
        return ignite instanceof IgniteEx ? ((IgniteEx)ignite).context().workersRegistry() : null;
    }

    private static /* synthetic */ String lambda$sendJoinRequest$10() {
        return "Created";
    }

    private static /* synthetic */ String lambda$sendJoinRequest$9(TcpDiscoveryNode nodef) {
        return nodef.consistentId().toString();
    }

    private static /* synthetic */ String lambda$sendJoinRequest$8(TcpDiscoveryNode nodef) {
        return nodef.id().toString();
    }

    static enum State {
        STARTING,
        CONNECTED,
        DISCONNECTED,
        SEGMENTED,
        STOPPED;

    }

    private static class SocketStream {
        private final Socket sock;
        private final InputStream in;

        public SocketStream(Socket sock) throws IOException {
            assert (sock != null);
            this.sock = sock;
            this.in = new BufferedInputStream(sock.getInputStream());
        }

        Socket socket() {
            return this.sock;
        }

        InputStream stream() {
            return this.in;
        }

        public String toString() {
            return this.sock.toString();
        }
    }

    private static class SocketClosedMessage {
        private final SocketStream sock;

        private SocketClosedMessage(SocketStream sock) {
            this.sock = sock;
        }
    }

    private static class JoinTimeout {
        private final int joinCnt;

        private JoinTimeout(int joinCnt) {
            this.joinCnt = joinCnt;
        }
    }

    protected class MessageWorker
    extends GridWorker {
        private final BlockingDeque<Object> queue;
        private SocketStream currSock;
        private Reconnector reconnector;
        private boolean nodeAdded;
        private long lastReconnectTsNanos;
        private long currentReconnectDelay;

        private MessageWorker(IgniteLogger log) {
            super(ClientImpl.this.spi.ignite().name(), "tcp-client-disco-msg-worker", log, ClientImpl.this.getWorkersRegistry());
            this.queue = new LinkedBlockingDeque<Object>();
            this.lastReconnectTsNanos = -1L;
            this.currentReconnectDelay = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException {
            ClientImpl.this.state = State.STARTING;
            this.updateHeartbeat();
            try {
                this.tryJoin();
                while (true) {
                    Object msg;
                    this.onIdle();
                    this.blockingSectionBegin();
                    try {
                        msg = this.queue.take();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    if (msg instanceof JoinTimeout) {
                        int joinCnt0 = ((JoinTimeout)msg).joinCnt;
                        if (ClientImpl.this.joinCnt != joinCnt0) continue;
                        if (ClientImpl.this.state == State.STARTING) {
                            ClientImpl.this.joinError(new IgniteSpiException("Join process timed out, did not receive response for join request (consider increasing 'joinTimeout' configuration property) [joinTimeout=" + ClientImpl.this.spi.joinTimeout + ", sock=" + this.currSock + "]"));
                            break;
                        }
                        if (ClientImpl.this.state != State.DISCONNECTED) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to reconnect, local node segmented [joinTimeout=" + ClientImpl.this.spi.joinTimeout + "]");
                        }
                        ClientImpl.this.state = State.SEGMENTED;
                        this.notifyDiscovery(14, ClientImpl.this.topVer, ClientImpl.this.locNode, ClientImpl.this.allVisibleNodes(), null);
                        continue;
                    }
                    if (msg == SPI_STOP) {
                        boolean connected = ClientImpl.this.state == State.CONNECTED;
                        ClientImpl.this.state = State.STOPPED;
                        assert (ClientImpl.this.spi.getSpiContext().isStopping());
                        if (connected && this.currSock != null) {
                            TcpDiscoveryNodeLeftMessage leftMsg = new TcpDiscoveryNodeLeftMessage(ClientImpl.this.getLocalNodeId());
                            leftMsg.client(true);
                            Span rootSpan = ClientImpl.this.tracing.create(TraceableMessagesTable.traceName(leftMsg.getClass())).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> ClientImpl.this.locNode.id().toString()).addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> ClientImpl.this.locNode.consistentId().toString()).addLog(() -> "Created");
                            leftMsg.spanContainer().serializedSpanBytes(ClientImpl.this.tracing.serialize(rootSpan));
                            ClientImpl.this.sockWriter.sendMessage(leftMsg);
                            rootSpan.addLog(() -> "Sent").end();
                            continue;
                        }
                        ClientImpl.this.leaveLatch.countDown();
                        continue;
                    }
                    if (msg == SPI_RECONNECT) {
                        if (ClientImpl.this.state != State.CONNECTED) continue;
                        if (this.reconnector != null) {
                            this.reconnector.cancel();
                            this.reconnector.join();
                            this.reconnector = null;
                        }
                        ClientImpl.this.sockWriter.forceLeave();
                        ClientImpl.this.sockReader.forceStopRead();
                        this.currSock = null;
                        this.queue.clear();
                        this.onDisconnected();
                        UUID newId = UUID.randomUUID();
                        U.quietAndWarn(this.log, "Local node will try to reconnect to cluster with new id due to network problems [newId=" + newId + ", prevId=" + ClientImpl.this.locNode.id() + ", locNode=" + ClientImpl.this.locNode + "]");
                        ClientImpl.this.locNode.onClientDisconnected(newId);
                        this.throttleClientReconnect();
                        this.tryJoin();
                        continue;
                    }
                    if (msg instanceof TcpDiscoveryNodeFailedMessage && ((TcpDiscoveryNodeFailedMessage)msg).failedNodeId().equals(ClientImpl.this.locNode.id())) {
                        TcpDiscoveryNodeFailedMessage msg0 = (TcpDiscoveryNodeFailedMessage)msg;
                        assert (msg0.force()) : msg0;
                        ClientImpl.this.forceFailMsg = msg0;
                        continue;
                    }
                    if (msg instanceof SocketClosedMessage) {
                        boolean join;
                        if (((SocketClosedMessage)msg).sock != this.currSock) continue;
                        Socket sock = this.currSock.sock;
                        InetSocketAddress prevAddr = new InetSocketAddress(sock.getInetAddress(), sock.getPort());
                        this.currSock = null;
                        boolean bl = join = ClientImpl.this.joinLatch.getCount() > 0L;
                        if (ClientImpl.this.spi.getSpiContext().isStopping() || ClientImpl.this.state == State.SEGMENTED) {
                            ClientImpl.this.leaveLatch.countDown();
                            if (!join) continue;
                            ClientImpl.this.joinError(new IgniteSpiException("Failed to connect to cluster: socket closed."));
                            break;
                        }
                        if (ClientImpl.this.forceFailMsg != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Connection closed, local node received force fail message, will not try to restore connection");
                            }
                            this.queue.addFirst(SPI_RECONNECT_FAILED);
                            continue;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Connection closed, will try to restore connection.");
                        }
                        assert (this.reconnector == null);
                        this.reconnector = new Reconnector(join, prevAddr);
                        this.reconnector.start();
                        continue;
                    }
                    if (msg == SPI_RECONNECT_FAILED) {
                        if (this.reconnector != null) {
                            this.reconnector.cancel();
                            this.reconnector.join();
                            this.reconnector = null;
                        } else assert (ClientImpl.this.forceFailMsg != null);
                        if (ClientImpl.this.spi.isClientReconnectDisabled()) {
                            if (ClientImpl.this.state == State.SEGMENTED || ClientImpl.this.state == State.STOPPED) continue;
                            if (ClientImpl.this.forceFailMsg != null) {
                                U.quietAndWarn(this.log, "Local node was dropped from cluster due to network problems [nodeInitiatedFail=" + ClientImpl.this.forceFailMsg.creatorNodeId() + ", msg=" + ClientImpl.this.forceFailMsg.warning() + "]");
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to restore closed connection, reconnect disabled, local node segmented [networkTimeout=" + ClientImpl.this.spi.netTimeout + "]");
                            }
                            ClientImpl.this.state = State.SEGMENTED;
                            this.notifyDiscovery(14, ClientImpl.this.topVer, ClientImpl.this.locNode, ClientImpl.this.allVisibleNodes(), null);
                            continue;
                        }
                        if (ClientImpl.this.state == State.STARTING || ClientImpl.this.state == State.CONNECTED) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to restore closed connection, will try to reconnect [networkTimeout=" + ClientImpl.this.spi.netTimeout + ", joinTimeout=" + ClientImpl.this.spi.joinTimeout + ", failMsg=" + ClientImpl.this.forceFailMsg + "]");
                            }
                            this.onDisconnected();
                        }
                        UUID newId = UUID.randomUUID();
                        if (ClientImpl.this.forceFailMsg != null) {
                            long delay = IgniteSystemProperties.getLong("IGNITE_DISCO_FAILED_CLIENT_RECONNECT_DELAY", 10000L);
                            if (delay > 0L) {
                                U.quietAndWarn(this.log, "Local node was dropped from cluster due to network problems, will try to reconnect with new id after " + delay + "ms (reconnect delay can be changed using IGNITE_DISCO_FAILED_CLIENT_RECONNECT_DELAY system property) [newId=" + newId + ", prevId=" + ClientImpl.this.locNode.id() + ", locNode=" + ClientImpl.this.locNode + ", nodeInitiatedFail=" + ClientImpl.this.forceFailMsg.creatorNodeId() + ", msg=" + ClientImpl.this.forceFailMsg.warning() + "]");
                                Thread.sleep(delay);
                            } else {
                                U.quietAndWarn(this.log, "Local node was dropped from cluster due to network problems, will try to reconnect with new id [newId=" + newId + ", prevId=" + ClientImpl.this.locNode.id() + ", locNode=" + ClientImpl.this.locNode + ", nodeInitiatedFail=" + ClientImpl.this.forceFailMsg.creatorNodeId() + ", msg=" + ClientImpl.this.forceFailMsg.warning() + "]");
                            }
                            ClientImpl.this.forceFailMsg = null;
                        } else if (this.log.isInfoEnabled()) {
                            this.log.info("Client node disconnected from cluster, will try to reconnect with new id [newId=" + newId + ", prevId=" + ClientImpl.this.locNode.id() + ", locNode=" + ClientImpl.this.locNode + "]");
                        }
                        ClientImpl.this.locNode.onClientDisconnected(newId);
                        this.tryJoin();
                        continue;
                    }
                    TcpDiscoveryAbstractMessage discoMsg = (TcpDiscoveryAbstractMessage)msg;
                    if (this.joining()) {
                        IgniteSpiException err = null;
                        if (discoMsg instanceof TcpDiscoveryDuplicateIdMessage) {
                            err = ClientImpl.this.spi.duplicateIdError((TcpDiscoveryDuplicateIdMessage)msg);
                        } else if (discoMsg instanceof TcpDiscoveryAuthFailedMessage) {
                            err = ClientImpl.this.spi.authenticationFailedError((TcpDiscoveryAuthFailedMessage)msg);
                        } else if (discoMsg instanceof TcpDiscoveryCheckFailedMessage) {
                            err = ClientImpl.this.spi.checkFailedError((TcpDiscoveryCheckFailedMessage)msg);
                        }
                        if (err != null) {
                            if (ClientImpl.this.state == State.DISCONNECTED) {
                                U.error(this.log, "Failed to reconnect, segment local node.", err);
                                ClientImpl.this.state = State.SEGMENTED;
                                this.notifyDiscovery(14, ClientImpl.this.topVer, ClientImpl.this.locNode, ClientImpl.this.allVisibleNodes(), null);
                            } else {
                                ClientImpl.this.joinError(err);
                            }
                            this.cancel();
                            break;
                        }
                    }
                    this.processDiscoveryMessage((TcpDiscoveryAbstractMessage)msg);
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (ClientImpl.this.spi.ignite() instanceof IgniteEx) {
                    ((IgniteEx)ClientImpl.this.spi.ignite()).context().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
                }
            }
            finally {
                SocketStream currSock = this.currSock;
                if (currSock != null) {
                    U.closeQuiet(currSock.socket());
                }
                if (ClientImpl.this.joinLatch.getCount() > 0L) {
                    ClientImpl.this.joinError(new IgniteSpiException("Some error in join process."));
                }
                if (this.reconnector != null) {
                    this.reconnector.cancel();
                    this.reconnector.join();
                }
            }
        }

        private void throttleClientReconnect() throws InterruptedException {
            if (this.currentReconnectDelay == -1L || U.millisSinceNanos(this.lastReconnectTsNanos) > CLIENT_THROTTLE_RECONNECT_RESET_TIMEOUT) {
                this.currentReconnectDelay = 0L;
            } else if (this.currentReconnectDelay == 0L) {
                this.currentReconnectDelay = 200L;
            } else {
                long maxDelay = ClientImpl.this.spi.failureDetectionTimeoutEnabled() ? ClientImpl.this.spi.clientFailureDetectionTimeout() : IgniteConfiguration.DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT.longValue();
                this.currentReconnectDelay = Math.min(maxDelay, (long)((int)((double)this.currentReconnectDelay * 1.5)));
            }
            if (this.currentReconnectDelay != 0L) {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                Thread.sleep(random.nextLong(this.currentReconnectDelay / 2L, this.currentReconnectDelay));
            }
            this.lastReconnectTsNanos = System.nanoTime();
        }

        private void onDisconnected() {
            ClientImpl.this.state = State.DISCONNECTED;
            this.nodeAdded = false;
            ClientImpl.this.delayDiscoData.clear();
            this.notifyDiscovery(16, ClientImpl.this.topVer, ClientImpl.this.locNode, ClientImpl.this.allVisibleNodes(), null);
            IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(null, "Failed to ping node, client node disconnected.");
            for (Map.Entry e : ClientImpl.this.pingFuts.entrySet()) {
                GridFutureAdapter fut = (GridFutureAdapter)e.getValue();
                if (!ClientImpl.this.pingFuts.remove(e.getKey(), fut)) continue;
                fut.onDone(err);
            }
        }

        private void tryJoin() throws InterruptedException {
            T2<SocketStream, Boolean> joinRes;
            assert (ClientImpl.this.state == State.DISCONNECTED || ClientImpl.this.state == State.STARTING) : ClientImpl.this.state;
            boolean join = ClientImpl.this.state == State.STARTING;
            ++ClientImpl.this.joinCnt;
            try {
                joinRes = ClientImpl.this.joinTopology(null, ClientImpl.this.spi.joinTimeout, new Runnable(){

                    @Override
                    public void run() {
                        MessageWorker.this.blockingSectionBegin();
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        MessageWorker.this.blockingSectionEnd();
                    }
                });
            }
            catch (IgniteSpiException e) {
                ClientImpl.this.joinError(e);
                return;
            }
            if (joinRes == null) {
                if (join) {
                    ClientImpl.this.joinError(new IgniteSpiException("Join process timed out (timeout = " + ClientImpl.this.spi.joinTimeout + ")."));
                } else {
                    ClientImpl.this.state = State.SEGMENTED;
                    this.notifyDiscovery(14, ClientImpl.this.topVer, ClientImpl.this.locNode, ClientImpl.this.allVisibleNodes(), null);
                }
                return;
            }
            this.currSock = (SocketStream)joinRes.get1();
            ClientImpl.this.sockWriter.setSocket(((SocketStream)joinRes.get1()).socket(), (Boolean)joinRes.get2());
            if (ClientImpl.this.spi.joinTimeout > 0L) {
                int joinCnt0 = ClientImpl.this.joinCnt;
                ClientImpl.this.executorSrvc.schedule(() -> this.queue.add(new JoinTimeout(joinCnt0)), ClientImpl.this.spi.joinTimeout, TimeUnit.MILLISECONDS);
            }
            ClientImpl.this.sockReader.setSocket((SocketStream)joinRes.get1(), ClientImpl.this.locNode.clientRouterNodeId());
        }

        protected void processDiscoveryMessage(TcpDiscoveryAbstractMessage msg) {
            assert (msg != null);
            assert (msg.verified() || msg.senderNodeId() == null);
            ClientImpl.this.spi.startMessageProcess(msg);
            ClientImpl.this.spi.stats.onMessageProcessingStarted(msg);
            if (msg instanceof TraceableMessage) {
                ClientImpl.this.tracing.messages().beforeSend((TraceableMessage)((Object)msg));
            }
            if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                this.processNodeAddedMessage((TcpDiscoveryNodeAddedMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeAddFinishedMessage) {
                this.processNodeAddFinishedMessage((TcpDiscoveryNodeAddFinishedMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeLeftMessage) {
                this.processNodeLeftMessage((TcpDiscoveryNodeLeftMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeFailedMessage) {
                this.processNodeFailedMessage((TcpDiscoveryNodeFailedMessage)msg);
            } else if (msg instanceof TcpDiscoveryMetricsUpdateMessage) {
                this.processMetricsUpdateMessage((TcpDiscoveryMetricsUpdateMessage)msg);
            } else if (msg instanceof TcpDiscoveryClientReconnectMessage) {
                this.processClientReconnectMessage((TcpDiscoveryClientReconnectMessage)msg);
            } else if (msg instanceof TcpDiscoveryCustomEventMessage) {
                this.processCustomMessage((TcpDiscoveryCustomEventMessage)msg);
            } else if (msg instanceof TcpDiscoveryClientPingResponse) {
                this.processClientPingResponse((TcpDiscoveryClientPingResponse)msg);
            } else if (msg instanceof TcpDiscoveryPingRequest) {
                this.processPingRequest();
            }
            ClientImpl.this.spi.stats.onMessageProcessingFinished(msg);
            if (msg instanceof TraceableMessage) {
                ClientImpl.this.tracing.messages().finishProcessing((TraceableMessage)((Object)msg));
            }
            if (ClientImpl.this.spi.ensured(msg) && ClientImpl.this.state == State.CONNECTED && !(msg instanceof TcpDiscoveryClientReconnectMessage)) {
                ClientImpl.this.lastMsgId = msg.id();
            }
        }

        private boolean joining() {
            State state = ClientImpl.this.state;
            return state == State.STARTING || state == State.DISCONNECTED;
        }

        private boolean disconnected() {
            return ClientImpl.this.state == State.DISCONNECTED;
        }

        private void processNodeAddedMessage(TcpDiscoveryNodeAddedMessage msg) {
            if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                return;
            }
            TcpDiscoveryNode node = msg.node();
            UUID newNodeId = node.id();
            if (ClientImpl.this.getLocalNodeId().equals(newNodeId)) {
                if (this.joining()) {
                    Collection<TcpDiscoveryNode> top = msg.topology();
                    if (top != null) {
                        ClientImpl.this.spi.gridStartTime = msg.gridStartTime();
                        if (this.disconnected()) {
                            ClientImpl.this.rmtNodes.clear();
                        }
                        for (TcpDiscoveryNode n : top) {
                            if (n.order() > 0L) {
                                n.visible(true);
                            }
                            ClientImpl.this.rmtNodes.put(n.id(), n);
                        }
                        ClientImpl.this.topHist.clear();
                        this.nodeAdded = true;
                        if (msg.topologyHistory() != null) {
                            ClientImpl.this.topHist.putAll(msg.topologyHistory());
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node added message with empty topology: " + msg);
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding node added message (this message has already been processed) [msg=" + msg + ", locNode=" + ClientImpl.this.locNode + "]");
                }
            } else if (this.nodeAdded()) {
                boolean topChanged;
                boolean bl = topChanged = ClientImpl.this.rmtNodes.putIfAbsent(newNodeId, node) == null;
                if (topChanged) {
                    DiscoveryDataPacket dataPacket;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Added new node to topology: " + node);
                    }
                    if ((dataPacket = msg.gridDiscoveryData()) != null && dataPacket.hasJoiningNodeData()) {
                        if (this.joining()) {
                            ClientImpl.this.delayDiscoData.add(dataPacket);
                        } else {
                            ClientImpl.this.spi.onExchange(dataPacket, U.resolveClassLoader(ClientImpl.this.spi.ignite().configuration()));
                        }
                    }
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore topology message, local node not added to topology: " + msg);
            }
        }

        private void processNodeAddFinishedMessage(TcpDiscoveryNodeAddFinishedMessage msg) {
            if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                return;
            }
            if (this.log.isInfoEnabled()) {
                for (ClusterNode clusterNode : ClientImpl.this.getRemoteNodes()) {
                    if (!clusterNode.id().equals(ClientImpl.this.locNode.clientRouterNodeId())) continue;
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Router node: " + clusterNode);
                    break;
                }
            }
            if (ClientImpl.this.getLocalNodeId().equals(msg.nodeId())) {
                if (this.joining()) {
                    DiscoveryDataPacket dataContainer = msg.clientDiscoData();
                    if (dataContainer != null) {
                        ClientImpl.this.spi.onExchange(dataContainer, U.resolveClassLoader(ClientImpl.this.spi.ignite().configuration()));
                    }
                    if (!ClientImpl.this.delayDiscoData.isEmpty()) {
                        for (DiscoveryDataPacket data : ClientImpl.this.delayDiscoData) {
                            ClientImpl.this.spi.onExchange(data, U.resolveClassLoader(ClientImpl.this.spi.ignite().configuration()));
                        }
                        ClientImpl.this.delayDiscoData.clear();
                    }
                    ClientImpl.this.locNode.setAttributes(msg.clientNodeAttributes());
                    ClientImpl.this.locNode.visible(true);
                    long l = msg.topologyVersion();
                    ClientImpl.this.locNode.order(l);
                    Iterator it = ClientImpl.this.topHist.keySet().iterator();
                    while (it.hasNext()) {
                        if ((Long)it.next() < l) continue;
                        it.remove();
                    }
                    Collection<ClusterNode> nodes = ClientImpl.this.updateTopologyHistory(l, msg);
                    boolean disconnected = this.disconnected();
                    ClientImpl.this.state = State.CONNECTED;
                    this.notifyDiscovery(10, l, ClientImpl.this.locNode, nodes, msg.spanContainer());
                    if (disconnected) {
                        this.notifyDiscovery(17, l, ClientImpl.this.locNode, nodes, null);
                        U.quietAndWarn(this.log, "Client node was reconnected after it was already considered failed by the server topology (this could happen after all servers restarted or due to a long network outage between the client and servers). All continuous queries and remote event listeners created by this client will be unsubscribed, consider listening to EVT_CLIENT_NODE_RECONNECTED event to restore them.");
                    }
                    ClientImpl.this.joinErr.set(null);
                    ClientImpl.this.joinLatch.countDown();
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding node add finished message (this message has already been processed) [msg=" + msg + ", locNode=" + ClientImpl.this.locNode + "]");
                }
            } else if (this.nodeAdded()) {
                boolean bl;
                TcpDiscoveryNode node = (TcpDiscoveryNode)ClientImpl.this.rmtNodes.get(msg.nodeId());
                if (node == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node add finished message since node is not found [msg=" + msg + "]");
                    }
                    return;
                }
                boolean bl2 = false;
                long topVer = msg.topologyVersion();
                assert (topVer > 0L) : msg;
                if (!node.visible()) {
                    node.order(topVer);
                    node.visible(true);
                    if (ClientImpl.this.spi.locNodeVer.equals(node.version())) {
                        node.version(ClientImpl.this.spi.locNodeVer);
                    }
                    bl = true;
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skip node join event, node already joined [msg=" + msg + ", node=" + node + "]");
                    }
                    assert (node.order() == topVer) : node;
                }
                Collection<ClusterNode> top = ClientImpl.this.updateTopologyHistory(topVer, msg);
                assert (top != null && top.contains(node)) : "Topology does not contain node [msg=" + msg + ", node=" + node + ", top=" + top + "]";
                if (ClientImpl.this.state != State.CONNECTED) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Discarding node add finished message (join process is not finished): " + msg);
                    }
                    return;
                }
                if (bl) {
                    this.notifyDiscovery(10, topVer, node, top, msg.spanContainer());
                    ClientImpl.this.spi.stats.onNodeJoined();
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore topology message, local node not added to topology: " + msg);
            }
        }

        private void processNodeLeftMessage(TcpDiscoveryNodeLeftMessage msg) {
            if (ClientImpl.this.getLocalNodeId().equals(msg.creatorNodeId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received node left message for local node: " + msg);
                }
                ClientImpl.this.leaveLatch.countDown();
            } else {
                if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                    return;
                }
                if (this.nodeAdded()) {
                    TcpDiscoveryNode node = (TcpDiscoveryNode)ClientImpl.this.rmtNodes.remove(msg.creatorNodeId());
                    if (node == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Discarding node left message since node is not found [msg=" + msg + "]");
                        }
                        return;
                    }
                    Collection<ClusterNode> top = ClientImpl.this.updateTopologyHistory(msg.topologyVersion(), msg);
                    if (ClientImpl.this.state != State.CONNECTED) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Discarding node left message (join process is not finished): " + msg);
                        }
                        return;
                    }
                    this.notifyDiscovery(11, msg.topologyVersion(), node, top, msg.spanContainer());
                    ClientImpl.this.spi.stats.onNodeLeft();
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Ignore topology message, local node not added to topology: " + msg);
                }
            }
        }

        private boolean nodeAdded() {
            return this.nodeAdded;
        }

        private void processNodeFailedMessage(TcpDiscoveryNodeFailedMessage msg) {
            if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                if (!ClientImpl.this.getLocalNodeId().equals(msg.creatorNodeId()) && ClientImpl.this.getLocalNodeId().equals(msg.failedNodeId()) && ClientImpl.this.leaveLatch.getCount() > 0L) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Remote node fail this node while node is stopping [locNode=" + ClientImpl.this.getLocalNodeId() + ", rmtNode=" + msg.creatorNodeId() + "]");
                    }
                    ClientImpl.this.leaveLatch.countDown();
                }
                return;
            }
            if (this.nodeAdded()) {
                if (!ClientImpl.this.getLocalNodeId().equals(msg.creatorNodeId())) {
                    TcpDiscoveryNode node = (TcpDiscoveryNode)ClientImpl.this.rmtNodes.remove(msg.failedNodeId());
                    if (node == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Discarding node failed message since node is not found [msg=" + msg + "]");
                        }
                        return;
                    }
                    Collection<ClusterNode> top = ClientImpl.this.updateTopologyHistory(msg.topologyVersion(), msg);
                    if (ClientImpl.this.state != State.CONNECTED) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Discarding node failed message (join process is not finished): " + msg);
                        }
                        return;
                    }
                    if (msg.warning() != null) {
                        ClusterNode creatorNode = (ClusterNode)ClientImpl.this.rmtNodes.get(msg.creatorNodeId());
                        U.warn(this.log, "Received EVT_NODE_FAILED event with warning [nodeInitiatedEvt=" + (creatorNode != null ? creatorNode : msg.creatorNodeId()) + ", msg=" + msg.warning() + "]");
                    }
                    this.notifyDiscovery(12, msg.topologyVersion(), node, top, msg.spanContainer());
                    ClientImpl.this.spi.stats.onNodeFailed();
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore topology message, local node not added to topology: " + msg);
            }
        }

        private void processMetricsUpdateMessage(TcpDiscoveryMetricsUpdateMessage msg) {
            if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                return;
            }
            if (ClientImpl.this.getLocalNodeId().equals(msg.creatorNodeId())) {
                assert (msg.senderNodeId() != null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received metrics response: " + msg);
                }
            } else if (msg.hasMetrics()) {
                ClientImpl.this.processMsgCacheMetrics(msg, System.nanoTime());
            }
        }

        private void processClientReconnectMessage(TcpDiscoveryClientReconnectMessage msg) {
            if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                return;
            }
            if (ClientImpl.this.getLocalNodeId().equals(msg.creatorNodeId())) {
                if (this.reconnector != null) {
                    assert (msg.success()) : msg;
                    this.currSock = this.reconnector.sockStream;
                    ClientImpl.this.sockWriter.setSocket(this.currSock.socket(), this.reconnector.clientAck);
                    ClientImpl.this.sockReader.setSocket(this.currSock, ClientImpl.this.locNode.clientRouterNodeId());
                    this.reconnector = null;
                    for (TcpDiscoveryAbstractMessage pendingMsg : msg.pendingMessages()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Process pending message on reconnect [msg=" + pendingMsg + "]");
                        }
                        this.processDiscoveryMessage(pendingMsg);
                    }
                } else if (ClientImpl.this.joinLatch.getCount() > 0L) {
                    if (msg.success()) {
                        for (TcpDiscoveryAbstractMessage pendingMsg : msg.pendingMessages()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Process pending message on connect [msg=" + pendingMsg + "]");
                            }
                            this.processDiscoveryMessage(pendingMsg);
                        }
                        assert (ClientImpl.this.joinLatch.getCount() == 0L) : msg;
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Discarding reconnect message, reconnect is completed: " + msg);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Discarding reconnect message for another client: " + msg);
            }
        }

        private void processCustomMessage(TcpDiscoveryCustomEventMessage msg) {
            DiscoverySpiListener lsnr;
            if (ClientImpl.this.state == State.CONNECTED && (lsnr = ClientImpl.this.spi.lsnr) != null) {
                TcpDiscoveryNode node;
                UUID nodeId = msg.creatorNodeId();
                TcpDiscoveryNode tcpDiscoveryNode = node = nodeId.equals(ClientImpl.this.getLocalNodeId()) ? ClientImpl.this.locNode : (TcpDiscoveryNode)ClientImpl.this.rmtNodes.get(nodeId);
                if (node != null && node.visible()) {
                    try {
                        DiscoverySpiCustomMessage msgObj = msg.message(ClientImpl.this.spi.marshaller(), U.resolveClassLoader(ClientImpl.this.spi.ignite().configuration()));
                        this.notifyDiscovery(18, ClientImpl.this.topVer, node, ClientImpl.this.allVisibleNodes(), msgObj, msg.spanContainer());
                    }
                    catch (Throwable e) {
                        U.error(this.log, "Failed to unmarshal discovery custom message.", e);
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Received metrics from unknown node: " + nodeId);
                }
            }
        }

        private void processClientPingResponse(TcpDiscoveryClientPingResponse msg) {
            GridFutureAdapter fut = (GridFutureAdapter)ClientImpl.this.pingFuts.remove(msg.nodeToPing());
            if (fut != null) {
                fut.onDone(msg.result());
            }
        }

        private void processPingRequest() {
            TcpDiscoveryPingResponse res = new TcpDiscoveryPingResponse(ClientImpl.this.getLocalNodeId());
            res.client(true);
            ClientImpl.this.sockWriter.sendMessage(res);
        }

        private void updateMetrics(UUID nodeId, ClusterMetrics metrics, Map<Integer, CacheMetrics> cacheMetrics, long tsNanos) {
            TcpDiscoveryNode node;
            assert (nodeId != null);
            assert (metrics != null);
            assert (cacheMetrics != null);
            TcpDiscoveryNode tcpDiscoveryNode = node = nodeId.equals(ClientImpl.this.getLocalNodeId()) ? ClientImpl.this.locNode : (TcpDiscoveryNode)ClientImpl.this.rmtNodes.get(nodeId);
            if (node != null && node.visible()) {
                node.setMetrics(metrics);
                node.setCacheMetrics(cacheMetrics);
                node.lastUpdateTimeNanos(tsNanos);
                this.notifyDiscovery(13, ClientImpl.this.topVer, node, ClientImpl.this.allVisibleNodes(), null);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Received metrics from unknown node: " + nodeId);
            }
        }

        private void notifyDiscovery(int type, long topVer, ClusterNode node, Collection<ClusterNode> top, SpanContainer spanContainer) {
            this.notifyDiscovery(type, topVer, node, top, null, spanContainer);
        }

        private void notifyDiscovery(int type, long topVer, ClusterNode node, Collection<ClusterNode> top, @Nullable DiscoverySpiCustomMessage data, SpanContainer spanContainer) {
            TcpDiscoveryImpl.DebugLogger debugLog;
            DiscoverySpiListener lsnr = ClientImpl.this.spi.lsnr;
            TcpDiscoveryImpl.DebugLogger debugLogger = debugLog = type == 13 ? ClientImpl.this.traceLog : ClientImpl.this.debugLog;
            if (lsnr != null) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug("Discovery notification [node=" + node + ", type=" + U.gridEventName(type) + ", topVer=" + topVer + "]");
                }
                lsnr.onDiscovery(new DiscoveryNotification(type, topVer, node, top, new TreeMap<Long, Collection<ClusterNode>>((SortedMap<Long, Collection<ClusterNode>>)ClientImpl.this.topHist), data, spanContainer)).get();
            } else if (debugLog.isDebugEnabled()) {
                debugLog.debug("Skipped discovery notification [node=" + node + ", type=" + U.gridEventName(type) + ", topVer=" + topVer + "]");
            }
        }

        void addMessage(Object msg) {
            if (msg instanceof TraceableMessage && msg instanceof TcpDiscoveryAbstractMessage) {
                TraceableMessage tMsg = (TraceableMessage)msg;
                if (!((TcpDiscoveryAbstractMessage)msg).verified() && tMsg.spanContainer().serializedSpanBytes() == null) {
                    Span rootSpan = ClientImpl.this.tracing.create(TraceableMessagesTable.traceName(tMsg.getClass())).end();
                    tMsg.spanContainer().serializedSpanBytes(ClientImpl.this.tracing.serialize(rootSpan));
                }
            }
            this.queue.add(msg);
        }

        int queueSize() {
            return this.queue.size();
        }
    }

    private class Reconnector
    extends IgniteSpiThread {
        private volatile SocketStream sockStream;
        private boolean clientAck;
        private final boolean join;
        private final InetSocketAddress prevAddr;

        protected Reconnector(boolean join, InetSocketAddress prevAddr) {
            super(ClientImpl.this.spi.ignite().name(), "tcp-client-disco-reconnector", ClientImpl.this.log);
            this.join = join;
            this.prevAddr = prevAddr;
        }

        public void cancel() {
            this.interrupt();
            SocketStream sockStream = this.sockStream;
            if (sockStream != null) {
                U.closeQuiet(sockStream.socket());
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void body() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class SocketWriter
    extends IgniteSpiThread {
        private final Object mux;
        private Socket sock;
        private boolean clientAck;
        private final Queue<TcpDiscoveryAbstractMessage> queue;
        private final long sockTimeout;
        private TcpDiscoveryAbstractMessage unackedMsg;
        private CountDownLatch forceLeaveLatch;

        SocketWriter() {
            super(ClientImpl.this.spi.ignite().name(), "tcp-client-disco-sock-writer", ClientImpl.this.log);
            this.mux = new Object();
            this.queue = new ArrayDeque<TcpDiscoveryAbstractMessage>();
            this.sockTimeout = ClientImpl.this.spi.failureDetectionTimeoutEnabled() ? ClientImpl.this.spi.failureDetectionTimeout() : ClientImpl.this.spi.getSocketTimeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(TcpDiscoveryAbstractMessage msg) {
            Object object = this.mux;
            synchronized (object) {
                this.queue.add(msg);
                this.mux.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceLeave() throws InterruptedException {
            CountDownLatch forceLeaveLatch;
            Object object = this.mux;
            synchronized (object) {
                if (this.sock == null) {
                    return;
                }
                this.forceLeaveLatch = forceLeaveLatch = new CountDownLatch(1);
                this.unackedMsg = null;
                this.mux.notifyAll();
            }
            forceLeaveLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSocket(Socket sock, boolean clientAck) {
            Object object = this.mux;
            synchronized (object) {
                this.sock = sock;
                this.clientAck = clientAck;
                this.unackedMsg = null;
                this.mux.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOnline() {
            Object object = this.mux;
            synchronized (object) {
                return this.sock != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ackReceived(TcpDiscoveryClientAckResponse res) {
            Object object = this.mux;
            synchronized (object) {
                if (this.unackedMsg != null) {
                    assert (this.unackedMsg.id().equals(res.messageId())) : this.unackedMsg;
                    this.unackedMsg = null;
                }
                this.mux.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException {
            TcpDiscoveryAbstractMessage msg = null;
            while (!Thread.currentThread().isInterrupted()) {
                Socket sock;
                Iterator<IgniteInClosure<TcpDiscoveryAbstractMessage>> iterator = this.mux;
                synchronized (iterator) {
                    sock = this.sock;
                    if (sock == null) {
                        this.mux.wait();
                        continue;
                    }
                    if (this.forceLeaveLatch != null) {
                        block34: {
                            msg = new TcpDiscoveryNodeLeftMessage(ClientImpl.this.getLocalNodeId());
                            msg.client(true);
                            try {
                                ClientImpl.this.spi.writeToSocket(sock, msg, this.sockTimeout);
                            }
                            catch (IOException | IgniteCheckedException exception) {
                                if (!ClientImpl.this.log.isDebugEnabled()) break block34;
                                ClientImpl.this.log.debug("Failed to send TcpDiscoveryNodeLeftMessage on force leave [msg=" + msg + ", err=" + exception.getMessage() + "]");
                            }
                        }
                        U.closeQuiet(sock);
                        this.sock = null;
                        this.clear();
                        continue;
                    }
                    if (msg == null) {
                        msg = this.queue.poll();
                    }
                    if (msg == null) {
                        this.mux.wait();
                        continue;
                    }
                }
                for (IgniteInClosure<TcpDiscoveryAbstractMessage> igniteInClosure : ClientImpl.this.spi.sndMsgLsnrs) {
                    igniteInClosure.apply(msg);
                }
                boolean ack = this.clientAck && !(msg instanceof TcpDiscoveryPingResponse);
                try {
                    TcpDiscoveryAbstractMessage unacked;
                    IgniteUuid igniteUuid;
                    if (ack) {
                        Object object = this.mux;
                        synchronized (object) {
                            assert (this.unackedMsg == null) : "Unacked=" + this.unackedMsg + ", received=" + msg;
                            this.unackedMsg = msg;
                        }
                    }
                    ClientImpl.this.spi.writeToSocket(sock, msg, this.sockTimeout);
                    IgniteUuid igniteUuid2 = igniteUuid = msg instanceof TcpDiscoveryRingLatencyCheckMessage ? msg.id() : null;
                    if (igniteUuid != null && ClientImpl.this.log.isInfoEnabled()) {
                        ClientImpl.this.log.info("Latency check message has been written to socket: " + igniteUuid);
                    }
                    msg = null;
                    if (!ack) continue;
                    long waitEndNanos = System.nanoTime() + U.millisToNanos(ClientImpl.this.spi.failureDetectionTimeoutEnabled() ? ClientImpl.this.spi.failureDetectionTimeout() : ClientImpl.this.spi.getAckTimeout());
                    Object object = this.mux;
                    synchronized (object) {
                        long nowNanos = System.nanoTime();
                        while (this.unackedMsg != null && waitEndNanos - nowNanos > 0L) {
                            this.mux.wait(U.nanosToMillis(waitEndNanos - nowNanos));
                            nowNanos = System.nanoTime();
                        }
                        unacked = this.unackedMsg;
                        this.unackedMsg = null;
                    }
                    if (unacked != null) {
                        if (ClientImpl.this.log.isDebugEnabled()) {
                            ClientImpl.this.log.debug("Failed to get acknowledge for message, will try to reconnect [msg=" + unacked + (ClientImpl.this.spi.failureDetectionTimeoutEnabled() ? ", failureDetectionTimeout=" + ClientImpl.this.spi.failureDetectionTimeout() : ", timeout=" + ClientImpl.this.spi.getAckTimeout()) + "]");
                        }
                        throw new IOException("Failed to get acknowledge for message: " + unacked);
                    }
                    if (igniteUuid == null || !ClientImpl.this.log.isInfoEnabled()) continue;
                    ClientImpl.this.log.info("Latency check message has been acked: " + igniteUuid);
                }
                catch (InterruptedException interruptedException) {
                    if (ClientImpl.this.log.isDebugEnabled()) {
                        ClientImpl.this.log.debug("Client socket writer interrupted.");
                    }
                    return;
                }
                catch (Exception exception) {
                    if (ClientImpl.this.spi.getSpiContext().isStopping()) {
                        if (ClientImpl.this.log.isDebugEnabled()) {
                            ClientImpl.this.log.debug("Failed to send message, node is stopping [msg=" + msg + ", err=" + exception + "]");
                        }
                    } else {
                        U.error(ClientImpl.this.log, "Failed to send message: " + msg, exception);
                    }
                    U.closeQuiet(sock);
                    Object object = this.mux;
                    synchronized (object) {
                        if (sock == this.sock) {
                            this.sock = null;
                        }
                        this.clear();
                    }
                }
            }
        }

        private void clear() {
            assert (Thread.holdsLock(this.mux));
            this.queue.clear();
            this.unackedMsg = null;
            CountDownLatch forceLeaveLatch = this.forceLeaveLatch;
            if (forceLeaveLatch != null) {
                this.forceLeaveLatch = null;
                forceLeaveLatch.countDown();
            }
        }
    }

    private class SocketReader
    extends IgniteSpiThread {
        private final Object mux;
        private SocketStream sockStream;
        private UUID rmtNodeId;
        private CountDownLatch stopReadLatch;

        SocketReader() {
            super(ClientImpl.this.spi.ignite().name(), "tcp-client-disco-sock-reader-[]", ClientImpl.this.log);
            this.mux = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSocket(SocketStream sockStream, UUID rmtNodeId) {
            Object object = this.mux;
            synchronized (object) {
                this.sockStream = sockStream;
                this.rmtNodeId = rmtNodeId;
                this.mux.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceStopRead() throws InterruptedException {
            CountDownLatch stopReadLatch;
            Object object = this.mux;
            synchronized (object) {
                SocketStream stream = this.sockStream;
                if (stream == null) {
                    return;
                }
                this.stopReadLatch = stopReadLatch = new CountDownLatch(1);
                U.closeQuiet(stream.socket());
                this.sockStream = null;
                this.rmtNodeId = null;
                this.mux.notifyAll();
            }
            stopReadLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException {
            while (!this.isInterrupted()) {
                UUID rmtNodeId;
                SocketStream sockStream;
                U.enhanceThreadName("");
                Object object = this.mux;
                synchronized (object) {
                    if (this.stopReadLatch != null) {
                        this.stopReadLatch.countDown();
                        this.stopReadLatch = null;
                    }
                    if (this.sockStream == null) {
                        this.mux.wait();
                        continue;
                    }
                    sockStream = this.sockStream;
                    rmtNodeId = this.rmtNodeId;
                }
                Socket sock = sockStream.socket();
                U.enhanceThreadName(U.id8(rmtNodeId) + " " + sockStream.sock.getInetAddress().getHostAddress() + ":" + sockStream.sock.getPort());
                try {
                    InputStream in = sockStream.stream();
                    assert (sock.getKeepAlive() && sock.getTcpNoDelay()) : "Socket wasn't configured properly: KeepAlive " + sock.getKeepAlive() + " TcpNoDelay " + sock.getTcpNoDelay();
                    while (!this.isInterrupted()) {
                        TcpDiscoveryAbstractMessage msg;
                        try {
                            msg = (TcpDiscoveryAbstractMessage)U.unmarshal(ClientImpl.this.spi.marshaller(), in, U.resolveClassLoader(ClientImpl.this.spi.ignite().configuration()));
                        }
                        catch (IgniteCheckedException e) {
                            IOException ioEx;
                            if (ClientImpl.this.log.isDebugEnabled()) {
                                U.error(ClientImpl.this.log, "Failed to read message [sock=" + sock + ", locNodeId=" + ClientImpl.this.getLocalNodeId() + ", rmtNodeId=" + rmtNodeId + "]", e);
                            }
                            if (X.hasCause((Throwable)e, InterruptedException.class, InterruptedIOException.class, IgniteInterruptedCheckedException.class, IgniteInterruptedException.class)) {
                                this.interrupt();
                            }
                            if ((ioEx = X.cause(e, IOException.class)) != null) {
                                throw ioEx;
                            }
                            ClassNotFoundException clsNotFoundEx = X.cause(e, ClassNotFoundException.class);
                            if (clsNotFoundEx != null) {
                                LT.warn(ClientImpl.this.log, "Failed to read message due to ClassNotFoundException (make sure same versions of all classes are available on all nodes) [rmtNodeId=" + rmtNodeId + ", err=" + clsNotFoundEx.getMessage() + "]");
                                continue;
                            }
                            LT.error(ClientImpl.this.log, e, "Failed to read message [sock=" + sock + ", locNodeId=" + ClientImpl.this.getLocalNodeId() + ", rmtNodeId=" + rmtNodeId + "]");
                            continue;
                        }
                        msg.senderNodeId(rmtNodeId);
                        TcpDiscoveryImpl.DebugLogger debugLog = ClientImpl.this.messageLogger(msg);
                        if (debugLog.isDebugEnabled()) {
                            debugLog.debug("Message has been received: " + msg);
                        }
                        ClientImpl.this.spi.stats.onMessageReceived(msg);
                        boolean ack = msg instanceof TcpDiscoveryClientAckResponse;
                        if (!ack) {
                            ClientImpl.this.msgWorker.addMessage(msg);
                            continue;
                        }
                        ClientImpl.this.sockWriter.ackReceived((TcpDiscoveryClientAckResponse)msg);
                    }
                }
                catch (IOException e) {
                    ClientImpl.this.msgWorker.addMessage(new SocketClosedMessage(sockStream));
                    if (!ClientImpl.this.log.isDebugEnabled()) continue;
                    U.error(ClientImpl.this.log, "Connection failed [sock=" + sock + ", locNodeId=" + ClientImpl.this.getLocalNodeId() + "]", e);
                }
                finally {
                    U.closeQuiet(sock);
                    Object object2 = this.mux;
                    synchronized (object2) {
                        if (this.sockStream == sockStream) {
                            this.sockStream = null;
                            this.rmtNodeId = null;
                        }
                    }
                }
            }
        }
    }

    private class MetricsSender
    implements Runnable {
        private MetricsSender() {
        }

        @Override
        public void run() {
            if (!ClientImpl.this.spi.getSpiContext().isStopping() && ClientImpl.this.sockWriter.isOnline()) {
                TcpDiscoveryClientMetricsUpdateMessage msg = new TcpDiscoveryClientMetricsUpdateMessage(ClientImpl.this.getLocalNodeId(), ClientImpl.this.spi.metricsProvider.metrics());
                msg.client(true);
                ClientImpl.this.sockWriter.sendMessage(msg);
            }
        }
    }
}

