/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheTtlUpdateRequest
extends GridCacheIdMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridDirectCollection(value=GridCacheVersion.class)
    private List<GridCacheVersion> vers;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> nearKeys;
    @GridDirectCollection(value=GridCacheVersion.class)
    private List<GridCacheVersion> nearVers;
    private long ttl;
    private AffinityTopologyVersion topVer;

    public GridCacheTtlUpdateRequest() {
    }

    public GridCacheTtlUpdateRequest(int cacheId, AffinityTopologyVersion topVer, long ttl) {
        assert (ttl >= 0L || ttl == -2L) : ttl;
        this.cacheId = cacheId;
        this.topVer = topVer;
        this.ttl = ttl;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public long ttl() {
        return this.ttl;
    }

    public void addEntry(KeyCacheObject key, GridCacheVersion ver) {
        if (this.keys == null) {
            this.keys = new ArrayList<KeyCacheObject>();
            this.vers = new ArrayList<GridCacheVersion>();
        }
        this.keys.add(key);
        this.vers.add(ver);
    }

    public void addNearEntry(KeyCacheObject key, GridCacheVersion ver) {
        if (this.nearKeys == null) {
            this.nearKeys = new ArrayList<KeyCacheObject>();
            this.nearVers = new ArrayList<GridCacheVersion>();
        }
        this.nearKeys.add(key);
        this.nearVers.add(ver);
    }

    public List<KeyCacheObject> keys() {
        return this.keys;
    }

    public List<GridCacheVersion> versions() {
        return this.vers;
    }

    public GridCacheVersion version(int idx) {
        assert (idx >= 0 && idx < this.vers.size()) : idx;
        return this.vers.get(idx);
    }

    public List<KeyCacheObject> nearKeys() {
        return this.nearKeys;
    }

    public List<GridCacheVersion> nearVersions() {
        return this.nearVers;
    }

    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.keys, cctx);
        this.prepareMarshalCacheObjects(this.nearKeys, cctx);
    }

    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearKeys, cctx, ldr);
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("nearKeys", this.nearKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("nearVers", this.nearVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeLong("ttl", this.ttl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("vers", this.vers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.nearKeys = (List)reader.readCollection("nearKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.nearVers = (List)reader.readCollection("nearVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.ttl = reader.readLong("ttl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.vers = (List)reader.readCollection("vers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheTtlUpdateRequest.class);
    }

    @Override
    public short directType() {
        return 20;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheTtlUpdateRequest.class, this, "super", (Object)super.toString());
    }
}

