/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Date;
import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.running.GridRunningQueryInfo;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class SqlQueryView {
    private final GridRunningQueryInfo qry;

    public SqlQueryView(GridRunningQueryInfo qry) {
        this.qry = qry;
    }

    @Order(value=2)
    public UUID originNodeId() {
        return this.qry.nodeId();
    }

    @Order
    public String queryId() {
        return this.qry.globalQueryId();
    }

    @Order(value=1)
    public String sql() {
        return this.qry.query();
    }

    public String schemaName() {
        return this.qry.schemaName();
    }

    @Order(value=3)
    public Date startTime() {
        return new Date(this.qry.startTime());
    }

    @Order(value=4)
    public long duration() {
        return U.currentTimeMillis() - this.qry.startTime();
    }

    @Order(value=7)
    public String initiatorId() {
        return this.qry.queryInitiatorId();
    }

    public boolean local() {
        return this.qry.local();
    }

    @Nullable
    public UUID subjectId() {
        return this.qry.subjectId();
    }
}

