/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.collection;

import java.util.Collection;
import java.util.function.IntFunction;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.jetbrains.annotations.Nullable;

public interface IntMap<V> {
    public boolean containsKey(int var1);

    public boolean containsValue(V var1);

    public V get(int var1);

    public V put(int var1, V var2);

    public V remove(int var1);

    public V putIfAbsent(int var1, V var2);

    public <E extends Throwable> void forEach(EntryConsumer<V, E> var1) throws E;

    public int size();

    public boolean isEmpty();

    public int[] keys();

    public Collection<V> values();

    public void clear();

    @Nullable
    default public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        V newVal;
        A.notNull(mappingFunction, "mappingFunction");
        V v = this.get(key);
        if (v == null && (newVal = mappingFunction.apply(key)) != null) {
            this.put(key, newVal);
            return newVal;
        }
        return v;
    }

    public static interface EntryConsumer<V, E extends Throwable> {
        public void accept(int var1, V var2) throws E;
    }
}

