/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.util.typedef.F;

public final class QueryContext {
    private static final Object[] EMPTY = new Object[0];
    private final Object[] params;

    private QueryContext(Object[] params) {
        this.params = params;
    }

    public <C> C unwrap(Class<C> aClass) {
        if (Object[].class == aClass) {
            return aClass.cast(this.params);
        }
        return Arrays.stream(this.params).filter(aClass::isInstance).findFirst().map(aClass::cast).orElse(null);
    }

    public static QueryContext of(Object ... params) {
        return !F.isEmpty(params) ? new QueryContext(QueryContext.build(null, params).toArray()) : new QueryContext(EMPTY);
    }

    private static List<Object> build(List<Object> dst, Object[] src) {
        if (dst == null) {
            dst = new ArrayList<Object>();
        }
        for (Object obj : src) {
            if (obj == null) continue;
            if (obj.getClass() == QueryContext.class) {
                QueryContext.build(dst, ((QueryContext)obj).params);
                continue;
            }
            dst.add(obj);
        }
        return dst;
    }
}

