/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree;

import java.util.Arrays;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedDataStructureException;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class CorruptedTreeException
extends CorruptedDataStructureException {
    private static final long serialVersionUID = 0L;

    public CorruptedTreeException(String msg, @Nullable Throwable cause, String grpName, int grpId, long ... pageIds) {
        this(msg, null, null, grpName, cause, grpId, pageIds);
    }

    public CorruptedTreeException(String msg, @Nullable Throwable cause, String grpName, String cacheName, String indexName, int grpId, long ... pageIds) {
        this(msg, cacheName, indexName, grpName, cause, grpId, pageIds);
    }

    public CorruptedTreeException(String msg, String cacheName, String indexName, String grpName, @Nullable Throwable cause, int grpId, long ... pageIds) {
        super(CorruptedTreeException.getMsg(msg, cacheName, indexName, grpName, grpId, pageIds), cause, grpId, pageIds);
    }

    private static String getMsg(String msg, @Nullable String cacheName, @Nullable String indexName, @Nullable String grpName, int grpId, long ... pageIds) {
        SB sb = new SB("B+Tree is corrupted [groupId=");
        sb.a(grpId).a(", pageIds=").a(Arrays.toString(pageIds));
        if (cacheName != null) {
            sb.a(", cacheId=").a(CU.cacheId(cacheName)).a(", cacheName=").a(cacheName);
        }
        if (indexName != null) {
            sb.a(", indexName=").a(indexName);
        }
        if (grpName != null) {
            sb.a(", groupName=").a(grpName);
        }
        sb.a(", msg=").a(msg).a(']');
        return sb.toString();
    }
}

