/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance;

import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.CachePartitionDefragmentationManager;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExecuteDefragmentationAction
implements MaintenanceAction<Boolean> {
    private final IgniteLogger log;
    private final CachePartitionDefragmentationManager defrgMgr;
    private final FailureProcessor failureProc;

    public ExecuteDefragmentationAction(Function<Class<?>, IgniteLogger> logFunction, CachePartitionDefragmentationManager defrgMgr, FailureProcessor failureProc) {
        this.log = logFunction.apply(ExecuteDefragmentationAction.class);
        this.defrgMgr = defrgMgr;
        this.failureProc = failureProc;
    }

    @Override
    public Boolean execute() {
        try {
            this.defrgMgr.beforeDefragmentation();
        }
        catch (IgniteCheckedException | IgniteException e) {
            this.log.error("Checkpoint before defragmentation failed", e);
            return false;
        }
        Thread defrgThread = new Thread(() -> {
            try {
                this.defrgMgr.executeDefragmentation();
            }
            catch (Throwable e) {
                this.log.error("Defragmentation failed", e);
                this.failureProc.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
        });
        defrgThread.setName("defragmentation-thread");
        defrgThread.setDaemon(true);
        defrgThread.start();
        return true;
    }

    @Override
    @NotNull
    public String name() {
        return "execute";
    }

    @Override
    @Nullable
    public String description() {
        return "Starting the process of defragmentation.";
    }
}

