/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class JdbcUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillData(BenchmarkConfiguration cfg, IgniteEx ignite, long range, CacheAtomicityMode atomicMode) {
        IgniteSemaphore sem = ignite.semaphore("sql-setup", 1, true, true);
        try {
            if (sem.tryAcquire()) {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Create table...");
                StringBuilder qry = new StringBuilder("CREATE TABLE test_long (id LONG PRIMARY KEY, val LONG) WITH \"wrap_value=true");
                if (atomicMode != null) {
                    qry.append(", atomicity=").append(atomicMode.name());
                }
                qry.append("\";");
                String qryStr = qry.toString();
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Creating table with schema: " + qryStr));
                GridQueryProcessor qProc = ignite.context().query();
                qProc.querySqlFields(new SqlFieldsQuery(qryStr), true);
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populate data...");
                for (long l = 1L; l <= range; ++l) {
                    qProc.querySqlFields(new SqlFieldsQuery("INSERT INTO test_long (id, val) VALUES (?, ?)").setArgs(new Object[]{l, l + 1L}), true);
                    if (l % 10000L != 0L) continue;
                    BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populate " + l));
                }
                qProc.querySqlFields(new SqlFieldsQuery("CREATE INDEX val_idx ON test_long (val)"), true);
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Finished populating data");
            } else {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Waits for setup...");
                sem.acquire();
            }
        }
        finally {
            sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillTableWithIdx(BenchmarkConfiguration cfg, IgniteEx ignite, String tblName, long range, CacheAtomicityMode atomicMode) {
        IgniteSemaphore sem = ignite.semaphore("sql-setup", 1, true, true);
        try {
            if (sem.tryAcquire()) {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Create table...");
                StringBuilder qry = new StringBuilder(String.format("CREATE TABLE %s (", tblName) + "id LONG PRIMARY KEY, DEC_COL DECIMAL, DATE_COL DATE, BIG_INT_COL BIGINT) WITH \"wrap_value=true");
                if (atomicMode != null) {
                    qry.append(", atomicity=").append(atomicMode.name());
                }
                qry.append("\";");
                String qryStr = qry.toString();
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Creating table with schema: " + qryStr));
                GridQueryProcessor qProc = ignite.context().query();
                qProc.querySqlFields(new SqlFieldsQuery(qryStr), true);
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populate data...");
                for (long r = 1L; r < range; ++r) {
                    qProc.querySqlFields(new SqlFieldsQuery(String.format("INSERT INTO %s VALUES (?, ?, ?, ?)", tblName)).setArgs(new Object[]{r, new BigDecimal(r + 1L), LocalDate.ofEpochDay(r), r + 2L}), true);
                    if (r % 10000L != 0L) continue;
                    BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populate " + r));
                }
                qProc.querySqlFields(new SqlFieldsQuery(String.format("CREATE INDEX idx1 ON %s (DEC_COL, DATE_COL) inline_size 16", tblName)), true);
                qProc.querySqlFields(new SqlFieldsQuery(String.format("CREATE INDEX idx2 ON %s (DATE_COL, BIG_INT_COL) inline_size 16", tblName)), true);
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Finished populating data");
            } else {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Waits for setup...");
                sem.acquire();
            }
        }
        finally {
            sem.release();
        }
    }
}

