/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public class IgniteGetAllPutAllTxBytesKeyBenchmark
extends IgniteCacheAbstractBenchmark<byte[], Integer> {
    private IgniteTransactions txs;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.txs = this.ignite().transactions();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteCacheAbstractBenchmark.ThreadRange r = this.threadRange();
        IgniteBenchmarkUtils.doInTransaction(this.txs, this.args.txConcurrency(), this.args.txIsolation(), () -> {
            TreeMap<byte[], Integer> vals = new TreeMap<byte[], Integer>(Comparator.comparing(String::new));
            for (int i = 0; i < this.args.batch(); ++i) {
                int base = r.nextRandom();
                byte[] key = String.valueOf(base).getBytes();
                vals.put(key, base);
            }
            IgniteCache cache = this.cacheForOperation();
            cache.getAll(vals.keySet());
            cache.putAll(vals);
            return null;
        });
        return true;
    }

    @Override
    protected IgniteCache<byte[], Integer> cache() {
        return this.ignite().cache("tx");
    }
}

