/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.calcite.Query;
import org.apache.ignite.internal.processors.query.calcite.QueryRegistry;
import org.apache.ignite.internal.processors.query.calcite.RootQuery;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.running.RunningQueryManager;
import org.apache.ignite.internal.processors.query.running.TrackableQuery;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class QueryRegistryImpl
extends AbstractService
implements QueryRegistry {
    private final ConcurrentMap<UUID, Query<?>> runningQrys = new ConcurrentHashMap();
    protected final GridKernalContext kctx;

    public QueryRegistryImpl(GridKernalContext ctx) {
        super(ctx);
        this.kctx = ctx;
    }

    @Override
    public Query<?> register(Query<?> qry) {
        return this.runningQrys.computeIfAbsent(qry.id(), k -> {
            if (!(qry instanceof RootQuery)) {
                return qry;
            }
            RootQuery rootQry = (RootQuery)qry;
            RunningQueryManager qryMgr = this.kctx.query().runningQueryManager();
            SqlFieldsQuery fieldsQry = rootQry.context().unwrap(SqlFieldsQuery.class);
            String initiatorId = fieldsQry != null ? fieldsQry.getQueryInitiatorId() : null;
            long locId = qryMgr.register(rootQry.sql(), GridCacheQueryType.SQL_FIELDS, rootQry.context().schemaName(), false, QueryRegistryImpl.createCancelToken(qry), initiatorId, false, true, false);
            rootQry.localQueryId(locId);
            qryMgr.heavyQueriesTracker().startTracking((TrackableQuery)rootQry);
            return qry;
        });
    }

    @Override
    public Query<?> query(UUID id) {
        return (Query)this.runningQrys.get(id);
    }

    @Override
    public void unregister(UUID id, @Nullable Throwable failReason) {
        Query val = (Query)this.runningQrys.remove(id);
        if (val instanceof RootQuery) {
            RootQuery qry = (RootQuery)val;
            this.kctx.query().runningQueryManager().unregister(qry.localQueryId(), failReason);
            this.kctx.query().runningQueryManager().heavyQueriesTracker().stopTracking((TrackableQuery)qry, failReason);
        }
    }

    @Override
    public Collection<? extends Query<?>> runningQueries() {
        return this.runningQrys.values();
    }

    @Override
    public void tearDown() {
        this.runningQrys.values().forEach(q -> IgniteUtils.close(q::cancel, (IgniteLogger)this.log));
        this.runningQrys.clear();
    }

    private static GridQueryCancel createCancelToken(Query<?> qry) {
        GridQueryCancel token = new GridQueryCancel();
        try {
            token.add(qry::cancel);
        }
        catch (QueryCancelledException queryCancelledException) {
            // empty catch block
        }
        return token;
    }
}

