/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkExecutionAwareProbe;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkProbePointWriter;
import org.yardstickframework.BenchmarkTotalsOnlyProbe;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.impl.BenchmarkLoader;
import org.yardstickframework.writers.BenchmarkProbePointCsvWriter;

public class BenchmarkProbeSet {
    public static final int PROBE_DUMP_FREQ = 1000;
    private final Map<BenchmarkProbe, BenchmarkProbePointWriter> writers;
    private final Collection<BenchmarkProbe> probes;
    private final List<BenchmarkExecutionAwareProbe> execProbes;
    private Thread fileWriterThread;
    private final BenchmarkConfiguration cfg;
    private final BenchmarkDriver driver;
    private final BenchmarkLoader ldr;
    private final CountDownLatch warmupFinished = new CountDownLatch(1);
    private volatile boolean finished;

    public BenchmarkProbeSet(BenchmarkDriver driver, BenchmarkConfiguration cfg, Collection<BenchmarkProbe> probes, BenchmarkLoader ldr) {
        this.cfg = cfg;
        this.driver = driver;
        this.ldr = ldr;
        this.probes = probes;
        this.writers = new HashMap<BenchmarkProbe, BenchmarkProbePointWriter>(probes.size());
        this.execProbes = new ArrayList<BenchmarkExecutionAwareProbe>(probes.size());
    }

    public void start() throws Exception {
        String writerClsName = this.cfg.probeWriterClassName();
        if (writerClsName == null) {
            BenchmarkUtils.println(this.cfg, "Probe writer is not configured (using default CSV writer)");
            writerClsName = BenchmarkProbePointCsvWriter.class.getName();
        }
        boolean warn = true;
        long writersStartTime = System.currentTimeMillis();
        for (BenchmarkProbe probe : this.probes) {
            BenchmarkProbePointWriter writer = this.ldr.loadClass(BenchmarkProbePointWriter.class, writerClsName);
            if (writer == null) {
                if (warn) {
                    BenchmarkUtils.println(this.cfg, "Failed to load writer class (will use default CSV writer): " + writerClsName);
                    warn = false;
                }
                writer = new BenchmarkProbePointCsvWriter();
            }
            this.writers.put(probe, writer);
            if (probe instanceof BenchmarkExecutionAwareProbe) {
                this.execProbes.add((BenchmarkExecutionAwareProbe)probe);
            }
            writer.start(this.driver, this.cfg, writersStartTime);
        }
        try {
            for (BenchmarkProbe probe : this.writers.keySet()) {
                probe.start(this.driver, this.cfg);
            }
        }
        catch (Exception e) {
            this.stopProbes();
            throw e;
        }
        if (!this.probes.isEmpty()) {
            this.fileWriterThread = new Thread("probe-dump-thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BenchmarkProbePointWriter writer;
                    BenchmarkProbe probe;
                    try {
                        BenchmarkProbeSet.this.warmupFinished.await();
                        while (!Thread.currentThread().isInterrupted()) {
                            Thread.sleep(1000L);
                            for (Map.Entry entry : BenchmarkProbeSet.this.writers.entrySet()) {
                                probe = (BenchmarkProbe)entry.getKey();
                                if (probe instanceof BenchmarkTotalsOnlyProbe) continue;
                                writer = (BenchmarkProbePointWriter)entry.getValue();
                                Collection<BenchmarkProbePoint> points = probe.points();
                                try {
                                    writer.writePoints(probe, points);
                                }
                                catch (Exception e) {
                                    BenchmarkUtils.errorHelp(BenchmarkProbeSet.this.cfg, "Exception is raised during point write.", e);
                                }
                            }
                            if (!BenchmarkProbeSet.this.finished) continue;
                            break;
                        }
                    }
                    catch (InterruptedException i$) {
                        for (Map.Entry entry : BenchmarkProbeSet.this.writers.entrySet()) {
                            BenchmarkProbe probe2 = (BenchmarkProbe)entry.getKey();
                            if (probe2 instanceof BenchmarkTotalsOnlyProbe) {
                                BenchmarkProbePointWriter writer2 = (BenchmarkProbePointWriter)entry.getValue();
                                try {
                                    writer2.writePoints(probe2, probe2.points());
                                }
                                catch (Exception e) {
                                    BenchmarkUtils.errorHelp(BenchmarkProbeSet.this.cfg, "Exception is raised during point write.", e);
                                }
                            }
                            try {
                                ((BenchmarkProbePointWriter)entry.getValue()).close();
                            }
                            catch (Exception e) {
                                BenchmarkUtils.errorHelp(BenchmarkProbeSet.this.cfg, "Failed to gracefully close probe writer [probe=" + entry.getKey() + ", writer=" + entry.getValue() + ", err=" + e.getMessage() + ']', e);
                            }
                        }
                    }
                    finally {
                        for (Map.Entry entry : BenchmarkProbeSet.this.writers.entrySet()) {
                            probe = (BenchmarkProbe)entry.getKey();
                            if (probe instanceof BenchmarkTotalsOnlyProbe) {
                                writer = (BenchmarkProbePointWriter)entry.getValue();
                                try {
                                    writer.writePoints(probe, probe.points());
                                }
                                catch (Exception e) {
                                    BenchmarkUtils.errorHelp(BenchmarkProbeSet.this.cfg, "Exception is raised during point write.", e);
                                }
                            }
                            try {
                                ((BenchmarkProbePointWriter)entry.getValue()).close();
                            }
                            catch (Exception e) {
                                BenchmarkUtils.errorHelp(BenchmarkProbeSet.this.cfg, "Failed to gracefully close probe writer [probe=" + entry.getKey() + ", writer=" + entry.getValue() + ", err=" + e.getMessage() + ']', e);
                            }
                        }
                    }
                }
            };
            this.fileWriterThread.start();
        }
    }

    public void onBeforeExecute(int threadIdx) {
        for (int i = 0; i < this.execProbes.size(); ++i) {
            this.execProbes.get(i).beforeExecute(threadIdx);
        }
    }

    public void onAfterExecute(int threadIdx) {
        for (int i = 0; i < this.execProbes.size(); ++i) {
            this.execProbes.get(i).afterExecute(threadIdx);
        }
    }

    public void buildPoint(long time) {
        for (BenchmarkProbe probe : this.probes) {
            probe.buildPoint(time);
        }
    }

    public void onWarmupFinished() {
        for (Map.Entry<BenchmarkProbe, BenchmarkProbePointWriter> entry : this.writers.entrySet()) {
            BenchmarkProbe probe = entry.getKey();
            probe.points();
        }
        this.warmupFinished.countDown();
    }

    public void onFinished() {
        this.finished = true;
    }

    public void stop() throws Exception {
        if (this.fileWriterThread != null) {
            this.fileWriterThread.interrupt();
            this.fileWriterThread.join();
        }
        this.stopProbes();
    }

    private void stopProbes() {
        for (BenchmarkProbe probe : this.writers.keySet()) {
            try {
                probe.stop();
            }
            catch (Exception e) {
                BenchmarkUtils.errorHelp(this.cfg, "Failed to gracefully stop probe [probe=" + probe + ", err=" + e.getMessage() + ']', e);
            }
        }
    }
}

