/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.options;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.storage.blob.models.CustomerProvidedKey;
import org.apache.beam.sdk.io.azure.blobstore.DefaultBlobstoreClientBuilderFactory;
import org.apache.beam.sdk.io.azure.options.AzureOptions;
import org.apache.beam.sdk.io.azure.options.BlobstoreClientBuilderFactory;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface BlobstoreOptions
extends AzureOptions {
    @Description(value="Factory class that should be created and used to create a builder of Azure Blobstore client.Override the default value if you need a Azure client with custom properties.")
    @Default.Class(value=DefaultBlobstoreClientBuilderFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BlobstoreClientBuilderFactory> getBlobstoreClientFactoryClass();

    public void setBlobstoreClientFactoryClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BlobstoreClientBuilderFactory> var1);

    @Description(value="Adds a pipeline policy to apply on each request sent to the blob service client.")
    public @Nullable @UnknownKeyFor @Initialized HttpPipelinePolicy getPipelinePolicy();

    public void setPipelinePolicy(@UnknownKeyFor @NonNull @Initialized HttpPipelinePolicy var1);

    @Description(value="Sets the connection string to connect to the Azure Blobstore client.")
    public @UnknownKeyFor @NonNull @Initialized String getAzureConnectionString();

    public void setAzureConnectionString(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Sets the SAS token used to authorize requests sent to the service.")
    public @UnknownKeyFor @NonNull @Initialized String getSasToken();

    public void setSasToken(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Blobstore account name")
    public @UnknownKeyFor @NonNull @Initialized String getAccountName();

    public void setAccountName(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Azure Blobstore access key")
    public @UnknownKeyFor @NonNull @Initialized String getAccessKey();

    public void setAccessKey(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Sets the customer provided key that is used to encrypt blob contents on the server.")
    public @UnknownKeyFor @NonNull @Initialized CustomerProvidedKey getCustomerProvidedKey();

    public void setCustomerProvidedKey(@UnknownKeyFor @NonNull @Initialized CustomerProvidedKey var1);

    @Description(value="Sets the blob service endpoint, additionally parses it for information (SAS token)")
    public @Nullable @UnknownKeyFor @Initialized String getBlobServiceEndpoint();

    public void setBlobServiceEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Sets the HttpClient to use for sending a receiving requests to and from the service.")
    public @Nullable @UnknownKeyFor @Initialized HttpClient getHttpClient();

    public void setHttpClient(@UnknownKeyFor @NonNull @Initialized HttpClient var1);

    @Description(value="Sets the HttpPipeline to use for the service client.")
    public @Nullable @UnknownKeyFor @Initialized HttpPipeline getHttpPipeline();

    public void setHttpPipeline(@UnknownKeyFor @NonNull @Initialized HttpPipeline var1);
}

